/*
 * Decompiled with CFR 0.152.
 */
package com.github.hetianyi.plugins.generator.pojo.generator.feature.extend.jackson;

import com.github.hetianyi.plugins.generator.common.SlotType;
import com.github.hetianyi.plugins.generator.pojo.entity.TableColumn;
import com.github.hetianyi.plugins.generator.pojo.generator.feature.CustomFeature;
import com.github.hetianyi.plugins.generator.pojo.generator.slot.CodeSlot;
import com.github.hetianyi.plugins.generator.pojo.generator.slot.IndentSlot;
import com.google.common.collect.ImmutableList;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DateFormatAnnotationFeature
extends CustomFeature {
    private static final Logger log = LoggerFactory.getLogger(DateFormatAnnotationFeature.class);

    public DateFormatAnnotationFeature() {
        super(SlotType.FIELD_HEAD, CustomFeature.InsertLocation.AFTER, (s, g) -> {
            TableColumn column = (TableColumn)s.getAttribute("column");
            String format = "";
            boolean add = false;
            if (Objects.equals(column.getType(), "datetime") || Objects.equals(column.getType(), "timestamp")) {
                format = "yyyy-MM-dd HH:mm:ss";
                add = true;
            } else if (Objects.equals(column.getType(), "date")) {
                format = "yyyy-MM-dd";
                add = true;
            } else if (Objects.equals(column.getType(), "time")) {
                format = "HH:mm:ss";
                add = true;
            }
            if (add) {
                g.getImports().add("org.springframework.format.annotation.DateTimeFormat");
                return ImmutableList.of((Object)IndentSlot.getInstance(), (Object)CodeSlot.of("@DateTimeFormat(pattern = \"" + format + "\")\n"));
            }
            return null;
        });
        log.debug("\u5e94\u7528Feature -> DateFormatAnnotationFeature");
    }
}

