/*
 * Decompiled with CFR 0.152.
 */
package com.github.hetianyi.plugins.generator.pojo.generator.feature.extend.swagger;

import com.github.hetianyi.boot.ready.common.util.StringUtil;
import com.github.hetianyi.plugins.generator.common.SlotType;
import com.github.hetianyi.plugins.generator.pojo.entity.TableColumn;
import com.github.hetianyi.plugins.generator.pojo.generator.feature.CustomFeature;
import com.github.hetianyi.plugins.generator.pojo.generator.slot.CodeSlot;
import com.github.hetianyi.plugins.generator.pojo.generator.slot.IndentSlot;
import com.google.common.collect.ImmutableList;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SwaggerApiModelPropertyAnnotationFeature
extends CustomFeature {
    private static final Logger log = LoggerFactory.getLogger(SwaggerApiModelPropertyAnnotationFeature.class);

    public SwaggerApiModelPropertyAnnotationFeature() {
        super(SlotType.FIELD_HEAD, CustomFeature.InsertLocation.AFTER, (s, g) -> {
            TableColumn column = (TableColumn)s.getAttribute("column");
            if (StringUtil.isNullOrEmptyTrimed((String)column.getComment())) {
                return null;
            }
            g.getImports().add("io.swagger.annotations.ApiModelProperty");
            return ImmutableList.of((Object)IndentSlot.getInstance(), (Object)CodeSlot.of("@ApiModelProperty(\"", Optional.ofNullable(column.getComment()).orElse("").replace("\r\n", "\n").replaceAll("\n", "\\\\n\\\\n"), "\")\n"));
        });
        log.debug("\u5e94\u7528Feature -> SwaggerApiModelPropertyAnnotationFeature");
    }
}

