/*
 * Decompiled with CFR 0.152.
 */
package com.github.hetianyi.plugins.generator.pojo.generator.feature;

import com.github.hetianyi.plugins.generator.common.Slot;
import com.github.hetianyi.plugins.generator.common.SlotType;
import com.github.hetianyi.plugins.generator.pojo.generator.ClassGenerator;
import com.github.hetianyi.plugins.generator.pojo.generator.feature.Feature;
import com.github.hetianyi.plugins.generator.pojo.generator.feature.SlotHelper;
import java.util.List;
import java.util.function.BiFunction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class CustomFeature
implements Feature {
    private static final Logger log = LoggerFactory.getLogger(CustomFeature.class);
    private SlotType type;
    private InsertLocation loc;
    private BiFunction<Slot, ClassGenerator, List<Slot>> slotFunction;

    public CustomFeature(SlotType type, InsertLocation loc, BiFunction<Slot, ClassGenerator, List<Slot>> slotFunction) {
        this.type = type;
        this.loc = loc;
        this.slotFunction = slotFunction;
    }

    @Override
    public void apply(ClassGenerator generator) {
        if (this.loc == InsertLocation.BEFORE) {
            SlotHelper.insertBefore(generator, this.type, this.slotFunction);
        } else {
            SlotHelper.insertAfter(generator, this.type, this.slotFunction);
        }
    }

    public static enum InsertLocation {
        BEFORE,
        AFTER;

    }
}

