/*
 * Decompiled with CFR 0.152.
 */
package com.github.hetianyi.plugins.generator.pojo.generator.feature.buildin;

import com.github.hetianyi.boot.ready.common.Const;
import com.github.hetianyi.boot.ready.common.util.StringUtil;
import com.github.hetianyi.plugins.generator.common.Slot;
import com.github.hetianyi.plugins.generator.common.SlotType;
import com.github.hetianyi.plugins.generator.pojo.generator.ClassGenerator;
import com.github.hetianyi.plugins.generator.pojo.generator.feature.Feature;
import com.github.hetianyi.plugins.generator.pojo.generator.feature.SlotHelper;
import com.github.hetianyi.plugins.generator.pojo.generator.slot.CodeSlot;
import com.github.hetianyi.plugins.generator.pojo.generator.slot.EmptyLineSlot;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImportFeature
implements Feature {
    private static final Logger log = LoggerFactory.getLogger(ImportFeature.class);

    @Override
    public void apply(ClassGenerator generator) {
        log.debug("\u5e94\u7528Feature -> ImportFeature");
        Set<String> imports = generator.getImports();
        List<Slot> javaImports = imports.stream().filter(v -> !StringUtil.isNullOrEmptyTrimed((String)v)).filter(v -> v.startsWith("java.")).sorted().map(v -> CodeSlot.of("import ", v, ";", "\n")).collect(Collectors.toList());
        log.debug("importSlotList=>{}", (Object)Const.GSON.toJson(javaImports));
        SlotHelper.insertBefore(generator, SlotType.IMPORT_START, javaImports.toArray(new Slot[0]));
        SlotHelper.insertBefore(generator, SlotType.IMPORT_START, EmptyLineSlot.instance);
        List<Slot> importSlotList = imports.stream().filter(v -> !StringUtil.isNullOrEmptyTrimed((String)v)).filter(v -> !v.startsWith("java.")).sorted().map(v -> CodeSlot.of("import ", v, ";", "\n")).collect(Collectors.toList());
        log.debug("importSlotList=>{}", (Object)Const.GSON.toJson(importSlotList));
        SlotHelper.insertAfter(generator, SlotType.IMPORT_START, importSlotList.toArray(new Slot[0]));
    }
}

