/*
 * Decompiled with CFR 0.152.
 */
package com.github.hetianyi.plugins.generator.pojo.generator.feature.buildin;

import com.github.hetianyi.plugins.generator.common.JavaTypeMapping;
import com.github.hetianyi.plugins.generator.common.SlotType;
import com.github.hetianyi.plugins.generator.common.util.GenerateUtil;
import com.github.hetianyi.plugins.generator.pojo.entity.TableColumn;
import com.github.hetianyi.plugins.generator.pojo.generator.ClassGenerator;
import com.github.hetianyi.plugins.generator.pojo.generator.feature.Feature;
import com.github.hetianyi.plugins.generator.pojo.generator.feature.SlotHelper;
import com.github.hetianyi.plugins.generator.pojo.generator.slot.CodeSlot;
import com.github.hetianyi.plugins.generator.pojo.generator.slot.EmptyLineSlot;
import com.github.hetianyi.plugins.generator.pojo.generator.slot.IndentSlot;
import java.util.LinkedList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GetterSetterFeature
implements Feature {
    private static final Logger log = LoggerFactory.getLogger(GetterSetterFeature.class);

    @Override
    public void apply(ClassGenerator generator) {
        log.debug("\u5e94\u7528Feature -> GetterSetterFeature");
        SlotHelper.insertBefore(generator, SlotType.ALL_FIELD_END, (s, g) -> {
            List<TableColumn> columns = g.getTabDef().getColumns();
            LinkedList<CodeSlot> slots = new LinkedList<CodeSlot>();
            for (TableColumn column : columns) {
                String fieldName = GenerateUtil.camel(column.getName(), false);
                String methodName = GenerateUtil.camel(column.getName(), true);
                String simpleClassName = generator.getTypeSimpleClassName(JavaTypeMapping.typeMappings.get(column.getType()));
                slots.add(CodeSlot.of("\n\n", IndentSlot.instance.getContent(), "public ", simpleClassName, " get", methodName, "() {\n", IndentSlot.instance.getDoubleContent(), "return this.", fieldName, ";\n", IndentSlot.instance.getContent(), "}"));
                slots.add(CodeSlot.of("\n\n", IndentSlot.instance.getContent(), "public void set", methodName, "(", simpleClassName, " ", fieldName, ") {\n", IndentSlot.instance.getDoubleContent(), "this.", fieldName, " = ", fieldName, ";\n", IndentSlot.instance.getContent(), "}"));
            }
            slots.add(EmptyLineSlot.getInstance());
            return slots;
        });
    }
}

