/*
 * Decompiled with CFR 0.152.
 */
package com.github.hetianyi.plugins.generator.template;

import cn.hutool.core.io.FileUtil;
import com.github.hetianyi.boot.ready.common.util.CollectionUtil;
import com.github.hetianyi.boot.ready.common.util.StringUtil;
import com.github.hetianyi.plugins.generator.common.BaseMojo;
import com.github.hetianyi.plugins.generator.common.ProfileProperties;
import com.github.hetianyi.plugins.generator.common.TemplateConfig;
import com.github.hetianyi.plugins.generator.common.TemplateType;
import com.github.hetianyi.plugins.generator.common.util.GenerateUtil;
import com.github.hetianyi.plugins.generator.common.util.InflectorUtil;
import com.github.hetianyi.plugins.generator.pojo.entity.TableColumn;
import com.github.hetianyi.plugins.generator.pojo.generator.ClassGenerator;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.StringJoiner;
import java.util.UUID;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Mojo(name="generate-template", defaultPhase=LifecyclePhase.COMPILE)
public class TemplateMojo
extends BaseMojo {
    private static final Logger log = LoggerFactory.getLogger(TemplateMojo.class);

    @Override
    protected void runProfile(ProfileProperties profile) throws Exception {
        super.runProfile(profile);
        log.info("\u8fd0\u884c\u63d2\u4ef6\uff1agenerate-template");
        if (CollectionUtil.isNullOrEmpty(profile.getTemplateDirs())) {
            this.getLog().info((CharSequence)("\u672a\u914d\u7f6etemplateDir, profile: " + profile.getName() + "\u5c06\u7ec8\u6b62\u6267\u884c"));
            return;
        }
        Map<String, ClassGenerator> map = GenerateUtil.resolveTables(profile);
        List<File> templateTypeFiles = this.detectTemplateFile(profile);
        for (Map.Entry<String, ClassGenerator> entry : map.entrySet()) {
            this.findReplaceCopy(templateTypeFiles, entry);
        }
    }

    private List<File> detectTemplateFile(ProfileProperties profile) {
        LinkedList<File> result = new LinkedList<File>();
        Set<String> templateDirs = profile.getTemplateDirs();
        templateDirs.stream().filter(v -> !StringUtil.isNullOrEmptyTrimed((String)v)).forEach(templateDir -> {
            Path templateRootPath = new File((String)templateDir).toPath();
            if (!Files.exists(templateRootPath, new LinkOption[0])) {
                throw new RuntimeException("\u6a21\u7248\u76ee\u5f55\u4e0d\u5b58\u5728: " + templateRootPath);
            }
            log.debug("\u904d\u5386\u76ee\u5f55\uff1a" + templateRootPath);
            try {
                Files.walk(templateRootPath, new FileVisitOption[0]).forEach(v -> {
                    File file = v.toFile();
                    if (!file.isDirectory()) {
                        String content = FileUtil.readUtf8String((File)file);
                        for (Map.Entry<TemplateType, String> entry : TemplateConfig.templateCommentMarker.entrySet()) {
                            if (!content.contains(entry.getValue())) continue;
                            result.add(file);
                            log.debug("\u6a21\u7248\u6587\u4ef6 -> " + v.toFile().getAbsolutePath());
                        }
                    }
                });
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        });
        return result;
    }

    private void findReplaceCopy(List<File> templateTypeFiles, Map.Entry<String, ClassGenerator> entry) {
        String pojoClassName = entry.getKey();
        log.info("\u521b\u5efa\u6a21\u7248\u590d\u5236: " + pojoClassName);
        ClassGenerator generator = entry.getValue();
        String lowerObjectName = generator.getLowerObjectName();
        String upperObjectName = generator.getUpperObjectName();
        String entityName = Optional.ofNullable(generator.getTabDef().getComment()).orElse("").replace("\r\n", "\n").replace("\n", " ").replace("\u8868", "");
        for (File e : templateTypeFiles) {
            File templateFileDir = e.getParentFile();
            String templateFileName = e.getName();
            String copyFileName = templateFileName.replace("Example", upperObjectName);
            String templateContent = FileUtil.readUtf8String((File)e);
            StringJoiner sJoiner = new StringJoiner("`, `");
            generator.getTabDef().getColumns().forEach(v -> sJoiner.add(v.getName()));
            TableColumn idColumn = generator.getTabDef().getColumns().stream().filter(v -> v.isId()).findFirst().orElse(null);
            String allFields = "`" + sJoiner + "`";
            templateContent = templateContent.replace("// #__Template__#\r\n", "").replace("// #__Template__#\n", "").replace("<!--#__Template__#-->\r\n", "").replace("<!--#__Template__#-->\n", "").replace("#__Template__#\r\n", "").replace("#__Template__#\n", "").replace("#__Template__#", "").replaceAll("/\\*\\s*#allFieldsStart#\\s*\\*/.*/\\*\\s*#allFieldsEnd#\\s*\\*/", allFields).replaceAll("/\\*\\s*#idFieldStart#\\s*\\*/.*/\\*\\s*#idFieldEnd#\\s*\\*/", null == idColumn ? "`id`" : "`" + idColumn.getName() + "`");
            String tempTabName = UUID.randomUUID().toString();
            templateContent = templateContent.replace("t_example", tempTabName).replace("examples", InflectorUtil.getInstance().pluralize(lowerObjectName)).replace("Examples", InflectorUtil.getInstance().pluralize(upperObjectName)).replace("Example", upperObjectName).replace("example", lowerObjectName).replace(tempTabName, generator.getTabDef().getName()).replace("\u793a\u4f8b", entityName);
            File targetFile = new File(templateFileDir, copyFileName);
            FileUtil.writeUtf8String((String)templateContent, (File)targetFile);
        }
    }
}

