/*
 * Decompiled with CFR 0.152.
 */
package com.github.fommil.jni;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.util.Arrays;
import java.util.HashSet;
import java.util.logging.Logger;

public final class JniLoader {
    private static final Logger log = Logger.getLogger(JniLoader.class.getName());
    private static final String JNI_EXTRACT_DIR_PROP = "com.github.fommil.jni.dir";
    private static final HashSet<String> loaded = new HashSet();

    public static synchronized void load(String ... paths) {
        if (paths == null || paths.length == 0) {
            throw new ExceptionInInitializerError("invalid parameters");
        }
        String[] stringArray = paths;
        int n = paths.length;
        int n2 = 0;
        while (n2 < n) {
            String path = stringArray[n2];
            String key = new File(path).getName();
            if (loaded.contains(key)) {
                return;
            }
            ++n2;
        }
        String[] javaLibPath = System.getProperty("java.library.path").split(File.pathSeparator);
        String[] stringArray2 = paths;
        int n3 = paths.length;
        n = 0;
        while (n < n3) {
            String path = stringArray2[n];
            String[] stringArray3 = javaLibPath;
            int n4 = javaLibPath.length;
            int n5 = 0;
            while (n5 < n4) {
                String libPath = stringArray3[n5];
                File file = new File(libPath, path).getAbsoluteFile();
                if (file.exists() && file.isFile() && JniLoader.liberalLoad(file, path)) {
                    return;
                }
                ++n5;
            }
            File extracted = JniLoader.extract(path);
            if (extracted != null && JniLoader.liberalLoad(extracted, path)) {
                return;
            }
            ++n;
        }
        throw new ExceptionInInitializerError("unable to load from " + Arrays.toString(paths));
    }

    private static boolean liberalLoad(File file, String name) {
        try {
            System.load(file.getAbsolutePath());
            log.info("Successfully loaded " + file);
            loaded.add(name);
            return true;
        }
        catch (UnsatisfiedLinkError e) {
            String tmpdir = System.getProperty("java.io.tmpdir");
            if (tmpdir != null && tmpdir.trim().length() > 2 && file.getAbsolutePath().startsWith(tmpdir)) {
                try {
                    file.delete();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return false;
        }
        catch (SecurityException e) {
            return false;
        }
        catch (Throwable e) {
            throw new ExceptionInInitializerError(e);
        }
    }

    private static File extract(String path) {
        URL url = JniLoader.class.getResource("/" + path);
        if (url == null) {
            return null;
        }
        InputStream in = JniLoader.class.getResourceAsStream("/" + path);
        AbstractInterruptibleChannel dest = null;
        try {
            File file = JniLoader.file(path);
            JniLoader.deleteOnExit(file);
            ReadableByteChannel src = Channels.newChannel(in);
            dest = new FileOutputStream(file).getChannel();
            ((FileChannel)dest).transferFrom(src, 0L, Long.MAX_VALUE);
            if (dest != null) {
                dest.close();
            }
            if (in != null) {
                in.close();
            }
            File file2 = file;
            return file2;
        }
        catch (Exception e) {
            if (e instanceof SecurityException || e instanceof IOException) {
                return null;
            }
            throw new ExceptionInInitializerError(e);
        }
        finally {
            try {
                if (dest != null) {
                    dest.close();
                }
                if (in != null) {
                    in.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    private static File file(String path) throws IOException {
        String name = new File(path).getName();
        String dir = System.getProperty(JNI_EXTRACT_DIR_PROP);
        if (dir == null) {
            return File.createTempFile("jniloader", name);
        }
        File file = new File(dir, name);
        if (file.exists() && !file.isFile()) {
            throw new IllegalArgumentException(String.valueOf(file.getAbsolutePath()) + " is not a file");
        }
        if (!file.exists()) {
            file.createNewFile();
        }
        return file;
    }

    private static void deleteOnExit(File file) {
        try {
            file.deleteOnExit();
        }
        catch (Exception e) {
            try {
                System.gc();
                Thread.yield();
                file.deleteOnExit();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private JniLoader() {
    }
}

