/*
 * Decompiled with CFR 0.152.
 */
package com.github.fommil.netlib;

import java.util.logging.Logger;
import org.netlib.util.doubleW;
import org.netlib.util.intW;

public abstract class LAPACK {
    private static final Logger log = Logger.getLogger(LAPACK.class.getName());
    private static final String FALLBACK = "com.github.fommil.netlib.F2jLAPACK";
    private static final String IMPLS = "com.github.fommil.netlib.NativeRefLAPACK,com.github.fommil.netlib.F2jLAPACK";
    private static final String PROPERTY_KEY = "com.github.fommil.netlib.LAPACK";
    private static final LAPACK INSTANCE;

    static {
        try {
            String[] classNames = System.getProperty(PROPERTY_KEY, IMPLS).split(",");
            LAPACK impl = null;
            String[] stringArray = classNames;
            int n = classNames.length;
            int n2 = 0;
            while (n2 < n) {
                String className = stringArray[n2];
                try {
                    impl = LAPACK.load(className);
                    break;
                }
                catch (Throwable e) {
                    if (classNames.length < 2) {
                        log.warning("Couldn't load implementation from: " + className);
                    }
                    ++n2;
                }
            }
            if (impl == null) {
                log.info("Using the fallback implementation instead");
                impl = LAPACK.load(FALLBACK);
            }
            INSTANCE = impl;
        }
        catch (Exception e) {
            throw new ExceptionInInitializerError(e);
        }
    }

    private static LAPACK load(String className) throws Exception {
        Class<?> klass = Class.forName(className);
        return (LAPACK)klass.newInstance();
    }

    public static LAPACK getInstance() {
        return INSTANCE;
    }

    public abstract void dgbcon(String var1, int var2, int var3, int var4, double[] var5, int var6, int[] var7, double var8, doubleW var10, double[] var11, int[] var12, intW var13);

    public abstract void dgbsv(int var1, int var2, int var3, int var4, double[] var5, int var6, int[] var7, double[] var8, int var9, intW var10);

    public abstract void dgbtrf(int var1, int var2, int var3, int var4, double[] var5, int var6, int[] var7, intW var8);

    public abstract void dgbtrs(String var1, int var2, int var3, int var4, int var5, double[] var6, int var7, int[] var8, double[] var9, int var10, intW var11);

    public abstract void dgecon(String var1, int var2, double[] var3, int var4, double var5, doubleW var7, double[] var8, int[] var9, intW var10);

    public abstract void dgeev(String var1, String var2, int var3, double[] var4, int var5, double[] var6, double[] var7, double[] var8, int var9, double[] var10, int var11, double[] var12, int var13, intW var14);

    public abstract void dgelqf(int var1, int var2, double[] var3, int var4, double[] var5, double[] var6, int var7, intW var8);

    public abstract void dgels(String var1, int var2, int var3, int var4, double[] var5, int var6, double[] var7, int var8, double[] var9, int var10, intW var11);

    public abstract void dgeqlf(int var1, int var2, double[] var3, int var4, double[] var5, double[] var6, int var7, intW var8);

    public abstract void dgeqp3(int var1, int var2, double[] var3, int var4, int[] var5, double[] var6, double[] var7, int var8, intW var9);

    public abstract void dgeqrf(int var1, int var2, double[] var3, int var4, double[] var5, double[] var6, int var7, intW var8);

    public abstract void dgerqf(int var1, int var2, double[] var3, int var4, double[] var5, double[] var6, int var7, intW var8);

    public abstract void dgesdd(String var1, int var2, int var3, double[] var4, int var5, double[] var6, double[] var7, int var8, double[] var9, int var10, double[] var11, int var12, int[] var13, intW var14);

    public abstract void dgesv(int var1, int var2, double[] var3, int var4, int[] var5, double[] var6, int var7, intW var8);

    public abstract void dgetrf(int var1, int var2, double[] var3, int var4, int[] var5, intW var6);

    public abstract void dgetrs(String var1, int var2, int var3, double[] var4, int var5, int[] var6, double[] var7, int var8, intW var9);

    public abstract void dgtsv(int var1, int var2, double[] var3, double[] var4, double[] var5, double[] var6, int var7, intW var8);

    public abstract void dlaswp(int var1, double[] var2, int var3, int var4, int var5, int[] var6, int var7);

    public abstract void dorglq(int var1, int var2, int var3, double[] var4, int var5, double[] var6, double[] var7, int var8, intW var9);

    public abstract void dorgql(int var1, int var2, int var3, double[] var4, int var5, double[] var6, double[] var7, int var8, intW var9);

    public abstract void dorgqr(int var1, int var2, int var3, double[] var4, int var5, double[] var6, double[] var7, int var8, intW var9);

    public abstract void dorgrq(int var1, int var2, int var3, double[] var4, int var5, double[] var6, double[] var7, int var8, intW var9);

    public abstract void dormrz(String var1, String var2, int var3, int var4, int var5, int var6, double[] var7, int var8, double[] var9, double[] var10, int var11, double[] var12, int var13, intW var14);

    public abstract void dpbcon(String var1, int var2, int var3, double[] var4, int var5, double var6, doubleW var8, double[] var9, int[] var10, intW var11);

    public abstract void dpbsv(String var1, int var2, int var3, int var4, double[] var5, int var6, double[] var7, int var8, intW var9);

    public abstract void dpbtrf(String var1, int var2, int var3, double[] var4, int var5, intW var6);

    public abstract void dpbtrs(String var1, int var2, int var3, int var4, double[] var5, int var6, double[] var7, int var8, intW var9);

    public abstract void dpocon(String var1, int var2, double[] var3, int var4, double var5, doubleW var7, double[] var8, int[] var9, intW var10);

    public abstract void dposv(String var1, int var2, int var3, double[] var4, int var5, double[] var6, int var7, intW var8);

    public abstract void dpotrf(String var1, int var2, double[] var3, int var4, intW var5);

    public abstract void dpotrs(String var1, int var2, int var3, double[] var4, int var5, double[] var6, int var7, intW var8);

    public abstract void dppcon(String var1, int var2, double[] var3, double var4, doubleW var6, double[] var7, int[] var8, intW var9);

    public abstract void dppsv(String var1, int var2, int var3, double[] var4, double[] var5, int var6, intW var7);

    public abstract void dpptrf(String var1, int var2, double[] var3, intW var4);

    public abstract void dpptrs(String var1, int var2, int var3, double[] var4, double[] var5, int var6, intW var7);

    public abstract void dptsv(int var1, int var2, double[] var3, double[] var4, double[] var5, int var6, intW var7);

    public abstract void dsbevd(String var1, String var2, int var3, int var4, double[] var5, int var6, double[] var7, double[] var8, int var9, double[] var10, int var11, int[] var12, int var13, intW var14);

    public abstract void dspevd(String var1, String var2, int var3, double[] var4, double[] var5, double[] var6, int var7, double[] var8, int var9, int[] var10, int var11, intW var12);

    public abstract void dspsv(String var1, int var2, int var3, double[] var4, int[] var5, double[] var6, int var7, intW var8);

    public abstract void dstevr(String var1, String var2, int var3, double[] var4, double[] var5, double var6, double var8, int var10, int var11, double var12, intW var14, double[] var15, double[] var16, int var17, int[] var18, double[] var19, int var20, int[] var21, int var22, intW var23);

    public abstract void dsyevr(String var1, String var2, String var3, int var4, double[] var5, int var6, double var7, double var9, int var11, int var12, double var13, intW var15, double[] var16, double[] var17, int var18, int[] var19, double[] var20, int var21, int[] var22, int var23, intW var24);

    public abstract void dsygvd(int var1, String var2, String var3, int var4, double[] var5, int var6, double[] var7, int var8, double[] var9, double[] var10, int var11, int[] var12, int var13, intW var14);

    public abstract void dsysv(String var1, int var2, int var3, double[] var4, int var5, int[] var6, double[] var7, int var8, double[] var9, int var10, intW var11);

    public abstract void dtbtrs(String var1, String var2, String var3, int var4, int var5, int var6, double[] var7, int var8, double[] var9, int var10, intW var11);

    public abstract void dtptrs(String var1, String var2, String var3, int var4, int var5, double[] var6, double[] var7, int var8, intW var9);

    public abstract void dtrtrs(String var1, String var2, String var3, int var4, int var5, double[] var6, int var7, double[] var8, int var9, intW var10);
}

