/*
 * Decompiled with CFR 0.152.
 */
package no.uib.cipr.matrix;

import no.uib.cipr.matrix.DenseMatrix;
import no.uib.cipr.matrix.JobEig;

abstract class SymmEVD {
    final int n;
    final double[] w;
    final DenseMatrix Z;
    final JobEig job;
    protected static final double SAFE_ABSTOL = Double.MIN_NORMAL;

    public SymmEVD(int n, boolean vectors) {
        this.n = n;
        this.w = new double[n];
        this.job = vectors ? JobEig.All : JobEig.Eigenvalues;
        this.Z = vectors ? new DenseMatrix(n, n) : null;
    }

    public SymmEVD(int n) {
        this(n, true);
    }

    public double[] getEigenvalues() {
        return this.w;
    }

    public DenseMatrix getEigenvectors() {
        return this.Z;
    }

    public boolean hasEigenvectors() {
        return this.Z != null;
    }
}

