/*
 * Decompiled with CFR 0.152.
 */
package no.uib.cipr.matrix.sparse;

import com.github.fommil.netlib.ARPACK;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Logger;
import no.uib.cipr.matrix.DenseVector;
import no.uib.cipr.matrix.DenseVectorSub;
import no.uib.cipr.matrix.Matrix;
import no.uib.cipr.matrix.MatrixEntry;
import org.netlib.util.doubleW;
import org.netlib.util.intW;

public class ArpackSym {
    private static final Logger log = Logger.getLogger(ArpackSym.class.getName());
    private final ARPACK arpack = ARPACK.getInstance();
    private static final double TOL = 1.0E-4;
    private static final boolean EXPENSIVE_CHECKS = true;
    private final Matrix matrix;

    public ArpackSym(Matrix matrix) {
        if (!matrix.isSquare()) {
            throw new IllegalArgumentException("matrix must be square");
        }
        for (MatrixEntry entry : matrix) {
            if (entry.get() == matrix.get(entry.column(), entry.row())) continue;
            throw new IllegalArgumentException("matrix must be symmetric");
        }
        this.matrix = matrix;
    }

    public Map<Double, DenseVectorSub> solve(int eigenvalues, Ritz ritz) {
        if (eigenvalues <= 0) {
            throw new IllegalArgumentException(String.valueOf(eigenvalues) + " <= 0");
        }
        if (eigenvalues >= this.matrix.numColumns()) {
            throw new IllegalArgumentException(String.valueOf(eigenvalues) + " >= " + this.matrix.numColumns());
        }
        int n = this.matrix.numRows();
        intW nev = new intW(eigenvalues);
        int ncv = Math.min(2 * eigenvalues, n);
        String bmat = "I";
        String which = ritz.name();
        doubleW tol = new doubleW(1.0E-4);
        intW info = new intW(0);
        int[] iparam = new int[11];
        iparam[0] = 1;
        iparam[2] = 300;
        iparam[6] = 1;
        intW ido = new intW(0);
        double[] resid = new double[n];
        double[] v = new double[n * ncv];
        double[] workd = new double[3 * n];
        double[] workl = new double[ncv * (ncv + 8)];
        int[] ipntr = new int[11];
        int i = 0;
        while (true) {
            ++i;
            this.arpack.dsaupd(ido, bmat, n, which, nev.val, tol, resid, ncv, v, n, iparam, ipntr, workd, workl, workl.length, info);
            if (ido.val == 99) break;
            if (ido.val != -1 && ido.val != 1) {
                throw new IllegalStateException("ido = " + ido.val);
            }
            this.av(workd, ipntr[0] - 1, ipntr[1] - 1);
        }
        log.fine(String.valueOf(i) + " iterations for " + n);
        if (info.val != 0) {
            throw new IllegalStateException("info = " + info.val);
        }
        double[] d = new double[nev.val];
        boolean[] select = new boolean[ncv];
        double[] z = Arrays.copyOfRange(v, 0, nev.val * n);
        this.arpack.dseupd(true, "A", select, d, z, n, 0.0, bmat, n, which, nev, 1.0E-4, resid, ncv, v, n, iparam, ipntr, workd, workl, workl.length, info);
        if (info.val != 0) {
            throw new IllegalStateException("info = " + info.val);
        }
        int computed = iparam[4];
        log.fine("computed " + computed + " eigenvalues");
        TreeMap<Double, DenseVectorSub> solution = new TreeMap<Double, DenseVectorSub>(new Comparator<Double>(){

            @Override
            public int compare(Double o1, Double o2) {
                return Double.compare(o2, o1);
            }
        });
        DenseVector eigenvectors = new DenseVector(z, false);
        i = 0;
        while (i < computed) {
            double eigenvalue = d[i];
            DenseVectorSub eigenvector = new DenseVectorSub(eigenvectors, i * n, n);
            solution.put(eigenvalue, eigenvector);
            ++i;
        }
        return solution;
    }

    private void av(double[] work, int input_offset, int output_offset) {
        DenseVector w = new DenseVector(work, false);
        DenseVectorSub x = new DenseVectorSub(w, input_offset, this.matrix.numColumns());
        DenseVectorSub y = new DenseVectorSub(w, output_offset, this.matrix.numColumns());
        this.matrix.mult(x, y);
    }

    public static enum Ritz {
        LA,
        SA,
        LM,
        SM,
        BE;

    }
}

