/*
 * Decompiled with CFR 0.152.
 */
package no.uib.cipr.matrix.sparse;

import java.util.Arrays;
import java.util.Iterator;
import no.uib.cipr.matrix.AbstractMatrix;
import no.uib.cipr.matrix.DenseVector;
import no.uib.cipr.matrix.Matrix;
import no.uib.cipr.matrix.MatrixEntry;
import no.uib.cipr.matrix.Vector;
import no.uib.cipr.matrix.VectorEntry;
import no.uib.cipr.matrix.sparse.SparseVector;
import no.uib.cipr.matrix.sparse.SuperIterator;

public class FlexCompColMatrix
extends AbstractMatrix {
    SparseVector[] colD;

    public FlexCompColMatrix(int numRows, int numColumns) {
        super(numRows, numColumns);
        this.colD = new SparseVector[numColumns];
        int i = 0;
        while (i < numColumns) {
            this.colD[i] = new SparseVector(numRows);
            ++i;
        }
    }

    public FlexCompColMatrix(Matrix A, boolean deep) {
        super(A);
        this.colD = new SparseVector[this.numColumns];
        if (deep) {
            int i = 0;
            while (i < this.numColumns) {
                this.colD[i] = new SparseVector(this.numRows);
                ++i;
            }
            this.set(A);
        } else {
            FlexCompColMatrix Ar = (FlexCompColMatrix)A;
            int i = 0;
            while (i < this.numColumns) {
                this.colD[i] = Ar.getColumn(i);
                ++i;
            }
        }
    }

    public FlexCompColMatrix(Matrix A) {
        this(A, true);
    }

    public SparseVector getColumn(int i) {
        return this.colD[i];
    }

    public void setColumn(int i, SparseVector x) {
        if (x.size() != this.numRows) {
            throw new IllegalArgumentException("New column must be of the same size as existing column");
        }
        this.colD[i] = x;
    }

    @Override
    public Vector multAdd(double alpha, Vector x, Vector y) {
        if (!(x instanceof DenseVector) || !(y instanceof DenseVector)) {
            return super.multAdd(alpha, x, y);
        }
        this.checkMultAdd(x, y);
        double[] xd = ((DenseVector)x).getData();
        double[] yd = ((DenseVector)y).getData();
        y.scale(1.0 / alpha);
        int i = 0;
        while (i < this.numColumns) {
            SparseVector v = this.colD[i];
            int[] index = v.getIndex();
            double[] data = v.getData();
            int length = v.getUsed();
            int j = 0;
            while (j < length) {
                int n = index[j];
                yd[n] = yd[n] + data[j] * xd[i];
                ++j;
            }
            ++i;
        }
        return y.scale(alpha);
    }

    @Override
    public Vector transMultAdd(double alpha, Vector x, Vector y) {
        this.checkTransMultAdd(x, y);
        int i = 0;
        while (i < this.numColumns) {
            y.add(i, alpha * this.colD[i].dot(x));
            ++i;
        }
        return y;
    }

    @Override
    public void add(int row, int column, double value) {
        this.colD[column].add(row, value);
    }

    @Override
    public void set(int row, int column, double value) {
        this.colD[column].set(row, value);
    }

    @Override
    public double get(int row, int column) {
        return this.colD[column].get(row);
    }

    @Override
    public Iterator<MatrixEntry> iterator() {
        return new ColMatrixIterator();
    }

    @Override
    public FlexCompColMatrix copy() {
        return new FlexCompColMatrix(this);
    }

    @Override
    public FlexCompColMatrix zero() {
        int i = 0;
        while (i < this.numColumns) {
            this.colD[i].zero();
            ++i;
        }
        return this;
    }

    public void compact() {
        SparseVector[] sparseVectorArray = this.colD;
        int n = this.colD.length;
        int n2 = 0;
        while (n2 < n) {
            SparseVector v = sparseVectorArray[n2];
            v.compact();
            ++n2;
        }
    }

    private static final class ColMatrixEntry
    implements MatrixEntry {
        private int column;
        private VectorEntry entry;

        private ColMatrixEntry() {
        }

        public void update(int column, VectorEntry entry) {
            this.column = column;
            this.entry = entry;
        }

        @Override
        public int row() {
            return this.entry.index();
        }

        @Override
        public int column() {
            return this.column;
        }

        @Override
        public double get() {
            return this.entry.get();
        }

        @Override
        public void set(double value) {
            this.entry.set(value);
        }
    }

    private final class ColMatrixIterator
    implements Iterator<MatrixEntry> {
        private SuperIterator<SparseVector, VectorEntry> iterator;
        private ColMatrixEntry entry;

        private ColMatrixIterator() {
            this.iterator = new SuperIterator(Arrays.asList(FlexCompColMatrix.this.colD));
            this.entry = new ColMatrixEntry();
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public MatrixEntry next() {
            Object se = this.iterator.next();
            this.entry.update(((SuperIterator.SuperIteratorEntry)se).index(), (VectorEntry)((SuperIterator.SuperIteratorEntry)se).get());
            return this.entry;
        }

        @Override
        public void remove() {
            this.iterator.remove();
        }
    }
}

