/*
 * Decompiled with CFR 0.152.
 */
package org.netlib.blas;

public final class Daxpy {
    public static void daxpy(int n, double da, double[] dx, int _dx_offset, int incx, double[] dy, int _dy_offset, int incy) {
        int mp1;
        if (n <= 0 || da == 0.0) {
            return;
        }
        int i = 0;
        if (incx != 1 || incy != 1) {
            int ix = 1;
            int iy = 1;
            if (incx < 0) {
                ix = (-n + 1) * incx + 1;
            }
            if (incy < 0) {
                iy = (-n + 1) * incy + 1;
            }
            i = 1;
            int k = n;
            while (k > 0) {
                dy[iy - 1 + _dy_offset] = dy[iy - 1 + _dy_offset] + da * dx[ix - 1 + _dx_offset];
                ix += incx;
                iy += incy;
                ++i;
                --k;
            }
            return;
        }
        int m = n % 4;
        if (m != 0) {
            i = 1;
            int k = m;
            while (k > 0) {
                dy[i - 1 + _dy_offset] = dy[i - 1 + _dy_offset] + da * dx[i - 1 + _dx_offset];
                ++i;
                --k;
            }
            if (n < 4) {
                return;
            }
        }
        i = mp1 = m + 1;
        int k = (n - mp1 + 4) / 4;
        while (k > 0) {
            dy[i - 1 + _dy_offset] = dy[i - 1 + _dy_offset] + da * dx[i - 1 + _dx_offset];
            dy[i + _dy_offset] = dy[i + _dy_offset] + da * dx[i + _dx_offset];
            dy[i + 1 + _dy_offset] = dy[i + 1 + _dy_offset] + da * dx[i + 1 + _dx_offset];
            dy[i + 2 + _dy_offset] = dy[i + 2 + _dy_offset] + da * dx[i + 2 + _dx_offset];
            i += 4;
            --k;
        }
    }
}

