/*
 * Decompiled with CFR 0.152.
 */
package org.netlib.blas;

import org.netlib.blas.DgemmLehn;
import org.netlib.blas.DgemmNetlib;
import org.netlib.blas.Lsame;
import org.netlib.err.Xerbla;

public final class Dgemm {
    public static void dgemm(String transa, String transb, int m, int n, int k, double alpha, double[] a, int _a_offset, int lda, double[] b, int _b_offset, int ldb, double beta, double[] c, int _c_offset, int ldc) {
        int info = 0;
        int nRowA = 0;
        int nRowB = 0;
        boolean notA = Lsame.lsame(transa, "N");
        boolean notB = Lsame.lsame(transb, "N");
        nRowA = notA ? m : k;
        nRowB = notB ? k : n;
        info = 0;
        if (!(notA || Lsame.lsame(transa, "C") || Lsame.lsame(transa, "T"))) {
            info = 1;
        } else if (!(notB || Lsame.lsame(transb, "C") || Lsame.lsame(transb, "T"))) {
            info = 2;
        } else if (m < 0) {
            info = 3;
        } else if (n < 0) {
            info = 4;
        } else if (k < 0) {
            info = 5;
        } else if (lda < Math.max(1, nRowA)) {
            info = 8;
        } else if (ldb < Math.max(1, nRowB)) {
            info = 10;
        } else if (ldc < Math.max(1, m)) {
            info = 13;
        }
        if (info != 0) {
            Xerbla.xerbla("DGEMM ", info);
            return;
        }
        if (m == 0 || n == 0 || (alpha == 0.0 || k == 0) && beta == 1.0) {
            return;
        }
        if (Math.round(Math.sqrt(m * n)) <= 220L) {
            DgemmNetlib.dgemm(notA, notB, m, n, k, alpha, a, _a_offset, lda, b, _b_offset, ldb, beta, c, _c_offset, ldc);
        } else {
            DgemmLehn.dgemm(notA, notB, m, n, k, alpha, a, _a_offset, lda, b, _b_offset, ldb, beta, c, _c_offset, ldc);
        }
    }
}

