/*
 * Decompiled with CFR 0.152.
 */
package org.netlib.blas;

final class DgemmNetlib {
    DgemmNetlib() {
    }

    static void dgemm(boolean notA, boolean notB, int m, int n, int k, double alpha, double[] a, int _a_offset, int lda, double[] b, int _b_offset, int ldb, double beta, double[] c, int _c_offset, int ldc) {
        if (alpha == 0.0) {
            if (beta == 0.0) {
                int v = 1;
                int o = n;
                while (o > 0) {
                    int i = 1;
                    int p = m;
                    while (p > 0) {
                        c[i - 1 + (v - 1) * ldc + _c_offset] = 0.0;
                        ++i;
                        --p;
                    }
                    ++v;
                    --o;
                }
            } else {
                int v = 1;
                int o = n;
                while (o > 0) {
                    int i = 1;
                    int p = m;
                    while (p > 0) {
                        c[i - 1 + (v - 1) * ldc + _c_offset] = beta * c[i - 1 + (v - 1) * ldc + _c_offset];
                        ++i;
                        --p;
                    }
                    ++v;
                    --o;
                }
            }
            return;
        }
        if (notB) {
            if (notA) {
                int u = 1;
                int o = n;
                while (o > 0) {
                    int p;
                    int i;
                    if (beta == 0.0) {
                        i = 1;
                        p = m;
                        while (p > 0) {
                            c[i - 1 + (u - 1) * ldc + _c_offset] = 0.0;
                            ++i;
                            --p;
                        }
                    } else if (beta != 1.0) {
                        i = 1;
                        p = m;
                        while (p > 0) {
                            c[i - 1 + (u - 1) * ldc + _c_offset] = beta * c[i - 1 + (u - 1) * ldc + _c_offset];
                            ++i;
                            --p;
                        }
                    }
                    int w = 1;
                    p = k;
                    while (p > 0) {
                        if (b[w - 1 + (u - 1) * ldb + _b_offset] != 0.0) {
                            double tmp = alpha * b[w - 1 + (u - 1) * ldb + _b_offset];
                            int i2 = 1;
                            int q = m;
                            while (q > 0) {
                                c[i2 - 1 + (u - 1) * ldc + _c_offset] = c[i2 - 1 + (u - 1) * ldc + _c_offset] + tmp * a[i2 - 1 + (w - 1) * lda + _a_offset];
                                ++i2;
                                --q;
                            }
                        }
                        ++w;
                        --p;
                    }
                    ++u;
                    --o;
                }
            } else {
                int u = 1;
                int o = n;
                while (o > 0) {
                    int w = 1;
                    int p = m;
                    while (p > 0) {
                        double tmp = 0.0;
                        int i = 1;
                        int q = k;
                        while (q > 0) {
                            tmp += a[i - 1 + (w - 1) * lda + _a_offset] * b[i - 1 + (u - 1) * ldb + _b_offset];
                            ++i;
                            --q;
                        }
                        c[w - 1 + (u - 1) * ldc + _c_offset] = beta == 0.0 ? alpha * tmp : alpha * tmp + beta * c[w - 1 + (u - 1) * ldc + _c_offset];
                        ++w;
                        --p;
                    }
                    ++u;
                    --o;
                }
            }
        } else if (notA) {
            int u = 1;
            int o = n;
            while (o > 0) {
                int p;
                int i;
                if (beta == 0.0) {
                    i = 1;
                    p = m;
                    while (p > 0) {
                        c[i - 1 + (u - 1) * ldc + _c_offset] = 0.0;
                        ++i;
                        --p;
                    }
                } else if (beta != 1.0) {
                    i = 1;
                    p = m;
                    while (p > 0) {
                        c[i - 1 + (u - 1) * ldc + _c_offset] = beta * c[i - 1 + (u - 1) * ldc + _c_offset];
                        ++i;
                        --p;
                    }
                }
                int w = 1;
                p = k;
                while (p > 0) {
                    if (b[u - 1 + (w - 1) * ldb + _b_offset] != 0.0) {
                        double tmp = alpha * b[u - 1 + (w - 1) * ldb + _b_offset];
                        int i3 = 1;
                        int q = m;
                        while (q > 0) {
                            c[i3 - 1 + (u - 1) * ldc + _c_offset] = c[i3 - 1 + (u - 1) * ldc + _c_offset] + tmp * a[i3 - 1 + (w - 1) * lda + _a_offset];
                            ++i3;
                            --q;
                        }
                    }
                    ++w;
                    --p;
                }
                ++u;
                --o;
            }
        } else {
            int u = 1;
            int o = n;
            while (o > 0) {
                int w = 1;
                int p = m;
                while (p > 0) {
                    double tmp = 0.0;
                    int i = 1;
                    int q = k;
                    while (q > 0) {
                        tmp += a[i - 1 + (w - 1) * lda + _a_offset] * b[u - 1 + (i - 1) * ldb + _b_offset];
                        ++i;
                        --q;
                    }
                    c[w - 1 + (u - 1) * ldc + _c_offset] = beta == 0.0 ? alpha * tmp : alpha * tmp + beta * c[w - 1 + (u - 1) * ldc + _c_offset];
                    ++w;
                    --p;
                }
                ++u;
                --o;
            }
        }
    }
}

