/*
 * Decompiled with CFR 0.152.
 */
package com.github.fommil.netlib;

import java.util.logging.Logger;

public abstract class BLAS {
    private static final Logger log = Logger.getLogger(BLAS.class.getName());
    private static final String FALLBACK = "com.github.fommil.netlib.F2jBLAS";
    private static final String IMPLS = "com.github.fommil.netlib.NativeRefBLAS,com.github.fommil.netlib.F2jBLAS";
    private static final String PROPERTY_KEY = "com.github.fommil.netlib.BLAS";
    private static final BLAS INSTANCE;

    static {
        try {
            String[] classNames = System.getProperty(PROPERTY_KEY, IMPLS).split(",");
            BLAS impl = null;
            String[] stringArray = classNames;
            int n = classNames.length;
            int n2 = 0;
            while (n2 < n) {
                String className = stringArray[n2];
                try {
                    impl = BLAS.load(className);
                    break;
                }
                catch (Throwable e) {
                    if (classNames.length < 2) {
                        log.warning("Couldn't load implementation from: " + className);
                    }
                    ++n2;
                }
            }
            if (impl == null) {
                log.info("Using the fallback implementation instead");
                impl = BLAS.load(FALLBACK);
            }
            INSTANCE = impl;
        }
        catch (Exception e) {
            throw new ExceptionInInitializerError(e);
        }
    }

    private static BLAS load(String className) throws Exception {
        Class<?> klass = Class.forName(className);
        return (BLAS)klass.newInstance();
    }

    public static BLAS getInstance() {
        return INSTANCE;
    }

    public abstract void dgbmv(String var1, int var2, int var3, int var4, int var5, double var6, double[] var8, int var9, double[] var10, int var11, double var12, double[] var14, int var15);

    public abstract void dgemm(String var1, String var2, int var3, int var4, int var5, double var6, double[] var8, int var9, double[] var10, int var11, double var12, double[] var14, int var15);

    public abstract void dgemv(String var1, int var2, int var3, double var4, double[] var6, int var7, double[] var8, int var9, double var10, double[] var12, int var13);

    public abstract void dger(int var1, int var2, double var3, double[] var5, int var6, double[] var7, int var8, double[] var9, int var10);

    public abstract void dsbmv(String var1, int var2, int var3, double var4, double[] var6, int var7, double[] var8, int var9, double var10, double[] var12, int var13);

    public abstract void dspmv(String var1, int var2, double var3, double[] var5, double[] var6, int var7, double var8, double[] var10, int var11);

    public abstract void dspr(String var1, int var2, double var3, double[] var5, int var6, double[] var7);

    public abstract void dspr2(String var1, int var2, double var3, double[] var5, int var6, double[] var7, int var8, double[] var9);

    public abstract void dsymm(String var1, String var2, int var3, int var4, double var5, double[] var7, int var8, double[] var9, int var10, double var11, double[] var13, int var14);

    public abstract void dsymv(String var1, int var2, double var3, double[] var5, int var6, double[] var7, int var8, double var9, double[] var11, int var12);

    public abstract void dsyr(String var1, int var2, double var3, double[] var5, int var6, double[] var7, int var8);

    public abstract void dsyr2(String var1, int var2, double var3, double[] var5, int var6, double[] var7, int var8, double[] var9, int var10);

    public abstract void dsyr2k(String var1, String var2, int var3, int var4, double var5, double[] var7, int var8, double[] var9, int var10, double var11, double[] var13, int var14);

    public abstract void dsyrk(String var1, String var2, int var3, int var4, double var5, double[] var7, int var8, double var9, double[] var11, int var12);

    public abstract void dtbmv(String var1, String var2, String var3, int var4, int var5, double[] var6, int var7, double[] var8, int var9);

    public abstract void dtpmv(String var1, String var2, String var3, int var4, double[] var5, double[] var6, int var7);

    public abstract void dtrmm(String var1, String var2, String var3, String var4, int var5, int var6, double var7, double[] var9, int var10, double[] var11, int var12);

    public abstract void dtrmv(String var1, String var2, String var3, int var4, double[] var5, int var6, double[] var7, int var8);
}

