/*
 * Decompiled with CFR 0.152.
 */
package no.uib.cipr.matrix;

import java.util.Arrays;
import no.uib.cipr.matrix.AbstractMatrix;
import no.uib.cipr.matrix.AbstractVector;
import no.uib.cipr.matrix.DenseMatrix;
import no.uib.cipr.matrix.DenseVector;
import no.uib.cipr.matrix.Matrix;
import no.uib.cipr.matrix.MatrixEntry;
import no.uib.cipr.matrix.Vector;
import no.uib.cipr.matrix.VectorEntry;

public final class Matrices {
    private Matrices() {
    }

    static int ld(int n) {
        return Math.max(1, n);
    }

    static int ld(int m, int n) {
        return Math.max(1, Math.max(m, n));
    }

    public static int cardinality(Vector x) {
        int nz = 0;
        for (VectorEntry e : x) {
            if (e.get() == 0.0) continue;
            ++nz;
        }
        return nz;
    }

    public static int cardinality(Matrix A) {
        int nz = 0;
        for (MatrixEntry e : A) {
            if (e.get() == 0.0) continue;
            ++nz;
        }
        return nz;
    }

    public static double[][] getArray(Matrix A) {
        double[][] Ad = new double[A.numRows()][A.numColumns()];
        for (MatrixEntry e : A) {
            Ad[e.row()][e.column()] = e.get();
        }
        return Ad;
    }

    public static double[] getArray(Vector x) {
        double[] xd = new double[x.size()];
        for (VectorEntry e : x) {
            xd[e.index()] = e.get();
        }
        return xd;
    }

    public static DenseMatrix identity(int size) {
        DenseMatrix A = new DenseMatrix(size, size);
        int i = 0;
        while (i < size) {
            A.set(i, i, 1.0);
            ++i;
        }
        return A;
    }

    public static Vector random(int size) {
        return Matrices.random(new DenseVector(size));
    }

    public static Vector random(Vector x) {
        int i = 0;
        while (i < x.size()) {
            x.set(i, Math.random());
            ++i;
        }
        return x;
    }

    public static Matrix random(int numRows, int numColumns) {
        return Matrices.random(new DenseMatrix(numRows, numColumns));
    }

    public static Matrix random(Matrix A) {
        int j = 0;
        while (j < A.numColumns()) {
            int i = 0;
            while (i < A.numRows()) {
                A.set(i, j, Math.random());
                ++i;
            }
            ++j;
        }
        return A;
    }

    public static Vector synchronizedVector(Vector x) {
        return new SynchronizedVector(x);
    }

    public static Matrix synchronizedMatrix(Matrix A) {
        return new SynchronizedMatrix(A);
    }

    public static Matrix synchronizedMatrixByRows(Matrix A) {
        return new SynchronizedRowMatrix(A);
    }

    public static Matrix synchronizedMatrixByColumns(Matrix A) {
        return new SynchronizedColumnMatrix(A);
    }

    public static Matrix getSubMatrix(Matrix A, int[] row, int[] column) {
        return new RefMatrix(A, row, column);
    }

    public static Vector getSubVector(Vector x, int[] index) {
        return new RefVector(x, index);
    }

    public static int[] index(int from, int to) {
        int length = to - from;
        if (length < 0) {
            length = 0;
        }
        int[] index = new int[length];
        int i = from;
        int j = 0;
        while (j < length) {
            index[j] = i++;
            ++j;
        }
        return index;
    }

    public static int[] index(int from, int stride, int to) {
        if (stride == 1) {
            return Matrices.index(from, to);
        }
        if (stride == 0) {
            return new int[0];
        }
        if (to <= from && stride > 0) {
            return new int[0];
        }
        if (from <= to && stride < 0) {
            return new int[0];
        }
        int length = Math.abs((to - from) / stride);
        if (Math.abs((to - from) % stride) > 0) {
            ++length;
        }
        if (length < 0) {
            length = 0;
        }
        int[] index = new int[length];
        int i = from;
        int j = 0;
        while (j < length) {
            index[j] = i;
            i += stride;
            ++j;
        }
        return index;
    }

    public static int[] rowBandwidth(Matrix A) {
        int[] nz = new int[A.numRows()];
        for (MatrixEntry e : A) {
            int n = e.row();
            nz[n] = nz[n] + 1;
        }
        return nz;
    }

    public static int[] columnBandwidth(Matrix A) {
        int[] nz = new int[A.numColumns()];
        for (MatrixEntry e : A) {
            int n = e.column();
            nz[n] = nz[n] + 1;
        }
        return nz;
    }

    public static int getNumSubDiagonals(Matrix A) {
        int kl = 0;
        for (MatrixEntry e : A) {
            kl = Math.max(kl, e.row() - e.column());
        }
        return kl;
    }

    public static int getNumSuperDiagonals(Matrix A) {
        int ku = 0;
        for (MatrixEntry e : A) {
            ku = Math.max(ku, e.column() - e.row());
        }
        return ku;
    }

    public static void zeroRows(Matrix A, double diagonal, int ... row) {
        int[] rowS = (int[])row.clone();
        Arrays.sort(rowS);
        for (MatrixEntry e : A) {
            int j = Arrays.binarySearch(rowS, e.row());
            if (j < 0) continue;
            if (e.row() == e.column()) {
                e.set(diagonal);
                continue;
            }
            e.set(0.0);
        }
        if (diagonal != 0.0) {
            int[] nArray = row;
            int n = row.length;
            int n2 = 0;
            while (n2 < n) {
                int rowI = nArray[n2];
                A.set(rowI, rowI, diagonal);
                ++n2;
            }
        }
    }

    public static void zeroColumns(Matrix A, double diagonal, int ... column) {
        int[] columnS = (int[])column.clone();
        Arrays.sort(columnS);
        for (MatrixEntry e : A) {
            int j = Arrays.binarySearch(columnS, e.column());
            if (j < 0) continue;
            if (e.row() == e.column()) {
                e.set(diagonal);
                continue;
            }
            e.set(0.0);
        }
        if (diagonal != 0.0) {
            int[] nArray = column;
            int n = column.length;
            int n2 = 0;
            while (n2 < n) {
                int columnI = nArray[n2];
                A.set(columnI, columnI, diagonal);
                ++n2;
            }
        }
    }

    public static DenseVector getColumn(Matrix m, int j) {
        DenseVector v = new DenseVector(m.numRows());
        int i = 0;
        while (i < v.size()) {
            v.set(i, m.get(i, j));
            ++i;
        }
        return v;
    }

    private static final class RefMatrix
    extends AbstractMatrix {
        private Matrix A;
        private int[] row;
        private int[] column;

        public RefMatrix(Matrix A, int[] row, int[] column) {
            super(row.length, column.length);
            this.A = A;
            this.row = row;
            this.column = column;
        }

        @Override
        public void add(int row, int column, double value) {
            this.A.add(this.row[row], this.column[column], value);
        }

        @Override
        public DenseMatrix copy() {
            return new DenseMatrix(this);
        }

        @Override
        public double get(int row, int column) {
            return this.A.get(this.row[row], this.column[column]);
        }

        @Override
        public void set(int row, int column, double value) {
            this.A.set(this.row[row], this.column[column], value);
        }
    }

    private static final class RefVector
    extends AbstractVector {
        private Vector x;
        private int[] index;

        public RefVector(Vector x, int[] index) {
            super(index.length);
            this.x = x;
            this.index = index;
        }

        @Override
        public void add(int index, double value) {
            this.x.add(this.index[index], value);
        }

        @Override
        public DenseVector copy() {
            return new DenseVector(this);
        }

        @Override
        public double get(int index) {
            return this.x.get(this.index[index]);
        }

        @Override
        public void set(int index, double value) {
            this.x.set(this.index[index], value);
        }
    }

    private static final class SynchronizedColumnMatrix
    extends AbstractMatrix {
        private Matrix A;
        private Object[] lock;

        public SynchronizedColumnMatrix(Matrix A) {
            super(A);
            this.A = A;
            this.lock = new Object[A.numColumns()];
            int i = 0;
            while (i < this.lock.length) {
                this.lock[i] = new Object();
                ++i;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void add(int row, int column, double value) {
            Object object = this.lock[column];
            synchronized (object) {
                this.A.add(row, column, value);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void set(int row, int column, double value) {
            Object object = this.lock[column];
            synchronized (object) {
                this.A.set(row, column, value);
            }
        }

        @Override
        public double get(int row, int column) {
            return this.A.get(row, column);
        }

        @Override
        public Matrix copy() {
            return Matrices.synchronizedMatrixByColumns(this.A.copy());
        }
    }

    private static final class SynchronizedMatrix
    extends AbstractMatrix {
        private Matrix A;

        public SynchronizedMatrix(Matrix A) {
            super(A);
            this.A = A;
        }

        @Override
        public synchronized void add(int row, int column, double value) {
            this.A.add(row, column, value);
        }

        @Override
        public synchronized void set(int row, int column, double value) {
            this.A.set(row, column, value);
        }

        @Override
        public synchronized double get(int row, int column) {
            return this.A.get(row, column);
        }

        @Override
        public Matrix copy() {
            return Matrices.synchronizedMatrix(this.A.copy());
        }
    }

    private static final class SynchronizedRowMatrix
    extends AbstractMatrix {
        private Matrix A;
        private Object[] lock;

        public SynchronizedRowMatrix(Matrix A) {
            super(A);
            this.A = A;
            this.lock = new Object[A.numRows()];
            int i = 0;
            while (i < this.lock.length) {
                this.lock[i] = new Object();
                ++i;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void add(int row, int column, double value) {
            Object object = this.lock[row];
            synchronized (object) {
                this.A.add(row, column, value);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void set(int row, int column, double value) {
            Object object = this.lock[row];
            synchronized (object) {
                this.A.set(row, column, value);
            }
        }

        @Override
        public double get(int row, int column) {
            return this.A.get(row, column);
        }

        @Override
        public Matrix copy() {
            return Matrices.synchronizedMatrixByRows(this.A.copy());
        }
    }

    private static final class SynchronizedVector
    extends AbstractVector {
        private Vector x;

        public SynchronizedVector(Vector x) {
            super(x);
            this.x = x;
        }

        @Override
        public synchronized void add(int index, double value) {
            this.x.add(index, value);
        }

        @Override
        public synchronized void set(int index, double value) {
            this.x.set(index, value);
        }

        @Override
        public synchronized double get(int index) {
            return this.x.get(index);
        }

        @Override
        public Vector copy() {
            return Matrices.synchronizedVector(this.x.copy());
        }
    }
}

