/*
 * Decompiled with CFR 0.152.
 */
package org.netlib.blas;

final class Axpy {
    static void axpy(int n, double alpha, double[] x, int xOff, int incX, double[] y, int yOff, int incY) {
        if (n <= 0 || alpha == 0.0) {
            return;
        }
        if (incX == 1 && incY == 1) {
            int i = 0;
            while (i < n) {
                int n2 = i + yOff;
                y[n2] = y[n2] + alpha * x[i + xOff];
                ++i;
            }
        } else {
            if (incX <= 0 || incY <= 0) {
                throw new IllegalArgumentException("illegal non-positive incrememts: incX=" + incX + ", incY=" + incY);
            }
            int i = 0;
            while (i < n) {
                int n3 = i * incY + yOff;
                y[n3] = y[n3] + alpha * x[i * incX + xOff];
                ++i;
            }
        }
    }

    private Axpy() {
        throw new AssertionError();
    }
}

