/*
 * Decompiled with CFR 0.152.
 */
package org.netlib.blas;

import java.util.ArrayList;
import java.util.concurrent.Future;
import org.netlib.blas.Dgemm4x4Worker;
import org.netlib.blas.DgemmTasks;
import org.netlib.blas.ThreadPool;

final class Dgemm4x4Parallel {
    Dgemm4x4Parallel() {
    }

    /*
     * WARNING - void declaration
     */
    static int dgemm(int nb, int kb, int mb, int _nc, int _kc, int _mc, double alpha, int offA, double[] A, int incRowA, int incColA, int offB, double[] B, int incRowB, int incColB, double beta, int offC, double[] C, int incRowC, int incColC) {
        void var25_27;
        if (nb <= 1 && kb <= 1 && mb <= 1) {
            throw new AssertionError((Object)("nb=" + nb + ", kb=" + kb + ", mb=" + mb));
        }
        if (DgemmTasks.availableCores() < 2) {
            throw new AssertionError((Object)("can't parallelize: cores = " + DgemmTasks.availableCores()));
        }
        DgemmTasks.TaskConfig[] cfgs = DgemmTasks.split(nb, kb, mb);
        ArrayList<Future<Integer>> results = new ArrayList<Future<Integer>>(cfgs.length);
        DgemmTasks.TaskConfig[] taskConfigArray = cfgs;
        int n = cfgs.length;
        boolean n2 = false;
        while (var25_27 < n) {
            DgemmTasks.TaskConfig cfg = taskConfigArray[var25_27];
            Dgemm4x4Worker task = new Dgemm4x4Worker(cfg, _nc, _kc, _mc, alpha, offA, A, incRowA, incColA, offB, B, incRowB, incColB, beta, offC, C, incRowC, incColC);
            Future<Integer> calls = ThreadPool.submit(task);
            results.add(calls);
            ++var25_27;
        }
        int micro_kernel_calls = 0;
        for (Future future : results) {
            try {
                micro_kernel_calls += ((Integer)future.get()).intValue();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return micro_kernel_calls;
    }
}

