/*
 * Decompiled with CFR 0.152.
 */
package org.netlib.blas;

import java.util.concurrent.Callable;
import org.netlib.blas.Dgemm4x4;
import org.netlib.blas.DgemmTasks;

final class Dgemm4x4Worker
implements Callable<Integer> {
    private final int m_nblo;
    private final int m_nbhi;
    private final int m_kbhi;
    private final int m_mblo;
    private final int m_mbhi;
    private final boolean m_nbfull;
    private final boolean m_mbfull;
    private final String m_loop;
    private final int m_tasks;
    private final int m_nc;
    private final int m_kc;
    private final int m_mc;
    private final double m_alpha;
    private final int m_offA;
    private final double[] m_A;
    private final int m_incRowA;
    private final int m_incColA;
    private final int m_offB;
    private final double[] m_B;
    private final int m_incRowB;
    private final int m_incColB;
    private final double m_beta;
    private final int m_offC;
    private final double[] m_C;
    private final int m_incRowC;
    private final int m_incColC;

    Dgemm4x4Worker(DgemmTasks.TaskConfig cfg, int _nc, int _kc, int _mc, double alpha, int offA, double[] A, int incRowA, int incColA, int offB, double[] B, int incRowB, int incColB, double beta, int offC, double[] C, int incRowC, int incColC) {
        this.m_nblo = cfg.nb_lo;
        this.m_nbhi = cfg.nb_hi;
        this.m_nbfull = !cfg.nb_hi_is_last;
        this.m_kbhi = cfg.kb_hi;
        this.m_mblo = cfg.mb_lo;
        this.m_mbhi = cfg.mb_hi;
        this.m_mbfull = !cfg.mb_hi_is_last;
        this.m_loop = cfg.loop;
        this.m_tasks = cfg.tasks;
        this.m_nc = _nc;
        this.m_kc = _kc;
        this.m_mc = _mc;
        this.m_alpha = alpha;
        this.m_offA = offA;
        this.m_A = A;
        this.m_incRowA = incRowA;
        this.m_incColA = incColA;
        this.m_offB = offB;
        this.m_B = B;
        this.m_incRowB = incRowB;
        this.m_incColB = incColB;
        this.m_beta = beta;
        this.m_offC = offC;
        this.m_C = C;
        this.m_incRowC = incRowC;
        this.m_incColC = incColC;
    }

    @Override
    public Integer call() throws Exception {
        int _nc = this.m_nc;
        int _kc = this.m_kc;
        int _mc = this.m_mc;
        double alpha = this.m_alpha;
        int offA = this.m_offA;
        double[] A = this.m_A;
        int incRowA = this.m_incRowA;
        int incColA = this.m_incColA;
        int offB = this.m_offB;
        double[] B = this.m_B;
        int incRowB = this.m_incRowB;
        int incColB = this.m_incColB;
        double beta = this.m_beta;
        int offC = this.m_offC;
        double[] C = this.m_C;
        int incRowC = this.m_incRowC;
        int incColC = this.m_incColC;
        double[] _A = new double[147456];
        double[] _B = new double[0x180000];
        double[] _C = new double[16];
        double[] AB = new double[16];
        int micro_kernel_calls = 0;
        int nblo = this.m_nblo;
        int nbhi = this.m_nbhi;
        boolean nbfull = this.m_nbfull;
        int kbhi = this.m_kbhi;
        int mblo = this.m_mblo;
        int mbhi = this.m_mbhi;
        boolean mbfull = this.m_mbfull;
        int j = nblo;
        while (j < nbhi) {
            int nc = _nc == 0 || nbfull || !nbfull && j != nbhi - 1 ? 4096 : _nc;
            int l = 0;
            while (l < kbhi) {
                int kc = l != kbhi - 1 || _kc == 0 ? 384 : _kc;
                double _beta = l == 0 ? beta : 1.0;
                Dgemm4x4.pack_B(kc, nc, offB + l * 384 * incRowB + j * 4096 * incColB, B, incRowB, incColB, _B);
                int i = mblo;
                while (i < mbhi) {
                    int mc = _mc == 0 || mbfull || !mbfull && i != mbhi - 1 ? 384 : _mc;
                    Dgemm4x4.pack_A(mc, kc, offA + i * 384 * incRowA + l * 384 * incColA, A, incRowA, incColA, _A);
                    micro_kernel_calls += Dgemm4x4.dgemm_macro_kernel(mc, nc, kc, alpha, _beta, offC + i * 384 * incRowC + j * 4096 * incColC, C, incRowC, incColC, _A, _B, AB, _C);
                    ++i;
                }
                ++l;
            }
            ++j;
        }
        return micro_kernel_calls;
    }
}

