/*
 * Decompiled with CFR 0.152.
 */
package org.netlib.blas;

import java.util.Arrays;

final class DgemmTasks {
    DgemmTasks() {
    }

    static TaskConfig[] split(int nb, int kb, int mb) {
        TaskConfig cfg;
        int cores = DgemmTasks.availableCores();
        if (cores <= 1) {
            throw new AssertionError((Object)("#cores : " + cores));
        }
        Object[] loopsMb = DgemmTasks.divideLoopBounds(mb, cores);
        Object[] loopsNb = null;
        int threads = loopsMb.length;
        if (loopsMb.length <= 1) {
            loopsNb = DgemmTasks.divideLoopBounds(nb, cores);
            threads = loopsNb.length;
            if (loopsNb.length <= 1) {
                throw new AssertionError((Object)"At least one loop must be divisible!");
            }
        }
        TaskConfig[] threadCfgs = new TaskConfig[threads];
        int i = 0;
        while (i < threadCfgs.length) {
            cfg = new TaskConfig();
            cfg.nb_hi = nb;
            cfg.kb_hi = kb;
            cfg.mb_hi = mb;
            threadCfgs[i] = cfg;
            ++i;
        }
        if (loopsMb != null && loopsMb.length > 1 && loopsMb.length == threadCfgs.length) {
            i = 0;
            while (i < threadCfgs.length) {
                cfg = threadCfgs[i];
                cfg.mb_lo = ((LoopBounds)loopsMb[i]).lo;
                cfg.mb_hi = ((LoopBounds)loopsMb[i]).hi;
                cfg.mb_hi_is_last = ((LoopBounds)loopsMb[i]).hi_is_last;
                cfg.loop = "mb";
                cfg.tasks = loopsMb.length;
                ++i;
            }
        } else if (loopsNb.length > 1 && loopsNb.length == threadCfgs.length) {
            i = 0;
            while (i < threadCfgs.length) {
                cfg = threadCfgs[i];
                cfg.nb_lo = ((LoopBounds)loopsNb[i]).lo;
                cfg.nb_hi = ((LoopBounds)loopsNb[i]).hi;
                cfg.nb_hi_is_last = ((LoopBounds)loopsNb[i]).hi_is_last;
                cfg.loop = "nb";
                cfg.tasks = loopsNb.length;
                ++i;
            }
        } else {
            throw new IllegalStateException("loopsNb: " + Arrays.toString(loopsNb) + ", loopsMb: " + Arrays.toString(loopsMb));
        }
        return threadCfgs;
    }

    private static LoopBounds[] divideLoopBounds(int count, int cores) {
        int div = count / cores;
        int rest = count % cores;
        if (div == 0 && rest == 1) {
            LoopBounds bound;
            int threads = 1;
            LoopBounds[] bounds = new LoopBounds[threads];
            bounds[0] = bound = new LoopBounds();
            return bounds;
        }
        if (div == 0 && rest > 1) {
            int threads = rest;
            LoopBounds[] bounds = new LoopBounds[threads];
            int i = 0;
            while (i < bounds.length) {
                LoopBounds bound = new LoopBounds();
                bound.lo = i;
                bound.hi = i + 1;
                bound.hi_is_last = false;
                if (i == bounds.length - 1) {
                    bound.hi_is_last = true;
                }
                bounds[i] = bound;
                ++i;
            }
            return bounds;
        }
        int threads = cores;
        LoopBounds[] bounds = new LoopBounds[threads];
        int i = 0;
        while (i < bounds.length) {
            LoopBounds bound = new LoopBounds();
            bound.lo = i * div;
            bound.hi = (i + 1) * div;
            bound.hi_is_last = false;
            if (i == bounds.length - 1) {
                bound.hi_is_last = true;
            }
            bounds[i] = bound;
            ++i;
        }
        if (rest > 0) {
            i = 0;
            while (i < bounds.length) {
                if (i == 0) {
                    ++bounds[i].hi;
                } else {
                    int delta = bounds[i].hi - bounds[i].lo;
                    bounds[i].lo = bounds[i - 1].hi;
                    bounds[i].hi = rest > 0 ? bounds[i].lo + delta + 1 : bounds[i].lo + delta;
                }
                --rest;
                ++i;
            }
        }
        return bounds;
    }

    static int availableCores() {
        int cores = Runtime.getRuntime().availableProcessors();
        if (cores <= 2) {
            return cores;
        }
        if (cores % 2 != 0) {
            return cores;
        }
        return cores / 2 + cores / 2;
    }

    private static final class LoopBounds {
        int lo = 0;
        int hi = 1;
        boolean hi_is_last = true;

        private LoopBounds() {
        }

        public String toString() {
            return "for [" + this.lo + ".." + this.hi + ") (hi_is_last=" + this.hi_is_last + ")";
        }
    }

    static final class TaskConfig {
        int nb_lo = 0;
        int nb_hi = 1;
        boolean nb_hi_is_last = true;
        int kb_lo = 0;
        int kb_hi = 1;
        boolean kb_hi_is_last = true;
        int mb_lo = 0;
        int mb_hi = 1;
        boolean mb_hi_is_last = true;
        String loop = "";
        int tasks;

        TaskConfig() {
        }

        public String toString() {
            return "{nb_lo=" + this.nb_lo + ", nb_hi=" + this.nb_hi + " (last=" + this.nb_hi_is_last + "), kb_lo=" + this.kb_lo + ", kb_hi=" + this.kb_hi + " (last=" + this.kb_hi_is_last + "), mb_lo=" + this.mb_lo + ", mb_hi=" + this.mb_hi + " (last=" + this.mb_hi_is_last + ")}";
        }
    }
}

