/*
 * Decompiled with CFR 0.152.
 */
package org.netlib.blas;

import org.netlib.blas.Lsame;
import org.netlib.err.Xerbla;

public final class Dgemv {
    public static void dgemv(String trans, int m, int n, double alpha, double[] a, int _a_offset, int lda, double[] x, int _x_offset, int incx, double beta, double[] y, int _y_offset, int incy) {
        int j;
        int leny;
        int lenx;
        int info = 0;
        if (!(Lsame.lsame(trans, "N") || Lsame.lsame(trans, "T") || Lsame.lsame(trans, "C"))) {
            info = 1;
        } else if (m < 0) {
            info = 2;
        } else if (n < 0) {
            info = 3;
        } else if (lda < Math.max(1, m)) {
            info = 6;
        } else if (incx == 0) {
            info = 8;
        } else if (incy == 0) {
            info = 11;
        }
        if (info != 0) {
            Xerbla.xerbla("DGEMV ", info);
            return;
        }
        if (m == 0 || n == 0 || alpha == 0.0 && beta == 1.0) {
            return;
        }
        if (Lsame.lsame(trans, "N")) {
            lenx = n;
            leny = m;
        } else {
            lenx = m;
            leny = n;
        }
        int kx = incx > 0 ? 1 : 1 - (lenx - 1) * incx;
        int ky = incy > 0 ? 1 : 1 - (leny - 1) * incy;
        if (beta != 1.0) {
            int p;
            if (incy == 1) {
                int i;
                if (beta == 0.0) {
                    i = 1;
                    p = leny;
                    while (p > 0) {
                        y[i - 1 + _y_offset] = 0.0;
                        ++i;
                        --p;
                    }
                } else {
                    i = 1;
                    p = leny;
                    while (p > 0) {
                        y[i - 1 + _y_offset] = beta * y[i - 1 + _y_offset];
                        ++i;
                        --p;
                    }
                }
            } else {
                int iy = ky;
                if (beta == 0.0) {
                    p = leny;
                    while (p > 0) {
                        y[iy - 1 + _y_offset] = 0.0;
                        iy += incy;
                        --p;
                    }
                } else {
                    p = leny;
                    while (p > 0) {
                        y[iy - 1 + _y_offset] = beta * y[iy - 1 + _y_offset];
                        iy += incy;
                        --p;
                    }
                }
            }
        }
        if (alpha == 0.0) {
            return;
        }
        if (Lsame.lsame(trans, "N")) {
            int jx = kx;
            if (incy == 1) {
                j = 1;
                int p = n;
                while (p > 0) {
                    if (x[jx - 1 + _x_offset] != 0.0) {
                        double temp = alpha * x[jx - 1 + _x_offset];
                        int i = 1;
                        int q = m;
                        while (q > 0) {
                            y[i - 1 + _y_offset] = y[i - 1 + _y_offset] + temp * a[i - 1 + (j - 1) * lda + _a_offset];
                            ++i;
                            --q;
                        }
                    }
                    jx += incx;
                    ++j;
                    --p;
                }
            } else {
                j = 1;
                int p = n;
                while (p > 0) {
                    if (x[jx - 1 + _x_offset] != 0.0) {
                        double temp = alpha * x[jx - 1 + _x_offset];
                        int iy = ky;
                        int i = 1;
                        int q = m;
                        while (q > 0) {
                            y[iy - 1 + _y_offset] = y[iy - 1 + _y_offset] + temp * a[i - 1 + (j - 1) * lda + _a_offset];
                            iy += incy;
                            ++i;
                            --q;
                        }
                    }
                    jx += incx;
                    ++j;
                    --p;
                }
            }
        } else {
            int jy = ky;
            if (incx == 1) {
                j = 1;
                int p = n;
                while (p > 0) {
                    double temp = 0.0;
                    int i = 1;
                    int q = m;
                    while (q > 0) {
                        temp += a[i - 1 + (j - 1) * lda + _a_offset] * x[i - 1 + _x_offset];
                        ++i;
                        --q;
                    }
                    y[jy - 1 + _y_offset] = y[jy - 1 + _y_offset] + alpha * temp;
                    jy += incy;
                    ++j;
                    --p;
                }
            } else {
                j = 1;
                int p = n;
                while (p > 0) {
                    double temp = 0.0;
                    int ix = kx;
                    int i = 1;
                    int q = m;
                    while (q > 0) {
                        temp += a[i - 1 + (j - 1) * lda + _a_offset] * x[ix - 1 + _x_offset];
                        ix += incx;
                        ++i;
                        --q;
                    }
                    y[jy - 1 + _y_offset] = y[jy - 1 + _y_offset] + alpha * temp;
                    jy += incy;
                    ++j;
                    --p;
                }
            }
        }
    }
}

