/*
 * Decompiled with CFR 0.152.
 */
package org.netlib.blas;

import org.netlib.err.Xerbla;

public final class Dger {
    public static void dger(int m, int n, double alpha, double[] x, int _x_offset, int incx, double[] y, int _y_offset, int incy, double[] a, int _a_offset, int lda) {
        int info = 0;
        if (m < 0) {
            info = 1;
        } else if (n < 0) {
            info = 2;
        } else if (incx == 0) {
            info = 5;
        } else if (incy == 0) {
            info = 7;
        } else if (lda < Math.max(1, m)) {
            info = 9;
        }
        if (info != 0) {
            Xerbla.xerbla("DGER  ", info);
            return;
        }
        if (m == 0 || n == 0 || alpha == 0.0) {
            return;
        }
        int jy = 0;
        jy = incy > 0 ? 1 : 1 - (n - 1) * incy;
        if (incx == 1) {
            int j = 1;
            int p = n;
            while (p > 0) {
                if (y[jy - 1 + _y_offset] != 0.0) {
                    double temp = alpha * y[jy - 1 + _y_offset];
                    int i = 1;
                    int q = m;
                    while (q > 0) {
                        a[i - 1 + (j - 1) * lda + _a_offset] = a[i - 1 + (j - 1) * lda + _a_offset] + x[i - 1 + _x_offset] * temp;
                        ++i;
                        --q;
                    }
                }
                jy += incy;
                ++j;
                --p;
            }
        } else {
            int kx = incx > 0 ? 1 : 1 - (m - 1) * incx;
            int j = 1;
            int p = n;
            while (p > 0) {
                if (y[jy - 1 + _y_offset] != 0.0) {
                    double temp = alpha * y[jy - 1 + _y_offset];
                    int ix = kx;
                    int i = 1;
                    int q = m;
                    while (q > 0) {
                        a[i - 1 + (j - 1) * lda + _a_offset] = a[i - 1 + (j - 1) * lda + _a_offset] + x[ix - 1 + _x_offset] * temp;
                        ix += incx;
                        ++i;
                        --q;
                    }
                }
                jy += incy;
                ++j;
                --p;
            }
        }
    }
}

