/*
 * Decompiled with CFR 0.152.
 */
package org.netlib.blas;

import org.netlib.blas.Axpy;

final class Geaxpy {
    static void geaxpy(int m, int n, double alpha, int X_start, double[] X, int incRowX, int incColX, int Y_start, double[] Y, int incRowY, int incColY) {
        if (m <= 0 || n <= 0 || alpha == 0.0) {
            return;
        }
        if (incRowX == 1 && incRowY == 1) {
            int j = 0;
            while (j < n) {
                Axpy.axpy(m, alpha, X, X_start + j * incColX, 1, Y, Y_start + j * incColY, 1);
                ++j;
            }
        } else if (incColX == 1 && incColY == 1) {
            int i = 0;
            while (i < m) {
                Axpy.axpy(n, alpha, X, X_start + i * incRowX, 1, Y, Y_start + i * incRowY, 1);
                ++i;
            }
        } else {
            int j = 0;
            while (j < n) {
                int base_Y = Y_start + j * incColY;
                int _incColX = j * incColX;
                int i = 0;
                while (i < m) {
                    int n2 = base_Y + i * incRowY;
                    Y[n2] = Y[n2] + alpha * X[i * incRowX + _incColX];
                    ++i;
                }
                ++j;
            }
        }
    }

    private Geaxpy() {
        throw new AssertionError();
    }
}

