/*
 * Decompiled with CFR 0.152.
 */
package org.netlib.blas;

import org.netlib.blas.Gepack;
import org.netlib.blas.Gescal;
import org.netlib.blas.Mgemm;
import org.netlib.blas.Mtrlmm;
import org.netlib.blas.Trlpack;

final class Trlmm {
    static void trlmm(int m, int n, double alpha, boolean unitDiag, int A_start, double[] A, int incRowA, int incColA, int B_start, double[] B, int incRowB, int incColB) {
        if (alpha == 0.0) {
            Gescal.gescal(m, n, 0.0, B_start, B, incRowB, incColB);
            return;
        }
        int mb = (m + 384 - 1) / 384;
        int nb = (n + 4096 - 1) / 4096;
        int mc_ = m % 384;
        int nc_ = n % 4096;
        double[] A_ = new double[147460];
        double[] B_ = new double[1572868];
        double[] C_ = new double[16];
        double[] AB = new double[16];
        int j = 0;
        while (j < nb) {
            int nc = j != nb - 1 || nc_ == 0 ? 4096 : nc_;
            int l = mb - 1;
            while (l >= 0) {
                int kc = l != mb - 1 || mc_ == 0 ? 384 : mc_;
                Gepack.gepack_B(kc, nc, B_start + l * 384 * incRowB + j * 4096 * incColB, B, incRowB, incColB, B_);
                Trlpack.trlpack(kc, unitDiag, A_start + l * 384 * (incRowA + incColA), A, incRowA, incColA, A_);
                Mtrlmm.mtrlmm(kc, nc, alpha, A_, B_, B_start + l * 384 * incRowB + j * 4096 * incColB, B, incRowB, incColB, AB, C_);
                int i = l + 1;
                while (i < mb) {
                    int mc = i != mb - 1 || mc_ == 0 ? 384 : mc_;
                    Gepack.gepack_A(mc, kc, A_start + i * 384 * incRowA + l * 384 * incColA, A, incRowA, incColA, A_);
                    Mgemm.mgemm(mc, nc, kc, alpha, A_, B_, 1.0, B_start + i * 384 * incRowB + j * 4096 * incColB, B, incRowB, incColB, AB, C_);
                    ++i;
                }
                --l;
            }
            ++j;
        }
    }

    private Trlmm() {
        throw new AssertionError();
    }
}

