/*
 * Decompiled with CFR 0.152.
 */
package org.netlib.lapack;

import org.netlib.blas.Dnrm2;
import org.netlib.blas.Dscal;
import org.netlib.lapack.Dlapy2;
import org.netlib.util.Util;
import org.netlib.util.doubleW;

public final class Dlarfg {
    public static void dlarfg(int n, doubleW alpha, double[] x, int _x_offset, int incx, doubleW tau) {
        if (n <= 1) {
            tau.val = 0.0;
            return;
        }
        double xnorm = Dnrm2.dnrm2(n - 1, x, _x_offset, incx);
        if (xnorm == 0.0) {
            tau.val = 0.0;
        } else {
            double beta = -Util.dsign(Dlapy2.dlapy2(alpha.val, xnorm), alpha.val);
            double safmin = 2.004168360008973E-292;
            if (Math.abs(beta) < 2.004168360008973E-292) {
                double rsafmn = 4.9896007738368E291;
                int knt = 0;
                do {
                    ++knt;
                    Dscal.dscal(n - 1, 4.9896007738368E291, x, _x_offset, incx);
                    alpha.val *= 4.9896007738368E291;
                } while (Math.abs(beta *= 4.9896007738368E291) < 2.004168360008973E-292);
                xnorm = Dnrm2.dnrm2(n - 1, x, _x_offset, incx);
                beta = -Util.dsign(Dlapy2.dlapy2(alpha.val, xnorm), alpha.val);
                tau.val = (beta - alpha.val) / beta;
                Dscal.dscal(n - 1, 1.0 / (alpha.val - beta), x, _x_offset, incx);
                alpha.val = beta;
                int j = knt;
                while (j > 0) {
                    alpha.val *= 2.004168360008973E-292;
                    --j;
                }
            } else {
                tau.val = (beta - alpha.val) / beta;
                Dscal.dscal(n - 1, 1.0 / (alpha.val - beta), x, _x_offset, incx);
                alpha.val = beta;
            }
        }
    }
}

