/*
 * Decompiled with CFR 0.152.
 */
package org.netlib.lapack;

import org.netlib.blas.Lsame;
import org.netlib.err.Xerbla;
import org.netlib.lapack.Dlarf;
import org.netlib.util.intW;

public final class Dorm2r {
    public static void dorm2r(String side, String trans, int m, int n, int k, double[] a, int _a_offset, int lda, double[] tau, int _tau_offset, double[] c, int _c_offset, int ldc, double[] work, int _work_offset, intW info) {
        info.val = 0;
        boolean left = Lsame.lsame(side, "L");
        boolean notran = Lsame.lsame(trans, "N");
        int nq = left ? m : n;
        if (!left && !Lsame.lsame(side, "R")) {
            info.val = -1;
        } else if (!notran && !Lsame.lsame(trans, "T")) {
            info.val = -2;
        } else if (m < 0) {
            info.val = -3;
        } else if (n < 0) {
            info.val = -4;
        } else if (k < 0 || k > nq) {
            info.val = -5;
        } else if (lda < Math.max(1, nq)) {
            info.val = -7;
        } else if (ldc < Math.max(1, m)) {
            info.val = -10;
        }
        if (info.val != 0) {
            Xerbla.xerbla("DORM2R", -info.val);
            return;
        }
        if (m == 0 || n == 0 || k == 0) {
            return;
        }
        int i1 = 0;
        int i2 = 0;
        int i3 = 0;
        if (left && !notran || !left && notran) {
            i1 = 1;
            i2 = k;
            i3 = 1;
        } else {
            i1 = k;
            i2 = 1;
            i3 = -1;
        }
        int ni = 0;
        int jc = 0;
        int mi = 0;
        int ic = 0;
        if (left) {
            ni = n;
            jc = 1;
        } else {
            mi = m;
            ic = 1;
        }
        int i = i1;
        int p = (i2 - i1 + i3) / i3;
        while (p > 0) {
            if (left) {
                mi = m - i + 1;
                ic = i;
            } else {
                ni = n - i + 1;
                jc = i;
            }
            double aii = a[i - 1 + (i - 1) * lda + _a_offset];
            a[i - 1 + (i - 1) * lda + _a_offset] = 1.0;
            Dlarf.dlarf(side, mi, ni, a, i - 1 + (i - 1) * lda + _a_offset, 1, tau[i - 1 + _tau_offset], c, ic - 1 + (jc - 1) * ldc + _c_offset, ldc, work, _work_offset);
            a[i - 1 + (i - 1) * lda + _a_offset] = aii;
            i += i3;
            --p;
        }
    }
}

