/*
 * Decompiled with CFR 0.152.
 */
package rx.testkit;

import io.reactivex.Maybe;
import io.reactivex.observers.TestObserver;
import io.reactivex.schedulers.TestScheduler;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.AbstractListAssert;
import org.assertj.core.api.AbstractObjectAssert;
import org.assertj.core.api.Assertions;

public class AssertMaybe<T>
extends AbstractAssert<AssertMaybe<T>, Maybe> {
    private final TestObserver<T> subscriber = new TestObserver();
    private TestScheduler scheduler;

    private AssertMaybe(Maybe<T> maybe) {
        super(maybe, AssertMaybe.class);
        maybe.subscribe(this.subscriber);
    }

    private AssertMaybe(Maybe<T> maybe, TestScheduler scheduler) {
        super(maybe, AssertMaybe.class);
        this.scheduler = scheduler;
        maybe.subscribe(this.subscriber);
    }

    public static <T> AssertMaybe<T> assertThat(Maybe<T> maybe) {
        return new AssertMaybe<T>(maybe);
    }

    public static <T> AssertMaybe<T> assertThat(Maybe<T> maybe, TestScheduler scheduler) {
        return new AssertMaybe<T>(maybe, scheduler);
    }

    public AbstractObjectAssert<?, ? extends T> value() {
        Object value = this.subscriber.values().get(0);
        return Assertions.assertThat(value);
    }

    public AssertMaybe<T> noValue() {
        int count = this.subscriber.valueCount();
        if (count != 0) {
            throw new AssertionError((Object)("Expecting no values but found " + count));
        }
        return this;
    }

    public AbstractListAssert<?, ? extends List<? extends Throwable>, Throwable> failures() {
        return Assertions.assertThat((List)this.subscriber.errors());
    }

    public AssertMaybe<T> hasCompleted() {
        this.subscriber.assertTerminated();
        return this;
    }

    public AssertMaybe<T> hasNotCompleted() {
        this.subscriber.assertNotTerminated();
        return this;
    }

    public AssertMaybe<T> after(long duration, TimeUnit timeUnit) {
        if (this.scheduler == null) {
            throw new IllegalStateException("No TestScheduler provided. Perhaps you forgot to 'assertThat(Observable, TestScheduler)'?");
        }
        this.scheduler.advanceTimeBy(duration, timeUnit);
        return this;
    }
}

