/*
 * Decompiled with CFR 0.152.
 */
package ooxml2java2d.docx.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import ooxml2java2d.docx.internal.ContentTooBigException;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;

public class Column {
    private int xOffset;
    private int width;
    private int contentWidth;
    private int contentHeight;
    private List<Object> actions = new ArrayList<Object>();
    private boolean isCachedOverPageFold;

    public Column(int xOffset, int width) {
        this.width = width;
        this.xOffset = xOffset;
    }

    public int getContentWidth() {
        return this.contentWidth;
    }

    public int getContentHeight() {
        return this.contentHeight;
    }

    public int getWidth() {
        return this.width;
    }

    public int getXOffset() {
        return this.xOffset;
    }

    public List<Object> getActions() {
        return Collections.unmodifiableList(this.actions);
    }

    public boolean hasContent() {
        return this.actions.size() > 0;
    }

    public boolean canFitContent(double newContentWidth) {
        return (double)this.contentWidth + newContentWidth <= (double)this.width;
    }

    public void addContent(double newContentWidth, double newContentHeight, Object newContent) {
        if (!this.canFitContent(newContentWidth)) {
            throw new ContentTooBigException("Content too big for current line");
        }
        this.addContentForced(newContentWidth, newContentHeight, newContent);
    }

    public void addContentForced(double newContentWidth, double newContentHeight, Object newContent) {
        this.contentWidth = (int)((double)this.contentWidth + newContentWidth);
        this.contentHeight = (int)Math.max((double)this.contentHeight, newContentHeight);
        this.actions.add(newContent);
    }

    public void addContentOffset(int offset) {
        if (!this.canFitContent(offset)) {
            throw new ContentTooBigException("Offset too big for current line");
        }
        this.contentWidth += offset;
    }

    public void addAction(Object action) {
        this.actions.add(action);
    }

    public boolean isCachedOverPageFold() {
        return this.isCachedOverPageFold;
    }

    public void setCacheOverPageFold(boolean isCachedOverPageFold) {
        this.isCachedOverPageFold = isCachedOverPageFold;
    }

    public void reset() {
        this.contentWidth = 0;
        this.contentHeight = 0;
        this.actions.clear();
    }

    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE).append("xOffset", this.xOffset).append("width", this.width).append("contentWidth", this.contentWidth).append("contentHeight", this.contentHeight).append("actions", this.actions).append("isCachedOverPageFold", this.isCachedOverPageFold).toString();
    }
}

