/*
 * Decompiled with CFR 0.152.
 */
package ooxml2java2d.docx;

import java.awt.Color;
import java.awt.geom.Rectangle2D;
import java.io.File;
import java.io.IOException;
import java.math.BigInteger;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import javax.xml.bind.JAXBElement;
import javax.xml.namespace.QName;
import ooxml2java2d.GraphicsBuilder;
import ooxml2java2d.Renderer;
import ooxml2java2d.docx.internal.FontStyle;
import ooxml2java2d.docx.internal.GraphicsRenderer;
import ooxml2java2d.docx.internal.HAlignment;
import ooxml2java2d.docx.internal.PageInitiationAdapter;
import ooxml2java2d.docx.internal.PageLayout;
import ooxml2java2d.docx.internal.ParagraphStyle;
import ooxml2java2d.docx.internal.VAlignment;
import ooxml2java2d.docx.internal.content.Border;
import ooxml2java2d.docx.internal.content.BorderStyle;
import ooxml2java2d.docx.internal.content.Column;
import ooxml2java2d.docx.internal.content.Content;
import ooxml2java2d.docx.internal.content.ImageContent;
import ooxml2java2d.docx.internal.content.Line;
import ooxml2java2d.docx.internal.content.StringContent;
import ooxml2java2d.docx.internal.content.TableRow;
import org.apache.commons.lang.StringUtils;
import org.docx4j.dml.CTPositiveSize2D;
import org.docx4j.dml.GraphicData;
import org.docx4j.dml.wordprocessingDrawing.Anchor;
import org.docx4j.dml.wordprocessingDrawing.Inline;
import org.docx4j.model.listnumbering.AbstractListNumberingDefinition;
import org.docx4j.model.listnumbering.ListLevel;
import org.docx4j.model.structure.SectionWrapper;
import org.docx4j.model.styles.StyleTree;
import org.docx4j.openpackaging.exceptions.Docx4JException;
import org.docx4j.openpackaging.packages.WordprocessingMLPackage;
import org.docx4j.openpackaging.parts.WordprocessingML.FooterPart;
import org.docx4j.openpackaging.parts.WordprocessingML.HeaderPart;
import org.docx4j.openpackaging.parts.WordprocessingML.MainDocumentPart;
import org.docx4j.openpackaging.parts.relationships.RelationshipsPart;
import org.docx4j.wml.Br;
import org.docx4j.wml.CTBorder;
import org.docx4j.wml.CTHeight;
import org.docx4j.wml.CTTblCellMar;
import org.docx4j.wml.ContentAccessor;
import org.docx4j.wml.Drawing;
import org.docx4j.wml.Lvl;
import org.docx4j.wml.P;
import org.docx4j.wml.PPr;
import org.docx4j.wml.PPrBase;
import org.docx4j.wml.R;
import org.docx4j.wml.RPr;
import org.docx4j.wml.STVerticalAlignRun;
import org.docx4j.wml.SectPr;
import org.docx4j.wml.Style;
import org.docx4j.wml.Tbl;
import org.docx4j.wml.TblGridCol;
import org.docx4j.wml.TblWidth;
import org.docx4j.wml.Tc;
import org.docx4j.wml.TcMar;
import org.docx4j.wml.TcPrInner;
import org.docx4j.wml.Text;
import org.docx4j.wml.Tr;
import org.docx4j.wml.UnderlineEnumeration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DocxRenderer
implements Renderer {
    private static final Logger LOG = LoggerFactory.getLogger(DocxRenderer.class);
    private static final QName QNAME_TEXT = new QName("http://schemas.openxmlformats.org/wordprocessingml/2006/main", "t");
    private static final int TAB_WIDTH = 712;
    private static final int EMU_DIVISOR = 635;
    private static final String BULLET = new Character('\u2022').toString();
    private WordprocessingMLPackage word;
    private MainDocumentPart main;
    private PageInitiationAdapter initiation;
    private GraphicsRenderer renderer;
    private Deque<PageLayout> layouts;
    private PageLayout layout;
    private int page = 1;
    private ParagraphStyle defaultParaStyle;
    private ParagraphStyle paraStyle;
    private ParagraphStyle runStyle;
    private RelationshipsPart relationshipPart;

    public DocxRenderer(File docx) throws IOException {
        try {
            this.word = WordprocessingMLPackage.load((File)docx);
            this.main = this.word.getMainDocumentPart();
        }
        catch (Docx4JException e) {
            throw new IOException("Error loading document", e);
        }
        this.initiation = new PageInitiationAdapter(){

            @Override
            public void initiatePage() {
                DocxRenderer.this.initPage();
            }
        };
    }

    @Override
    public void render(GraphicsBuilder builder) {
        this.renderer = new GraphicsRenderer(builder, this.initiation);
        this.layouts = this.getPageLayouts(this.word);
        this.setDefaultStyles();
        this.createPageFromNextLayout();
        this.iterateContentParts((ContentAccessor)this.main, new Column(this.layout.getLeftMargin(), this.layout.getWidth() - this.layout.getLeftMargin() - this.layout.getRightMargin()));
    }

    private void setDefaultStyles() {
        this.defaultParaStyle = this.getRunStyle(new ParagraphStyle(), ((StyleTree.AugmentedStyle)this.main.getStyleTree().getParagraphStylesTree().get("DocDefaults").getData()).getStyle().getRPr());
        if (this.main.getStyleDefinitionsPart().getDefaultParagraphStyle() != null) {
            this.defaultParaStyle = this.getStyle(this.defaultParaStyle, this.main.getStyleDefinitionsPart().getDefaultParagraphStyle());
        }
    }

    private Deque<PageLayout> getPageLayouts(WordprocessingMLPackage word) {
        ArrayDeque<PageLayout> layouts = new ArrayDeque<PageLayout>();
        for (SectionWrapper sw : word.getDocumentModel().getSections()) {
            layouts.add(this.createPageLayout(sw));
        }
        return layouts;
    }

    private PageLayout createPageLayout(SectionWrapper sw) {
        SectPr sectPr = sw.getSectPr();
        SectPr.PgSz size = sectPr.getPgSz();
        SectPr.PgMar margin = sectPr.getPgMar();
        return new PageLayout(size.getW().intValue(), size.getH().intValue(), this.getValue(margin.getTop()), this.getValue(margin.getRight()), this.getValue(margin.getBottom()), this.getValue(margin.getLeft()), this.getValue(margin.getHeader()), this.getValue(margin.getFooter()), sw.getHeaderFooterPolicy());
    }

    private void createPageFromNextLayout() {
        this.layout = this.layouts.removeFirst();
        this.renderer.nextPage(this.layout.getWidth(), this.layout.getHeight());
    }

    private void initPage() {
        int footerStart;
        HeaderPart header = null;
        FooterPart footer = null;
        if (this.page == 1) {
            header = this.layout.getHeaderFooterPolicy().getFirstHeader();
            footer = this.layout.getHeaderFooterPolicy().getFirstFooter();
        }
        if (header == null) {
            header = this.layout.getHeaderFooterPolicy().getHeader(this.page);
        }
        if (header == null) {
            header = this.layout.getHeaderFooterPolicy().getDefaultHeader();
        }
        if (header != null) {
            this.relationshipPart = header.getRelationshipsPart(false);
            this.renderer.setYOffset(this.layout.getHeaderMargin());
            this.iterateContentParts((ContentAccessor)header, new Column(this.layout.getLeftMargin(), this.layout.getWidth()));
            if (this.renderer.getYOffset() < this.layout.getTopMargin()) {
                this.renderer.setYOffset(this.layout.getTopMargin());
            }
        } else {
            this.renderer.setYOffset(this.layout.getTopMargin());
        }
        int headerEndYOffset = this.renderer.getYOffset();
        if (footer == null) {
            footer = this.layout.getHeaderFooterPolicy().getFooter(this.page);
        }
        if (footer == null) {
            footer = this.layout.getHeaderFooterPolicy().getDefaultFooter();
        }
        if (footer != null) {
            this.relationshipPart = footer.getRelationshipsPart(false);
            Column footerCol = new Column(this.layout.getLeftMargin(), this.layout.getWidth());
            footerCol.setBuffered(true);
            this.iterateContentParts((ContentAccessor)footer, footerCol);
            footerCol.setBuffered(false);
            footerStart = this.layout.getHeight() - this.layout.getFooterMargin() - footerCol.getContentHeight();
            this.renderer.setYOffset(footerStart);
            this.renderer.renderColumn(footerCol);
        } else {
            footerStart = this.layout.getHeight() - this.layout.getBottomMargin();
        }
        ++this.page;
        this.relationshipPart = this.main.getRelationshipsPart();
        this.renderer.setYOffset(headerEndYOffset);
        this.renderer.setEndPosition(footerStart);
    }

    private void iterateContentParts(ContentAccessor ca, Column column) {
        for (Object obj : ca.getContent()) {
            if (obj instanceof P) {
                if (!this.processParagraph((P)obj, column)) continue;
                column = new Column(this.layout.getLeftMargin(), this.layout.getWidth() - this.layout.getLeftMargin() - this.layout.getRightMargin());
                continue;
            }
            if (obj instanceof R) {
                this.processTextRun((R)obj, column);
                continue;
            }
            if (obj instanceof Br) {
                this.processBreak((Br)obj, column);
                continue;
            }
            if (obj instanceof JAXBElement) {
                JAXBElement element = (JAXBElement)obj;
                if (element.getDeclaredType().equals(Text.class)) {
                    if (!element.getName().equals(QNAME_TEXT)) continue;
                    this.processText(((Text)element.getValue()).getValue(), column);
                    continue;
                }
                if (element.getDeclaredType().equals(R.Tab.class)) {
                    this.processTab((R.Tab)element.getValue(), column);
                    continue;
                }
                if (element.getDeclaredType().equals(Tbl.class)) {
                    this.processTable((Tbl)element.getValue(), column);
                    continue;
                }
                if (element.getDeclaredType().equals(Drawing.class)) {
                    this.processDrawing((Drawing)element.getValue(), column);
                    continue;
                }
                if (element.getDeclaredType().equals(P.Hyperlink.class)) {
                    this.processHyperlink((P.Hyperlink)element.getValue(), column);
                    continue;
                }
                LOG.debug("Unhandled JAXBElement object " + element.getDeclaredType());
                continue;
            }
            LOG.debug("Unhandled document object " + obj.getClass());
        }
    }

    private boolean processParagraph(P p, Column column) {
        PPr properties = p.getPPr();
        this.paraStyle = this.getParagraphStyle(this.defaultParaStyle, properties);
        column.addAction((Object)this.paraStyle.getHAlignment());
        column.addVerticalSpace(this.paraStyle.getSpaceBefore());
        Column paraContent = new Column(column.getXOffset() + this.paraStyle.getIndentLeft(), column.getWidth() - this.paraStyle.getIndentLeft() - this.paraStyle.getIndentRight());
        if (properties != null && properties.getNumPr() != null) {
            ListLevel listLvl;
            PPrBase.NumPr numberingProperties = properties.getNumPr();
            String abstractNumId = numberingProperties.getNumId().getVal().toString();
            String levelReference = numberingProperties.getIlvl().getVal().toString();
            AbstractListNumberingDefinition numberingDef = (AbstractListNumberingDefinition)this.main.getNumberingDefinitionsPart().getAbstractListDefinitions().get(abstractNumId);
            if (numberingDef != null && (listLvl = (ListLevel)numberingDef.getListLevels().get(levelReference)).IsBullet()) {
                Lvl lvl = listLvl.getJaxbAbstractLvl();
                this.paraStyle = this.getParagraphStyle(this.paraStyle, lvl.getPPr());
                Rectangle2D bounds = this.paraStyle.getStringBoxSize(BULLET);
                paraContent = new Column(column.getXOffset() + this.paraStyle.getIndentLeft(), column.getWidth() - this.paraStyle.getIndentLeft());
                paraContent.addContent(new StringContent((int)bounds.getWidth(), (int)bounds.getHeight(), BULLET), this.paraStyle.getLineSpacing());
                paraContent.addHorizontalSpace(this.paraStyle.getIndentHanging(), this.paraStyle.getLineSpacing());
            }
        }
        if (properties != null && p.getContent().size() == 0) {
            column.addVerticalSpace((int)this.paraStyle.getStringBoxSize("").getHeight());
        } else {
            paraContent.setBuffered(column.isBuffered());
            this.iterateContentParts((ContentAccessor)p, paraContent);
            paraContent.setBuffered(false);
        }
        column.addRow(paraContent);
        column.addVerticalSpace(this.paraStyle.getSpaceAfter());
        this.renderer.renderColumn(column);
        if (properties != null && properties.getSectPr() != null) {
            this.createPageFromNextLayout();
            return true;
        }
        return false;
    }

    private void processTextRun(R run, Column column) {
        ParagraphStyle newRunStyle = this.getRunStyle(this.paraStyle, run.getRPr());
        if (this.runStyle == null || !newRunStyle.getFontConfig().equals(this.runStyle.getFontConfig())) {
            column.addAction(newRunStyle.getFontConfig());
        }
        if (this.runStyle == null || !newRunStyle.getColor().equals(this.runStyle.getColor())) {
            column.addAction(new Color(newRunStyle.getColor().getRGB()));
        }
        this.runStyle = newRunStyle;
        column.addAction((Object)this.paraStyle.getHAlignment());
        if (run.getRPr() != null && run.getContent().size() == 0) {
            column.addVerticalSpace((int)this.paraStyle.getStringBoxSize("").getHeight());
        } else {
            this.iterateContentParts((ContentAccessor)run, column);
        }
    }

    private void processBreak(Br br, Column column) {
        if (br.getType() == null) {
            this.renderer.renderColumn(column);
        } else {
            switch (br.getType()) {
                case PAGE: {
                    this.renderer.renderColumn(column);
                    this.renderer.nextPage(this.layout.getWidth(), this.layout.getHeight());
                    break;
                }
                default: {
                    LOG.debug("Unhandled break type " + br.getType());
                }
            }
        }
    }

    private void processText(String text, Column column) {
        Rectangle2D bounds = this.runStyle.getStringBoxSize(text);
        Line line = column.getCurrentLine();
        if (line.canFitContent(bounds.getWidth())) {
            column.addContent(new StringContent((int)bounds.getWidth(), (int)bounds.getHeight(), text), this.paraStyle.getLineSpacing());
        } else {
            String[] words = text.split(" ");
            String newText = "";
            for (int i = 0; i < words.length; ++i) {
                bounds = newText.isEmpty() ? this.runStyle.getStringBoxSize(words[i]) : this.runStyle.getStringBoxSize(newText + " " + words[i]);
                if (!line.canFitContent(bounds.getWidth())) {
                    if (i != 0) break;
                    char[] chars = text.toCharArray();
                    for (int k = 0; k < chars.length && line.canFitContent((bounds = this.runStyle.getStringBoxSize(newText + chars[k])).getWidth()); ++k) {
                        newText = newText + chars[k];
                    }
                    continue;
                }
                newText = newText.isEmpty() ? words[i] : newText + " " + words[i];
            }
            bounds = this.runStyle.getStringBoxSize(newText);
            String nextText = text.substring(newText.length()).trim();
            if (nextText.equals(text)) {
                LOG.error("Unable to fit content, skipping: " + nextText);
            } else {
                column.addContent(new StringContent((int)bounds.getWidth(), (int)bounds.getHeight(), newText), 0);
                column.addVerticalSpace(0);
                this.renderer.renderColumn(column);
                this.processText(nextText, column);
            }
        }
    }

    private void processTab(R.Tab tab, Column column) {
        int tabWidth;
        Line line = column.getCurrentLine();
        if (line.canFitContent(tabWidth = 712 - line.getContentWidth() % 712)) {
            column.addContent(new Content(tabWidth, 0), this.paraStyle.getLineSpacing());
        } else {
            column.addContent(new Content(712, 0), this.paraStyle.getLineSpacing());
        }
    }

    private void processTable(Tbl table, Column column) {
        ArrayList<Integer> columnWidths = new ArrayList<Integer>();
        for (TblGridCol tableColumn : table.getTblGrid().getGridCol()) {
            columnWidths.add(tableColumn.getW().intValue());
        }
        CTTblCellMar tableMargins = table.getTblPr().getTblCellMar();
        int topMargin = 0;
        int rightMargin = 0;
        int bottomMargin = 0;
        int leftMargin = 0;
        if (tableMargins != null) {
            topMargin = this.getValue(tableMargins.getTop());
            rightMargin = this.getValue(tableMargins.getRight());
            bottomMargin = this.getValue(tableMargins.getBottom());
            leftMargin = this.getValue(tableMargins.getLeft());
        }
        for (Object tblObj : table.getContent()) {
            if (!(tblObj instanceof Tr)) continue;
            Tr tableRow = (Tr)tblObj;
            int xOffset = column.getXOffset();
            int col = 0;
            ArrayList<Column> cells = new ArrayList<Column>();
            int minHeight = this.getMinRowHeight(tableRow);
            for (Object rowObj : tableRow.getContent()) {
                if (rowObj instanceof JAXBElement) {
                    JAXBElement element = (JAXBElement)rowObj;
                    if (!element.getDeclaredType().equals(Tc.class)) continue;
                    Tc tableCell = (Tc)element.getValue();
                    int width = (Integer)columnWidths.get(col);
                    VAlignment vAlignment = VAlignment.TOP;
                    Color fill = null;
                    Border top = null;
                    Border right = null;
                    Border bottom = null;
                    Border left = null;
                    TcMar cellMargins = tableCell.getTcPr().getTcMar();
                    if (cellMargins != null) {
                        topMargin = this.getValue(cellMargins.getTop(), topMargin);
                        rightMargin = this.getValue(cellMargins.getRight(), rightMargin);
                        bottomMargin = this.getValue(cellMargins.getBottom(), bottomMargin);
                        leftMargin = this.getValue(cellMargins.getLeft(), leftMargin);
                    }
                    if (tableCell.getTcPr().getVAlign() != null) {
                        switch (tableCell.getTcPr().getVAlign().getVal()) {
                            case BOTTOM: {
                                vAlignment = VAlignment.BOTTOM;
                                break;
                            }
                            case CENTER: {
                                vAlignment = VAlignment.CENTER;
                                break;
                            }
                        }
                    }
                    if (tableCell.getTcPr().getGridSpan() != null) {
                        int mergeCols = tableCell.getTcPr().getGridSpan().getVal().intValue();
                        for (int i = 0; i < mergeCols - 1; ++i) {
                            width += ((Integer)columnWidths.get(++col)).intValue();
                        }
                    }
                    if (tableCell.getTcPr().getShd() != null) {
                        fill = this.getColor(tableCell.getTcPr().getShd().getFill(), null);
                    }
                    if (tableCell.getTcPr().getTcBorders() != null) {
                        TcPrInner.TcBorders borders = tableCell.getTcPr().getTcBorders();
                        top = this.getBorder(borders.getTop());
                        right = this.getBorder(borders.getRight());
                        bottom = this.getBorder(borders.getBottom());
                        left = this.getBorder(borders.getLeft());
                    }
                    Column cell = new Column(xOffset, width, vAlignment, fill, top, right, bottom, left);
                    cell.addVerticalSpace(topMargin);
                    Column cellContent = new Column(xOffset + leftMargin, width - leftMargin - rightMargin);
                    cellContent.setBuffered(true);
                    this.iterateContentParts((ContentAccessor)tableCell, cellContent);
                    cellContent.setBuffered(false);
                    cell.addRow(cellContent);
                    cell.addVerticalSpace(bottomMargin);
                    xOffset += cell.getWidth();
                    ++col;
                    cells.add(cell);
                    continue;
                }
                LOG.debug("Unhandled row object " + rowObj.getClass());
            }
            column.addRow(new TableRow(minHeight, cells));
            this.renderer.renderColumn(column);
        }
    }

    private void processDrawing(Drawing drawing, Column column) {
        for (Object obj : drawing.getAnchorOrInline()) {
            if (obj instanceof Inline) {
                Inline inline = (Inline)obj;
                this.processGraphic(inline.getExtent(), inline.getGraphic().getGraphicData(), column);
                continue;
            }
            if (obj instanceof Anchor) {
                Anchor anchor = (Anchor)obj;
                if (anchor.isBehindDoc()) {
                    int width = (int)anchor.getExtent().getCx() / 635;
                    int height = (int)anchor.getExtent().getCy() / 635;
                    int x = this.getValue(anchor.getPositionH().getPosOffset()) / 635;
                    int y = this.getValue(anchor.getPositionV().getPosOffset()) / 635;
                    this.renderer.renderImage(new ImageContent(width, height, this.relationshipPart, anchor.getGraphic().getGraphicData().getPic().getBlipFill().getBlip().getEmbed()), x, y);
                    continue;
                }
                this.processGraphic(anchor.getExtent(), anchor.getGraphic().getGraphicData(), column);
                continue;
            }
            LOG.debug("Unhandled drawing object " + obj.getClass());
        }
    }

    private void processHyperlink(P.Hyperlink link, Column column) {
        this.iterateContentParts((ContentAccessor)link, column);
    }

    private void processGraphic(CTPositiveSize2D extent, GraphicData graphicData, Column column) {
        String rId;
        int width = (int)extent.getCx() / 635;
        int height = (int)extent.getCy() / 635;
        if (graphicData.getPic() != null && !(rId = graphicData.getPic().getBlipFill().getBlip().getEmbed()).isEmpty()) {
            column.addContentForced(new ImageContent(width, height, this.relationshipPart, rId));
        }
    }

    private ParagraphStyle getStyleById(ParagraphStyle baseStyle, String styleId) {
        return this.getStyle(baseStyle, this.main.getStyleDefinitionsPart().getStyleById(styleId));
    }

    private ParagraphStyle getStyle(ParagraphStyle baseStyle, Style style) {
        if (style == null) {
            return baseStyle;
        }
        ParagraphStyle newStyle = style.getBasedOn() == null ? new ParagraphStyle(baseStyle) : this.getStyleById(baseStyle, style.getBasedOn().getVal());
        if (style.getPPr() != null) {
            newStyle = this.getParagraphStyle(newStyle, style.getPPr());
        }
        return this.getRunStyle(newStyle, style.getRPr());
    }

    private ParagraphStyle getParagraphStyle(ParagraphStyle baseStyle, PPr properties) {
        ParagraphStyle newStyle = new ParagraphStyle(baseStyle);
        if (properties != null) {
            PPrBase.Ind indent;
            PPrBase.Spacing spacing;
            if (properties.getPStyle() != null) {
                PPrBase.PStyle pstyle = properties.getPStyle();
                newStyle = this.getStyleById(baseStyle, pstyle.getVal());
            }
            if ((spacing = properties.getSpacing()) != null) {
                if (spacing.getLine() != null) {
                    newStyle.setLineSpacing(this.getValue(spacing.getLine()));
                }
                if (spacing.getBefore() != null) {
                    newStyle.setSpaceBefore(this.getValue(spacing.getBefore()));
                }
                if (spacing.getAfter() != null) {
                    newStyle.setSpaceAfter(this.getValue(spacing.getAfter()));
                }
            }
            if ((indent = properties.getInd()) != null) {
                newStyle.setIndentLeft(this.getValue(indent.getLeft()));
                newStyle.setIndentRight(this.getValue(indent.getRight()));
                newStyle.setIndentHanging(this.getValue(indent.getHanging()));
            }
            if (properties.getJc() != null) {
                switch (properties.getJc().getVal()) {
                    case RIGHT: {
                        newStyle.setHAlignment(HAlignment.RIGHT);
                        break;
                    }
                    case CENTER: {
                        newStyle.setHAlignment(HAlignment.CENTER);
                        break;
                    }
                }
            }
        }
        return newStyle;
    }

    private ParagraphStyle getRunStyle(ParagraphStyle baseStyle, RPr runProperties) {
        String strColor;
        Color newColor;
        float sizePt;
        if (runProperties == null) {
            return baseStyle;
        }
        ParagraphStyle newStyle = new ParagraphStyle(baseStyle);
        if (runProperties.getRFonts() != null && runProperties.getRFonts().getAscii() != null) {
            newStyle.setFontName(runProperties.getRFonts().getAscii());
        }
        if (runProperties.getSz() != null) {
            sizePt = runProperties.getSz().getVal().floatValue() / 2.0f;
            newStyle.setFontSize(sizePt * 20.0f);
        } else if (runProperties.getSzCs() != null) {
            sizePt = runProperties.getSzCs().getVal().floatValue() / 2.0f;
            newStyle.setFontSize(sizePt * 20.0f);
        }
        if (runProperties.getB() != null) {
            newStyle.enableFontStyle(FontStyle.BOLD);
        }
        if (runProperties.getI() != null) {
            newStyle.enableFontStyle(FontStyle.ITALIC);
        }
        if (runProperties.getStrike() != null) {
            newStyle.enableFontStyle(FontStyle.STRIKETHROUGH);
        }
        if (runProperties.getU() != null && runProperties.getU().getVal().equals((Object)UnderlineEnumeration.SINGLE)) {
            newStyle.enableFontStyle(FontStyle.UNDERLINE);
        }
        if (runProperties.getVertAlign() != null && runProperties.getVertAlign().getVal().equals((Object)STVerticalAlignRun.SUPERSCRIPT)) {
            newStyle.enableFontStyle(FontStyle.SUPERSCRIPT);
        }
        if (runProperties.getColor() != null && !(newColor = this.getColor(strColor = runProperties.getColor().getVal(), Color.BLACK)).equals(baseStyle.getColor())) {
            newStyle.setColor(newColor);
        }
        return newStyle;
    }

    private Color getColor(String strColor, Color defaultColor) {
        if (strColor == null || strColor.equals("auto")) {
            return defaultColor;
        }
        String hex = StringUtils.leftPad((String)strColor, (int)6, (char)'0');
        return new Color(Integer.valueOf(hex.substring(0, 2), 16), Integer.valueOf(hex.substring(2, 4), 16), Integer.valueOf(hex.substring(4, 6), 16));
    }

    private Border getBorder(CTBorder ctBorder) {
        int size;
        Border border = null;
        if (ctBorder != null && (size = this.getValue(ctBorder.getSz())) > 0) {
            border = new Border(this.getColor(ctBorder.getColor(), Color.BLACK), (int)((double)size / 8.0 * 20.0), BorderStyle.SINGLE);
        }
        return border;
    }

    private int getMinRowHeight(Tr tableRow) {
        if (tableRow.getTrPr() != null) {
            for (JAXBElement element : tableRow.getTrPr().getCnfStyleOrDivIdOrGridBefore()) {
                if (!(element.getValue() instanceof CTHeight)) continue;
                CTHeight height = (CTHeight)element.getValue();
                return this.getValue(height.getVal());
            }
        }
        return 0;
    }

    private int getValue(Integer i) {
        return i == null ? 0 : i;
    }

    private int getValue(BigInteger bi) {
        return this.getValue(bi, 0);
    }

    private int getValue(BigInteger bi, int defaultValue) {
        return bi == null ? defaultValue : bi.intValue();
    }

    private int getValue(TblWidth width) {
        return this.getValue(width, 0);
    }

    private int getValue(TblWidth width, int defaultValue) {
        return width == null ? defaultValue : this.getValue(width.getW(), defaultValue);
    }
}

