/*
 * Decompiled with CFR 0.152.
 */
package com.github.jasync.sql.db.postgresql.codec;

import com.github.jasync.sql.db.KindedMessage;
import com.github.jasync.sql.db.column.ColumnEncoderRegistry;
import com.github.jasync.sql.db.exceptions.EncoderNotAvailableException;
import com.github.jasync.sql.db.postgresql.codec.MessageEncoderKt;
import com.github.jasync.sql.db.postgresql.encoders.CloseMessageEncoder;
import com.github.jasync.sql.db.postgresql.encoders.CloseStatementEncoder;
import com.github.jasync.sql.db.postgresql.encoders.Encoder;
import com.github.jasync.sql.db.postgresql.encoders.ExecutePreparedStatementEncoder;
import com.github.jasync.sql.db.postgresql.encoders.PasswordEncoder;
import com.github.jasync.sql.db.postgresql.encoders.PreparedStatementOpeningEncoder;
import com.github.jasync.sql.db.postgresql.encoders.QueryMessageEncoder;
import com.github.jasync.sql.db.postgresql.encoders.SSLMessageEncoder;
import com.github.jasync.sql.db.postgresql.encoders.StartupMessageEncoder;
import com.github.jasync.sql.db.postgresql.messages.frontend.ClientMessage;
import com.github.jasync.sql.db.postgresql.messages.frontend.SSLRequestMessage;
import com.github.jasync.sql.db.postgresql.messages.frontend.StartupMessage;
import com.github.jasync.sql.db.util.BufferDumper;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.MessageToMessageEncoder;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J&\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00022\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00020\u001aH\u0014R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/github/jasync/sql/db/postgresql/codec/MessageEncoder;", "Lio/netty/handler/codec/MessageToMessageEncoder;", "", "charset", "Ljava/nio/charset/Charset;", "encoderRegistry", "Lcom/github/jasync/sql/db/column/ColumnEncoderRegistry;", "(Ljava/nio/charset/Charset;Lcom/github/jasync/sql/db/column/ColumnEncoderRegistry;)V", "closeStatementOrPortalEncoder", "Lcom/github/jasync/sql/db/postgresql/encoders/CloseStatementEncoder;", "executeEncoder", "Lcom/github/jasync/sql/db/postgresql/encoders/ExecutePreparedStatementEncoder;", "openEncoder", "Lcom/github/jasync/sql/db/postgresql/encoders/PreparedStatementOpeningEncoder;", "passwordEncoder", "Lcom/github/jasync/sql/db/postgresql/encoders/PasswordEncoder;", "queryEncoder", "Lcom/github/jasync/sql/db/postgresql/encoders/QueryMessageEncoder;", "startupEncoder", "Lcom/github/jasync/sql/db/postgresql/encoders/StartupMessageEncoder;", "encode", "", "ctx", "Lio/netty/channel/ChannelHandlerContext;", "msg", "out", "", "jasync-postgresql"})
public final class MessageEncoder
extends MessageToMessageEncoder<Object> {
    @NotNull
    private final ExecutePreparedStatementEncoder executeEncoder;
    @NotNull
    private final PreparedStatementOpeningEncoder openEncoder;
    @NotNull
    private final StartupMessageEncoder startupEncoder;
    @NotNull
    private final QueryMessageEncoder queryEncoder;
    @NotNull
    private final PasswordEncoder passwordEncoder;
    @NotNull
    private final CloseStatementEncoder closeStatementOrPortalEncoder;

    public MessageEncoder(@NotNull Charset charset, @NotNull ColumnEncoderRegistry encoderRegistry) {
        Intrinsics.checkNotNullParameter((Object)charset, (String)"charset");
        Intrinsics.checkNotNullParameter((Object)encoderRegistry, (String)"encoderRegistry");
        this.executeEncoder = new ExecutePreparedStatementEncoder(charset, encoderRegistry);
        this.openEncoder = new PreparedStatementOpeningEncoder(charset, encoderRegistry);
        this.startupEncoder = new StartupMessageEncoder(charset);
        this.queryEncoder = new QueryMessageEncoder(charset);
        this.passwordEncoder = new PasswordEncoder(charset);
        this.closeStatementOrPortalEncoder = new CloseStatementEncoder(charset);
    }

    protected void encode(@NotNull ChannelHandlerContext ctx, @NotNull Object msg, @NotNull List<Object> out) {
        ByteBuf byteBuf;
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
        Intrinsics.checkNotNullParameter(out, (String)"out");
        Object object = msg;
        if (object instanceof SSLRequestMessage) {
            byteBuf = SSLMessageEncoder.INSTANCE.encode();
        } else if (object instanceof StartupMessage) {
            byteBuf = this.startupEncoder.encode((StartupMessage)msg);
        } else if (object instanceof ClientMessage) {
            Encoder encoder;
            switch (((ClientMessage)msg).getKind()) {
                case 88: {
                    encoder = CloseMessageEncoder.INSTANCE;
                    break;
                }
                case 69: {
                    encoder = this.executeEncoder;
                    break;
                }
                case 80: {
                    encoder = this.openEncoder;
                    break;
                }
                case 81: {
                    encoder = this.queryEncoder;
                    break;
                }
                case 112: {
                    encoder = this.passwordEncoder;
                    break;
                }
                case 67: {
                    encoder = this.closeStatementOrPortalEncoder;
                    break;
                }
                default: {
                    throw new EncoderNotAvailableException((KindedMessage)msg);
                }
            }
            Encoder encoder2 = encoder;
            byteBuf = encoder2.encode((ClientMessage)msg);
        } else {
            String string = "Can not encode message %s";
            Object[] objectArray = new Object[]{msg};
            String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(this, *args)");
            throw new IllegalArgumentException(string2);
        }
        ByteBuf buffer = byteBuf;
        MessageEncoderKt.access$getLogger$p().trace((Function0)new Function0<Object>(msg, buffer){
            final /* synthetic */ Object $msg;
            final /* synthetic */ ByteBuf $buffer;
            {
                this.$msg = $msg;
                this.$buffer = $buffer;
                super(0);
            }

            @Nullable
            public final Object invoke() {
                return "Sending message " + this.$msg.getClass().getSimpleName() + '\n' + BufferDumper.dumpAsHex((ByteBuf)this.$buffer);
            }
        });
        out.add(buffer);
    }
}

