/*
 * Decompiled with CFR 0.152.
 */
package com.github.joschi.dropwizard.java8.jersey;

import com.sun.jersey.api.ParamException;
import com.sun.jersey.api.core.HttpContext;
import com.sun.jersey.api.model.Parameter;
import com.sun.jersey.core.spi.component.ComponentContext;
import com.sun.jersey.core.spi.component.ComponentScope;
import com.sun.jersey.core.spi.component.ProviderServices;
import com.sun.jersey.server.impl.inject.AbstractHttpContextInjectable;
import com.sun.jersey.server.impl.model.parameter.multivalued.ExtractorContainerException;
import com.sun.jersey.server.impl.model.parameter.multivalued.MultivaluedParameterExtractor;
import com.sun.jersey.server.impl.model.parameter.multivalued.MultivaluedParameterExtractorFactory;
import com.sun.jersey.server.impl.model.parameter.multivalued.StringReaderFactory;
import com.sun.jersey.spi.StringReaderWorkers;
import com.sun.jersey.spi.inject.Injectable;
import com.sun.jersey.spi.inject.InjectableProvider;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Optional;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.Provider;

@Provider
public class OptionalQueryParamInjectableProvider
implements InjectableProvider<QueryParam, Parameter> {
    private final ProviderServices services;
    private MultivaluedParameterExtractorFactory factory;

    public OptionalQueryParamInjectableProvider(@Context ProviderServices services) {
        this.services = services;
    }

    public ComponentScope getScope() {
        return ComponentScope.PerRequest;
    }

    public Injectable<?> getInjectable(ComponentContext ic, QueryParam a, Parameter c) {
        if (this.isExtractable(c)) {
            OptionalExtractor extractor = new OptionalExtractor(this.getFactory().get(this.unpack(c)));
            return new QueryParamInjectable(extractor, !c.isEncoded());
        }
        return null;
    }

    private boolean isExtractable(Parameter param) {
        return param.getSourceName() != null && !param.getSourceName().isEmpty() && param.getParameterClass().isAssignableFrom(Optional.class) && param.getParameterType() instanceof ParameterizedType;
    }

    private Parameter unpack(Parameter param) {
        Type typeParameter = ((ParameterizedType)param.getParameterType()).getActualTypeArguments()[0];
        return new Parameter(param.getAnnotations(), param.getAnnotation(), param.getSource(), param.getSourceName(), typeParameter, (Class)typeParameter, param.isEncoded(), param.getDefaultValue());
    }

    private MultivaluedParameterExtractorFactory getFactory() {
        if (this.factory == null) {
            StringReaderFactory stringReaderFactory = new StringReaderFactory();
            stringReaderFactory.init(this.services);
            this.factory = new MultivaluedParameterExtractorFactory((StringReaderWorkers)stringReaderFactory);
        }
        return this.factory;
    }

    private static class OptionalExtractor
    implements MultivaluedParameterExtractor {
        private final MultivaluedParameterExtractor extractor;

        private OptionalExtractor(MultivaluedParameterExtractor extractor) {
            this.extractor = extractor;
        }

        public String getName() {
            return this.extractor.getName();
        }

        public String getDefaultStringValue() {
            return this.extractor.getDefaultStringValue();
        }

        public Object extract(MultivaluedMap<String, String> parameters) {
            return Optional.ofNullable(this.extractor.extract(parameters));
        }
    }

    private static class QueryParamInjectable
    extends AbstractHttpContextInjectable<Object> {
        private final MultivaluedParameterExtractor extractor;
        private final boolean decode;

        private QueryParamInjectable(MultivaluedParameterExtractor extractor, boolean decode) {
            this.extractor = extractor;
            this.decode = decode;
        }

        public Object getValue(HttpContext c) {
            try {
                return this.extractor.extract(c.getUriInfo().getQueryParameters(this.decode));
            }
            catch (ExtractorContainerException e) {
                throw new ParamException.QueryParamException(e.getCause(), this.extractor.getName(), this.extractor.getDefaultStringValue());
            }
        }
    }
}

