/*
 * Decompiled with CFR 0.152.
 */
package com.github.jsonldjava.clerezza;

import com.github.jsonldjava.core.JsonLdTripleCallback;
import com.github.jsonldjava.core.RDFDataset;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.clerezza.commons.rdf.BlankNode;
import org.apache.clerezza.commons.rdf.BlankNodeOrIRI;
import org.apache.clerezza.commons.rdf.Graph;
import org.apache.clerezza.commons.rdf.IRI;
import org.apache.clerezza.commons.rdf.Language;
import org.apache.clerezza.commons.rdf.RDFTerm;
import org.apache.clerezza.commons.rdf.impl.utils.PlainLiteralImpl;
import org.apache.clerezza.commons.rdf.impl.utils.TripleImpl;
import org.apache.clerezza.commons.rdf.impl.utils.TypedLiteralImpl;
import org.apache.clerezza.commons.rdf.impl.utils.simple.SimpleGraph;

public class ClerezzaTripleCallback
implements JsonLdTripleCallback {
    private static final String RDF_LANG_STRING = "http://www.w3.org/1999/02/22-rdf-syntax-ns#langString";
    private Graph mGraph = new SimpleGraph();
    private Map<String, BlankNode> bNodeMap = new HashMap<String, BlankNode>();

    public void setMGraph(Graph graph) {
        this.mGraph = graph;
        this.bNodeMap = new HashMap<String, BlankNode>();
    }

    public Graph getMGraph() {
        return this.mGraph;
    }

    private void triple(String s, String p, String o, String graph) {
        if (s == null || p == null || o == null) {
            return;
        }
        BlankNodeOrIRI subject = this.getNonLiteral(s);
        IRI predicate = new IRI(p);
        BlankNodeOrIRI object = this.getNonLiteral(o);
        this.mGraph.add((Object)new TripleImpl(subject, predicate, (RDFTerm)object));
    }

    private void triple(String s, String p, String value, String datatype, String language, String graph) {
        BlankNodeOrIRI subject = this.getNonLiteral(s);
        IRI predicate = new IRI(p);
        Object object = language != null ? new PlainLiteralImpl(value, new Language(language)) : (datatype == null || RDF_LANG_STRING.equals(datatype) ? new PlainLiteralImpl(value) : new TypedLiteralImpl(value, new IRI(datatype)));
        this.mGraph.add((Object)new TripleImpl(subject, predicate, (RDFTerm)object));
    }

    private BlankNodeOrIRI getNonLiteral(String s) {
        if (s.startsWith("_:")) {
            return this.getBNode(s);
        }
        return new IRI(s);
    }

    private BlankNode getBNode(String s) {
        if (this.bNodeMap.containsKey(s)) {
            return this.bNodeMap.get(s);
        }
        BlankNode result = new BlankNode();
        this.bNodeMap.put(s, result);
        return result;
    }

    public Object call(RDFDataset dataset) {
        for (String graphName : dataset.graphNames()) {
            List quads = dataset.getQuads(graphName);
            if ("@default".equals(graphName)) {
                graphName = null;
            }
            for (RDFDataset.Quad quad : quads) {
                if (quad.getObject().isLiteral()) {
                    this.triple(quad.getSubject().getValue(), quad.getPredicate().getValue(), quad.getObject().getValue(), quad.getObject().getDatatype(), quad.getObject().getLanguage(), graphName);
                    continue;
                }
                this.triple(quad.getSubject().getValue(), quad.getPredicate().getValue(), quad.getObject().getValue(), graphName);
            }
        }
        return this.getMGraph();
    }
}

