/*
 * Decompiled with CFR 0.152.
 */
package com.github.jsonldjava.clerezza;

import com.github.jsonldjava.clerezza.ClerezzaTripleCallback;
import com.github.jsonldjava.core.JsonLdError;
import com.github.jsonldjava.core.JsonLdProcessor;
import com.github.jsonldjava.core.JsonLdTripleCallback;
import com.github.jsonldjava.utils.JsonUtils;
import java.io.IOException;
import java.io.InputStream;
import org.apache.clerezza.rdf.core.MGraph;
import org.apache.clerezza.rdf.core.Triple;
import org.junit.Assert;
import org.junit.Test;

public class ClerezzaTripleCallbackTest {
    @Test
    public void triplesTest() throws IOException, JsonLdError {
        InputStream in = this.getClass().getClassLoader().getResourceAsStream("testfiles/product.jsonld");
        Object input = JsonUtils.fromInputStream((InputStream)in);
        ClerezzaTripleCallback callback = new ClerezzaTripleCallback();
        MGraph graph = (MGraph)JsonLdProcessor.toRDF((Object)input, (JsonLdTripleCallback)callback);
        for (Triple t : graph) {
            System.out.println(t);
        }
        Assert.assertEquals((String)"Graph size", (long)13L, (long)graph.size());
    }

    @Test
    public void curiesInContextTest() throws IOException, JsonLdError {
        InputStream in = this.getClass().getClassLoader().getResourceAsStream("testfiles/curies-in-context.jsonld");
        Object input = JsonUtils.fromInputStream((InputStream)in);
        ClerezzaTripleCallback callback = new ClerezzaTripleCallback();
        MGraph graph = (MGraph)JsonLdProcessor.toRDF((Object)input, (JsonLdTripleCallback)callback);
        for (Triple t : graph) {
            System.out.println(t);
            Assert.assertTrue((String)"Predicate got fully expanded", (boolean)t.getPredicate().getUnicodeString().startsWith("http"));
        }
        Assert.assertEquals((String)"Graph size", (long)3L, (long)graph.size());
    }
}

