/*
 * Decompiled with CFR 0.152.
 */
package com.github.jsonldjava.impl;

import com.github.jsonldjava.core.JSONLD;
import com.github.jsonldjava.core.JSONLDProcessingError;
import com.github.jsonldjava.core.RDFParser;
import com.github.jsonldjava.impl.JenaRDFParser;
import com.github.jsonldjava.utils.JSONUtils;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JenaRDFParserTest {
    private static Logger logger = LoggerFactory.getLogger(JenaRDFParserTest.class);

    @Test
    public void test() throws JSONLDProcessingError {
        String turtle = "@prefix const: <http://foo.com/> .\n@prefix xsd: <http://www.w3.org/2001/XMLSchema#> .\n<http://localhost:8080/foo1> const:code \"123\" .\n<http://localhost:8080/foo2> const:code \"ABC\"^^xsd:string .\n";
        ArrayList<Map<String, Object>> expected = new ArrayList<Map<String, Object>>(){
            {
                this.add(new LinkedHashMap<String, Object>(){
                    {
                        this.put("@id", "http://localhost:8080/foo1");
                        this.put("http://foo.com/code", new ArrayList<Object>(){
                            {
                                this.add(new LinkedHashMap<String, Object>(){
                                    {
                                        this.put("@value", "123");
                                    }
                                });
                            }
                        });
                    }
                });
                this.add(new LinkedHashMap<String, Object>(){
                    {
                        this.put("@id", "http://localhost:8080/foo2");
                        this.put("http://foo.com/code", new ArrayList<Object>(){
                            {
                                this.add(new LinkedHashMap<String, Object>(){
                                    {
                                        this.put("@value", "ABC");
                                    }
                                });
                            }
                        });
                    }
                });
            }
        };
        Model modelResult = ModelFactory.createDefaultModel().read((InputStream)new ByteArrayInputStream(turtle.getBytes()), "", "TURTLE");
        JenaRDFParser parser = new JenaRDFParser();
        Object json = JSONLD.fromRDF((Object)modelResult, (RDFParser)parser);
        Assert.assertTrue((boolean)JSONUtils.equals((Object)json, (Object)expected));
    }
}

