/*
 * Decompiled with CFR 0.152.
 */
package com.github.jsonldjava.jena;

import com.github.jsonldjava.jena.JenaJSONLD;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.Resource;
import java.io.StringWriter;
import java.io.Writer;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class JenaJSONWriterTest {
    @BeforeClass
    public static void init() {
        JenaJSONLD.init();
    }

    @Test
    public void write() throws Exception {
        Model model = ModelFactory.createDefaultModel();
        Resource resource = model.createResource("http://example.com/test");
        Property property = model.createProperty("http://example.com/value");
        model.add(resource, property, "Test");
        StringWriter writer = new StringWriter();
        model.write((Writer)writer, "JSON-LD");
        String json = writer.toString();
        Assert.assertTrue((boolean)json.contains("@id"));
        Assert.assertTrue((boolean)json.contains("http://example.com/test"));
        Assert.assertTrue((boolean)json.contains("http://example.com/value"));
        Assert.assertTrue((boolean)json.contains("Test"));
    }

    @Test
    public void writeWithBase() throws Exception {
        Model model = ModelFactory.createDefaultModel();
        Resource resource = model.createResource("http://example.com/test");
        Property property = model.createProperty("http://example.com/value");
        model.add(resource, property, "Test");
        StringWriter writer = new StringWriter();
        model.write((Writer)writer, "JSON-LD", "http://example.com/");
        String json = writer.toString();
        Assert.assertTrue((boolean)json.contains("@id"));
        Assert.assertFalse((boolean)json.contains("http://example.com/test"));
        Assert.assertTrue((boolean)json.contains("\"test\""));
        Assert.assertTrue((boolean)json.contains("Test"));
    }
}

