/*
 * Decompiled with CFR 0.152.
 */
package com.github.jsonldjava.jena;

import com.github.jsonldjava.core.JSONLDTripleCallback;
import com.github.jsonldjava.core.RDFDataset;
import com.hp.hpl.jena.rdf.model.AnonId;
import com.hp.hpl.jena.rdf.model.Literal;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.shared.InvalidPropertyURIException;
import java.util.List;

public class JenaTripleCallback
implements JSONLDTripleCallback {
    private Model jenaModel = ModelFactory.createDefaultModel();

    public void setJenaModel(Model jenaModel) {
        this.jenaModel = jenaModel;
    }

    public Model getJenaModel() {
        return this.jenaModel;
    }

    private void triple(RDFDataset.Node subjectNode, RDFDataset.Node propertyNode, RDFDataset.Node objectNode, String graph) {
        if (subjectNode == null || propertyNode == null || objectNode == null) {
            return;
        }
        Resource subject = this.createResourceFromNode(subjectNode);
        if (!propertyNode.isIRI()) {
            throw new InvalidPropertyURIException(propertyNode.getValue());
        }
        Property property = this.jenaModel.createProperty(propertyNode.getValue());
        Resource object = this.createResourceFromNode(objectNode);
        Statement statement = this.jenaModel.createStatement(subject, property, (RDFNode)object);
        this.jenaModel.add(statement);
    }

    private void triple(RDFDataset.Node subjectNode, RDFDataset.Node propertyNode, String value, String datatype, String language, String graph) {
        Resource subject = this.createResourceFromNode(subjectNode);
        if (!propertyNode.isIRI()) {
            throw new InvalidPropertyURIException(propertyNode.getValue());
        }
        Property property = this.jenaModel.createProperty(propertyNode.getValue());
        Literal object = language != null ? this.jenaModel.createLiteral(value, language) : this.jenaModel.createTypedLiteral(value, datatype);
        Statement statement = this.jenaModel.createStatement(subject, property, (RDFNode)object);
        this.jenaModel.add(statement);
    }

    private Resource createResourceFromNode(RDFDataset.Node node) {
        Resource sR;
        if (node.isIRI()) {
            sR = this.jenaModel.createResource(node.getValue());
        } else {
            String name = node.getValue();
            if (name.startsWith("_:")) {
                name = node.getValue().substring(2, node.getValue().length());
            }
            sR = this.jenaModel.createResource(new AnonId(name));
        }
        return sR;
    }

    public Object call(RDFDataset dataset) {
        for (String graphName : dataset.graphNames()) {
            List quads = dataset.getQuads(graphName);
            if ("@default".equals(graphName)) {
                graphName = null;
            }
            for (RDFDataset.Quad quad : quads) {
                if (quad.getObject().isLiteral()) {
                    this.triple(quad.getSubject(), quad.getPredicate(), quad.getObject().getValue(), quad.getObject().getDatatype(), quad.getObject().getLanguage(), graphName);
                    continue;
                }
                this.triple(quad.getSubject(), quad.getPredicate(), quad.getObject(), graphName);
            }
        }
        return this.getJenaModel();
    }
}

