/*
 * Decompiled with CFR 0.152.
 */
package com.github.jsonldjava.jena;

import com.github.jsonldjava.jena.JenaJSONLD;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.RDFDataMgr;
import org.apache.jena.riot.RDFFormat;
import org.apache.jena.riot.RDFLanguages;
import org.apache.jena.riot.RDFParserRegistry;
import org.apache.jena.riot.RDFWriterRegistry;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class JenaSystemTest
extends Assert {
    private static RDFFormat jsonldFmt1 = new RDFFormat(JenaJSONLD.JSONLD, RDFFormat.PRETTY);
    private static RDFFormat jsonldFmt2 = new RDFFormat(JenaJSONLD.JSONLD, RDFFormat.FLAT);

    @BeforeClass
    public static void init() {
        JenaJSONLD.init();
    }

    @Test
    public void jenaSystem_basic_1() {
        JenaSystemTest.assertEquals((String)"name", (Object)"JSON-LD", (Object)JenaJSONLD.JSONLD.getName());
        JenaSystemTest.assertEquals((String)"content-type", (Object)"application/ld+json", (Object)JenaJSONLD.JSONLD.getContentType().getContentType());
    }

    @Test
    public void jenaSystem_read_1() {
        JenaSystemTest.assertTrue((boolean)RDFLanguages.isRegistered((Lang)JenaJSONLD.JSONLD));
        JenaSystemTest.assertTrue((boolean)RDFLanguages.isTriples((Lang)JenaJSONLD.JSONLD));
        JenaSystemTest.assertTrue((boolean)RDFLanguages.isQuads((Lang)JenaJSONLD.JSONLD));
    }

    @Test
    public void jenaSystem_read_2() {
        JenaSystemTest.assertNotNull((Object)RDFParserRegistry.getFactory((Lang)JenaJSONLD.JSONLD));
    }

    @Test
    public void jenaSystem_write_1() {
        JenaSystemTest.assertTrue((boolean)RDFWriterRegistry.contains((Lang)JenaJSONLD.JSONLD));
    }

    @Test
    public void jenaSystem_write_2() {
        JenaSystemTest.assertNotNull((Object)RDFWriterRegistry.getWriterGraphFactory((Lang)JenaJSONLD.JSONLD));
        JenaSystemTest.assertNotNull((Object)RDFWriterRegistry.getWriterDatasetFactory((Lang)JenaJSONLD.JSONLD));
        JenaSystemTest.assertNotNull((Object)RDFWriterRegistry.defaultSerialization((Lang)JenaJSONLD.JSONLD));
    }

    @Test
    public void jenaSystem_write_3() {
        JenaSystemTest.assertEquals((Object)jsonldFmt1, (Object)RDFWriterRegistry.defaultSerialization((Lang)JenaJSONLD.JSONLD));
        JenaSystemTest.assertNotNull((Object)RDFWriterRegistry.getWriterGraphFactory((RDFFormat)jsonldFmt1));
        JenaSystemTest.assertNotNull((Object)RDFWriterRegistry.getWriterGraphFactory((RDFFormat)jsonldFmt2));
        JenaSystemTest.assertTrue((boolean)RDFWriterRegistry.registeredGraphFormats().contains(jsonldFmt1));
        JenaSystemTest.assertTrue((boolean)RDFWriterRegistry.registeredGraphFormats().contains(jsonldFmt2));
        JenaSystemTest.assertNotNull((Object)RDFWriterRegistry.getWriterDatasetFactory((RDFFormat)jsonldFmt1));
        JenaSystemTest.assertNotNull((Object)RDFWriterRegistry.getWriterDatasetFactory((RDFFormat)jsonldFmt2));
        JenaSystemTest.assertTrue((boolean)RDFWriterRegistry.registeredDatasetFormats().contains(jsonldFmt1));
        JenaSystemTest.assertTrue((boolean)RDFWriterRegistry.registeredDatasetFormats().contains(jsonldFmt2));
    }

    @Test
    public void jenaSystem_write_4() {
        JenaSystemTest.assertNotNull((Object)RDFDataMgr.createGraphWriter((RDFFormat)jsonldFmt1));
        JenaSystemTest.assertNotNull((Object)RDFDataMgr.createGraphWriter((RDFFormat)jsonldFmt2));
        JenaSystemTest.assertNotNull((Object)RDFDataMgr.createDatasetWriter((RDFFormat)jsonldFmt1));
        JenaSystemTest.assertNotNull((Object)RDFDataMgr.createDatasetWriter((RDFFormat)jsonldFmt2));
    }
}

