/*
 * Decompiled with CFR 0.152.
 */
package com.github.jsonldjava.impl;

import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.github.jsonldjava.core.JSONLD;
import com.github.jsonldjava.core.JSONLDProcessingError;
import com.github.jsonldjava.core.Options;
import com.github.jsonldjava.core.RDFParser;
import com.github.jsonldjava.impl.SesameRDFParser;
import com.github.jsonldjava.utils.JSONUtils;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.Map;
import org.openrdf.model.Model;
import org.openrdf.model.Statement;
import org.openrdf.model.impl.LinkedHashModel;
import org.openrdf.rio.RDFFormat;
import org.openrdf.rio.RDFHandlerException;
import org.openrdf.rio.RDFWriter;
import org.openrdf.rio.helpers.BasicParserSettings;
import org.openrdf.rio.helpers.BasicWriterSettings;
import org.openrdf.rio.helpers.JSONLDMode;
import org.openrdf.rio.helpers.JSONLDSettings;
import org.openrdf.rio.helpers.RDFWriterBase;
import org.openrdf.rio.helpers.StatementCollector;

public class SesameJSONLDWriter
extends RDFWriterBase
implements RDFWriter {
    private final Model model = new LinkedHashModel();
    private final StatementCollector statementCollector = new StatementCollector((Collection)this.model);
    private final Writer writer;

    public SesameJSONLDWriter(OutputStream outputStream) {
        this(new BufferedWriter(new OutputStreamWriter(outputStream, Charset.forName("UTF-8"))));
    }

    public SesameJSONLDWriter(Writer nextWriter) {
        this.writer = nextWriter;
    }

    public void handleNamespace(String prefix, String uri) throws RDFHandlerException {
        this.model.setNamespace(prefix, uri);
    }

    public void startRDF() throws RDFHandlerException {
        this.statementCollector.clear();
        this.model.clear();
    }

    public void endRDF() throws RDFHandlerException {
        SesameRDFParser serialiser = new SesameRDFParser();
        try {
            Object output = JSONLD.fromRDF((Object)this.model, (RDFParser)serialiser);
            JSONLDMode mode = (JSONLDMode)this.getWriterConfig().get(JSONLDSettings.JSONLD_MODE);
            Options opts = new Options();
            opts.addBlankNodeIDs = (Boolean)this.getWriterConfig().get(BasicParserSettings.PRESERVE_BNODE_IDS);
            opts.useRdfType = (Boolean)this.getWriterConfig().get(JSONLDSettings.USE_RDF_TYPE);
            opts.useNativeTypes = (Boolean)this.getWriterConfig().get(JSONLDSettings.USE_NATIVE_TYPES);
            if (mode == JSONLDMode.EXPAND) {
                output = JSONLD.expand((Object)output, (Options)opts);
            }
            Object inframe = null;
            if (mode == JSONLDMode.FLATTEN) {
                output = JSONLD.frame((Object)output, (Map)inframe, (Options)opts);
            }
            if (mode == JSONLDMode.COMPACT) {
                output = JSONLD.simplify((Object)output, (Options)opts);
            }
            if (((Boolean)this.getWriterConfig().get(BasicWriterSettings.PRETTY_PRINT)).booleanValue()) {
                JSONUtils.writePrettyPrint((Writer)this.writer, (Object)output);
            } else {
                JSONUtils.write((Writer)this.writer, (Object)output);
            }
        }
        catch (JSONLDProcessingError e) {
            throw new RDFHandlerException("Could not render JSONLD", (Throwable)e);
        }
        catch (JsonGenerationException e) {
            throw new RDFHandlerException("Could not render JSONLD", (Throwable)e);
        }
        catch (JsonMappingException e) {
            throw new RDFHandlerException("Could not render JSONLD", (Throwable)e);
        }
        catch (IOException e) {
            throw new RDFHandlerException("Could not render JSONLD", (Throwable)e);
        }
    }

    public void handleStatement(Statement st) throws RDFHandlerException {
        this.statementCollector.handleStatement(st);
    }

    public void handleComment(String comment) throws RDFHandlerException {
    }

    public RDFFormat getRDFFormat() {
        return RDFFormat.JSONLD;
    }
}

