/*
 * Decompiled with CFR 0.152.
 */
package com.github.jsonldjava.tools;

import com.github.jsonldjava.core.JsonLdOptions;
import com.github.jsonldjava.core.JsonLdProcessor;
import com.github.jsonldjava.core.JsonLdTripleCallback;
import com.github.jsonldjava.core.RDFParser;
import com.github.jsonldjava.tools.SesameJSONLDRDFParser;
import com.github.jsonldjava.tools.SesameJSONLDTripleCallback;
import com.github.jsonldjava.utils.JsonUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import joptsimple.AbstractOptionSpec;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.OptionException;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import joptsimple.ValueConversionException;
import joptsimple.ValueConverter;
import org.openrdf.model.Model;
import org.openrdf.model.Resource;
import org.openrdf.rio.RDFFormat;
import org.openrdf.rio.RDFHandler;
import org.openrdf.rio.RDFParserRegistry;
import org.openrdf.rio.Rio;

public class Playground {
    private static Set<String> getProcessingOptions() {
        return new LinkedHashSet<String>(Arrays.asList("expand", "compact", "frame", "normalize", "flatten", "fromrdf", "tordf"));
    }

    private static boolean hasContext(String opt) {
        return "compact".equals(opt) || "frame".equals(opt) || "flatten".equals(opt);
    }

    private static Map<String, RDFFormat> getOutputFormats() {
        HashMap<String, RDFFormat> outputFormats = new HashMap<String, RDFFormat>();
        for (RDFFormat format : RDFParserRegistry.getInstance().getKeys()) {
            outputFormats.put(format.getName().replaceAll("-", "").replaceAll("/", "").toLowerCase(), format);
        }
        return outputFormats;
    }

    public static void main(String[] args) throws Exception {
        final Map<String, RDFFormat> formats = Playground.getOutputFormats();
        final LinkedHashSet<String> outputForms = new LinkedHashSet<String>(Arrays.asList("compacted", "expanded", "flattened"));
        OptionParser parser = new OptionParser();
        AbstractOptionSpec help = parser.accepts("help").forHelp();
        ArgumentAcceptingOptionSpec base = parser.accepts("base").withRequiredArg().ofType(String.class).defaultsTo((Object)"", (Object[])new String[0]).describedAs("base URI");
        ArgumentAcceptingOptionSpec inputFile = parser.accepts("inputFile").withRequiredArg().ofType(File.class).required().describedAs("The input file");
        ArgumentAcceptingOptionSpec context = parser.accepts("context").withRequiredArg().ofType(File.class).describedAs("The context");
        ArgumentAcceptingOptionSpec outputFormat = parser.accepts("format").withOptionalArg().ofType(String.class).withValuesConvertedBy((ValueConverter)new ValueConverter<RDFFormat>(){

            public RDFFormat convert(String arg0) {
                String formatName = arg0.replaceAll("-", "").replaceAll("/", "").toLowerCase();
                if (formats.containsKey(formatName)) {
                    return (RDFFormat)formats.get(formatName);
                }
                throw new ValueConversionException("Format was not known: " + arg0 + " (Valid values are: " + formats.keySet() + ")");
            }

            public String valuePattern() {
                return null;
            }

            public Class<RDFFormat> valueType() {
                return RDFFormat.class;
            }
        }).defaultsTo((Object)RDFFormat.NQUADS, (Object[])new RDFFormat[0]).describedAs("The output file format to use. Defaults to nquads. Valid values are: " + formats.keySet());
        ArgumentAcceptingOptionSpec processingOption = parser.accepts("process").withRequiredArg().ofType(String.class).required().withValuesConvertedBy((ValueConverter)new ValueConverter<String>(){

            public String convert(String value) {
                if (Playground.getProcessingOptions().contains(value.toLowerCase())) {
                    return value.toLowerCase();
                }
                throw new ValueConversionException("Processing option was not known: " + value + " (Valid values are: " + Playground.getProcessingOptions() + ")");
            }

            public Class<String> valueType() {
                return String.class;
            }

            public String valuePattern() {
                return null;
            }
        }).describedAs("The processing to perform. Valid values are: " + Playground.getProcessingOptions().toString());
        ArgumentAcceptingOptionSpec outputForm = parser.accepts("outputForm").withOptionalArg().ofType(String.class).defaultsTo((Object)"expanded", (Object[])new String[0]).withValuesConvertedBy((ValueConverter)new ValueConverter<String>(){

            public String convert(String value) {
                if (outputForms.contains(value.toLowerCase())) {
                    return value.toLowerCase();
                }
                throw new ValueConversionException("Output form was not known: " + value + " (Valid values are: " + outputForms + ")");
            }

            public String valuePattern() {
                return null;
            }

            public Class<String> valueType() {
                return String.class;
            }
        }).describedAs("The way to output the results from fromRDF. Defaults to expanded. Valid values are: " + outputForms);
        OptionSet options = null;
        try {
            options = parser.parse(args);
        }
        catch (OptionException e) {
            System.out.println(e.getMessage());
            parser.printHelpOn((OutputStream)System.out);
            throw e;
        }
        if (options.has((OptionSpec)help)) {
            parser.printHelpOn((OutputStream)System.out);
            return;
        }
        JsonLdOptions opts = new JsonLdOptions("");
        Object inobj = null;
        Object ctxobj = null;
        opts.setBase((String)options.valueOf((OptionSpec)base));
        opts.outputForm = (String)options.valueOf((OptionSpec)outputForm);
        opts.format = options.has((OptionSpec)outputFormat) ? ((RDFFormat)options.valueOf((OptionSpec)outputFormat)).getDefaultMIMEType() : "application/nquads";
        RDFFormat sesameOutputFormat = (RDFFormat)options.valueOf((OptionSpec)outputFormat);
        RDFFormat sesameInputFormat = Rio.getParserFormatForFileName((String)((File)options.valueOf((OptionSpec)inputFile)).getName(), (RDFFormat)RDFFormat.JSONLD);
        String processingOptionValue = (String)options.valueOf((OptionSpec)processingOption);
        if (!((File)options.valueOf((OptionSpec)inputFile)).exists()) {
            System.out.println("Error: input file \"" + options.valueOf((OptionSpec)inputFile) + "\" doesn't exist");
            parser.printHelpOn((OutputStream)System.out);
            return;
        }
        if (opts.getBase() == null || opts.getBase().equals("")) {
            opts.setBase(((File)options.valueOf((OptionSpec)inputFile)).toURI().toASCIIString());
        }
        inobj = "fromrdf".equals(processingOptionValue) ? Playground.readFile((File)options.valueOf((OptionSpec)inputFile)) : JsonUtils.fromInputStream((InputStream)new FileInputStream((File)options.valueOf((OptionSpec)inputFile)));
        if (Playground.hasContext(processingOptionValue) && options.has((OptionSpec)context)) {
            if (!((File)options.valueOf((OptionSpec)context)).exists()) {
                System.out.println("Error: context file \"" + options.valueOf((OptionSpec)context) + "\" doesn't exist");
                parser.printHelpOn((OutputStream)System.out);
                return;
            }
            ctxobj = JsonUtils.fromInputStream((InputStream)new FileInputStream((File)options.valueOf((OptionSpec)context)));
        }
        Object outobj = null;
        if ("fromrdf".equals(processingOptionValue)) {
            Model inModel = Rio.parse((Reader)new StringReader((String)inobj), (String)opts.getBase(), (RDFFormat)sesameInputFormat, (Resource[])new Resource[0]);
            outobj = JsonLdProcessor.fromRDF((Object)inModel, (JsonLdOptions)opts, (RDFParser)new SesameJSONLDRDFParser());
        } else if ("tordf".equals(processingOptionValue)) {
            opts.useNamespaces = true;
            outobj = JsonLdProcessor.toRDF((Object)inobj, (JsonLdTripleCallback)new SesameJSONLDTripleCallback((RDFHandler)Rio.createWriter((RDFFormat)sesameOutputFormat, (OutputStream)System.out)), (JsonLdOptions)opts);
        } else if ("expand".equals(processingOptionValue)) {
            outobj = JsonLdProcessor.expand((Object)inobj, (JsonLdOptions)opts);
        } else if ("compact".equals(processingOptionValue)) {
            if (ctxobj == null) {
                System.out.println("Error: The compaction context must not be null.");
                parser.printHelpOn((OutputStream)System.out);
                return;
            }
            outobj = JsonLdProcessor.compact((Object)inobj, (Object)ctxobj, (JsonLdOptions)opts);
        } else if ("normalize".equals(processingOptionValue)) {
            outobj = JsonLdProcessor.normalize((Object)inobj, (JsonLdOptions)opts);
        } else if ("frame".equals(processingOptionValue)) {
            if (ctxobj != null && !(ctxobj instanceof Map)) {
                System.out.println("Invalid JSON-LD syntax; a JSON-LD frame must be a single object.");
                parser.printHelpOn((OutputStream)System.out);
                return;
            }
            outobj = JsonLdProcessor.frame((Object)inobj, (Object)ctxobj, (JsonLdOptions)opts);
        } else if ("flatten".equals(processingOptionValue)) {
            outobj = JsonLdProcessor.flatten((Object)inobj, (Object)ctxobj, (JsonLdOptions)opts);
        } else {
            System.out.println("Error: invalid processing option \"" + processingOptionValue + "\"");
            parser.printHelpOn((OutputStream)System.out);
            return;
        }
        if (!"tordf".equals(processingOptionValue)) {
            if ("normalize".equals(processingOptionValue)) {
                System.out.println((String)outobj);
            } else {
                System.out.println(JsonUtils.toPrettyString((Object)outobj));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String readFile(File in) throws IOException {
        String inobj = "";
        try (BufferedReader buf = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(in), "UTF-8"));){
            String line;
            while ((line = buf.readLine()) != null) {
                line = line.trim();
                inobj = inobj + line + "\n";
            }
        }
        return inobj;
    }
}

