/*
 * Decompiled with CFR 0.152.
 */
package com.github.marschall.jsonnodereader;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.json.JsonMapper;
import com.fasterxml.jackson.databind.node.JsonNodeType;
import com.github.marschall.jsonnodereader.JsonNodeJsonArray;
import com.github.marschall.jsonnodereader.JsonNodeJsonNumber;
import com.github.marschall.jsonnodereader.JsonNodeJsonObject;
import com.github.marschall.jsonnodereader.JsonNodeJsonString;
import jakarta.json.JsonArray;
import jakarta.json.JsonNumber;
import jakarta.json.JsonObject;
import jakarta.json.JsonString;
import jakarta.json.JsonValue;
import java.util.Map;

final class JsonNodeAdapter {
    static final ObjectMapper OBJECT_MAPPER = ((JsonMapper.Builder)JsonMapper.builder().enable(new DeserializationFeature[]{DeserializationFeature.USE_BIG_DECIMAL_FOR_FLOATS})).build();

    private JsonNodeAdapter() {
        throw new AssertionError((Object)"not instantiable");
    }

    static JsonValue adapt(JsonNode jsonNode) {
        return switch (jsonNode.getNodeType()) {
            case JsonNodeType.ARRAY -> new JsonNodeJsonArray(jsonNode);
            case JsonNodeType.BOOLEAN -> {
                if (jsonNode.booleanValue()) {
                    yield JsonValue.TRUE;
                }
                yield JsonValue.FALSE;
            }
            case JsonNodeType.NULL -> JsonValue.NULL;
            case JsonNodeType.NUMBER -> new JsonNodeJsonNumber(jsonNode);
            case JsonNodeType.OBJECT -> new JsonNodeJsonObject(jsonNode);
            case JsonNodeType.STRING -> new JsonNodeJsonString(jsonNode);
            default -> throw new IllegalArgumentException("Unexpected node type: " + String.valueOf(jsonNode.getNodeType()));
        };
    }

    static boolean valueEquals(JsonNode jsonNode, JsonValue jsonValue) {
        return switch (jsonValue.getValueType()) {
            case JsonValue.ValueType.ARRAY -> {
                if (jsonNode.isArray() && JsonNodeAdapter.arrayEquals(jsonNode, (JsonArray)jsonValue)) {
                    yield true;
                }
                yield false;
            }
            case JsonValue.ValueType.FALSE -> {
                if (jsonNode.isBoolean() && !jsonNode.booleanValue()) {
                    yield true;
                }
                yield false;
            }
            case JsonValue.ValueType.TRUE -> {
                if (jsonNode.isBoolean() && jsonNode.booleanValue()) {
                    yield true;
                }
                yield false;
            }
            case JsonValue.ValueType.NULL -> jsonNode.isNull();
            case JsonValue.ValueType.NUMBER -> {
                if (jsonNode.isNumber() && JsonNodeAdapter.numberEquals(jsonNode, (JsonNumber)jsonValue)) {
                    yield true;
                }
                yield false;
            }
            case JsonValue.ValueType.OBJECT -> {
                if (jsonNode.isObject() && JsonNodeAdapter.objectEquals(jsonNode, (JsonObject)jsonValue)) {
                    yield true;
                }
                yield false;
            }
            case JsonValue.ValueType.STRING -> {
                if (jsonNode.isTextual() && JsonNodeAdapter.textEquals(jsonNode, (JsonString)jsonValue)) {
                    yield true;
                }
                yield false;
            }
            default -> throw new IllegalArgumentException("Unexpected node type: " + String.valueOf(jsonNode.getNodeType()));
        };
    }

    static boolean textEquals(JsonNode jsonNode, JsonString jsonString) {
        return jsonNode.textValue().equals(jsonString.getString());
    }

    static boolean objectEquals(JsonNode jsonNode, JsonObject jsonObject) {
        if (jsonNode.size() != jsonObject.size()) {
            return false;
        }
        for (Map.Entry property : jsonNode.properties()) {
            JsonValue jsonValue = (JsonValue)jsonObject.get(property.getKey());
            if (jsonValue != null && JsonNodeAdapter.valueEquals((JsonNode)property.getValue(), jsonValue)) continue;
            return false;
        }
        return true;
    }

    static boolean numberEquals(JsonNode jsonNode, JsonNumber jsonNumber) {
        return jsonNode.decimalValue().equals(jsonNumber.bigDecimalValue());
    }

    static boolean arrayEquals(JsonNode jsonNode, JsonArray jsonArray) {
        if (jsonNode.size() != jsonArray.size()) {
            return false;
        }
        for (int i = 0; i < jsonNode.size(); ++i) {
            JsonValue value;
            JsonNode element = jsonNode.get(i);
            if (JsonNodeAdapter.valueEquals(element, value = (JsonValue)jsonArray.get(i))) continue;
            return false;
        }
        return true;
    }

    static int hashCode(JsonNode jsonNode) {
        return switch (jsonNode.getNodeType()) {
            case JsonNodeType.ARRAY -> JsonNodeAdapter.arrayHashCode(jsonNode);
            case JsonNodeType.BOOLEAN -> {
                if (jsonNode.booleanValue()) {
                    yield JsonValue.ValueType.TRUE.hashCode();
                }
                yield JsonValue.ValueType.FALSE.hashCode();
            }
            case JsonNodeType.NULL -> JsonValue.ValueType.NULL.hashCode();
            case JsonNodeType.NUMBER -> jsonNode.decimalValue().hashCode();
            case JsonNodeType.OBJECT -> JsonNodeAdapter.objectHashCode(jsonNode);
            case JsonNodeType.STRING -> jsonNode.hashCode();
            default -> throw new IllegalArgumentException("Unexpected node type: " + String.valueOf(jsonNode.getNodeType()));
        };
    }

    static int arrayHashCode(JsonNode jsonNode) {
        int hashCode = 1;
        for (int i = 0; i < jsonNode.size(); ++i) {
            JsonNode child = jsonNode.get(i);
            hashCode = 31 * hashCode + JsonNodeAdapter.hashCode(child);
        }
        return hashCode;
    }

    static int objectHashCode(JsonNode jsonNode) {
        int hashCode = 0;
        for (Map.Entry entry : jsonNode.properties()) {
            int entryHash = ((String)entry.getKey()).hashCode() ^ JsonNodeAdapter.hashCode((JsonNode)entry.getValue());
            hashCode += entryHash;
        }
        return hashCode;
    }
}

