/*
 * Decompiled with CFR 0.152.
 */
package com.github.marschall.jsonnodereader;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.JsonNodeType;
import com.github.marschall.jsonnodereader.JsonNodeAdapter;
import com.github.marschall.jsonnodereader.JsonNodeJsonNumber;
import com.github.marschall.jsonnodereader.JsonNodeJsonObject;
import com.github.marschall.jsonnodereader.JsonNodeJsonString;
import jakarta.json.JsonArray;
import jakarta.json.JsonNumber;
import jakarta.json.JsonObject;
import jakarta.json.JsonString;
import jakarta.json.JsonValue;
import java.lang.reflect.Array;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.RandomAccess;
import java.util.function.Consumer;
import java.util.function.Function;

final class JsonNodeJsonArray
implements JsonArray,
RandomAccess {
    private final JsonNode jsonNode;

    JsonNodeJsonArray(JsonNode jsonNode) {
        Objects.requireNonNull(jsonNode, "jsonNode");
        this.jsonNode = jsonNode;
    }

    public JsonValue.ValueType getValueType() {
        return JsonValue.ValueType.ARRAY;
    }

    public int size() {
        return this.jsonNode.size();
    }

    public boolean isEmpty() {
        return this.jsonNode.isEmpty();
    }

    public boolean contains(Object o) {
        Objects.requireNonNull(o);
        if (!(o instanceof JsonValue)) {
            return false;
        }
        JsonValue jsonValue = (JsonValue)o;
        for (int i = 0; i < this.size(); ++i) {
            if (!JsonNodeAdapter.valueEquals(this.jsonNode.get(i), jsonValue)) continue;
            return true;
        }
        return false;
    }

    public Iterator<JsonValue> iterator() {
        return new JsonValueIterator();
    }

    public Object[] toArray() {
        int size = this.jsonNode.size();
        Object[] array = new Object[size];
        for (int i = 0; i < size; ++i) {
            JsonNode value = this.jsonNode.get(i);
            JsonValue jsonValue = JsonNodeAdapter.adapt(value);
            array[i] = jsonValue;
        }
        return array;
    }

    public <T> T[] toArray(T[] a) {
        Object[] array;
        int size = this.jsonNode.size();
        if (a.length < size) {
            array = (Object[])Array.newInstance(a.getClass().getComponentType(), size);
        } else {
            array = a;
            if (a.length > size) {
                array[size] = null;
            }
        }
        for (int i = 0; i < size; ++i) {
            JsonNode value = this.jsonNode.get(i);
            JsonValue jsonValue = JsonNodeAdapter.adapt(value);
            array[i] = jsonValue;
        }
        return array;
    }

    public boolean add(JsonValue e) {
        throw new UnsupportedOperationException("add");
    }

    public boolean remove(Object o) {
        throw new UnsupportedOperationException("remove");
    }

    public boolean containsAll(Collection<?> c) {
        for (Object object : c) {
            if (this.contains(object)) continue;
            return false;
        }
        return true;
    }

    public boolean addAll(Collection<? extends JsonValue> c) {
        throw new UnsupportedOperationException("addAll");
    }

    public boolean addAll(int index, Collection<? extends JsonValue> c) {
        throw new UnsupportedOperationException("addAll");
    }

    public boolean removeAll(Collection<?> c) {
        throw new UnsupportedOperationException("removeAll");
    }

    public boolean retainAll(Collection<?> c) {
        throw new UnsupportedOperationException("retainAll");
    }

    public void clear() {
        throw new UnsupportedOperationException("clear");
    }

    public JsonValue get(int index) {
        JsonNode value = this.jsonNode.get(Objects.checkIndex(index, this.size()));
        return JsonNodeAdapter.adapt(value);
    }

    public JsonValue set(int index, JsonValue element) {
        throw new UnsupportedOperationException("set");
    }

    public void add(int index, JsonValue element) {
        throw new UnsupportedOperationException("add");
    }

    public JsonValue remove(int index) {
        throw new UnsupportedOperationException("remove");
    }

    public int indexOf(Object o) {
        if (!(o instanceof JsonValue)) {
            return -1;
        }
        JsonValue jsonValue = (JsonValue)o;
        for (int i = 0; i < this.size(); ++i) {
            if (!JsonNodeAdapter.valueEquals(this.jsonNode.get(i), jsonValue)) continue;
            return i;
        }
        return -1;
    }

    public int lastIndexOf(Object o) {
        if (!(o instanceof JsonValue)) {
            return -1;
        }
        JsonValue jsonValue = (JsonValue)o;
        for (int i = this.size() - 1; i >= 0; --i) {
            if (!JsonNodeAdapter.valueEquals(this.jsonNode.get(i), jsonValue)) continue;
            return i;
        }
        return -1;
    }

    public ListIterator<JsonValue> listIterator() {
        return new JsonValueIterator();
    }

    public ListIterator<JsonValue> listIterator(int index) {
        return new JsonValueIterator(Objects.checkIndex(index, this.size()));
    }

    public List<JsonValue> subList(int fromIndex, int toIndex) {
        Objects.checkFromToIndex(fromIndex, toIndex, this.size());
        return new SubList(fromIndex, toIndex);
    }

    public JsonObject getJsonObject(int index) {
        JsonNode value = this.jsonNode.get(Objects.checkIndex(index, this.size()));
        JsonNodeType nodeType = value.getNodeType();
        if (nodeType == JsonNodeType.OBJECT) {
            return new JsonNodeJsonObject(value);
        }
        throw new ClassCastException(String.valueOf(JsonNodeType.OBJECT) + " expected but got: " + String.valueOf(nodeType));
    }

    public JsonArray getJsonArray(int index) {
        JsonNode value = this.jsonNode.get(Objects.checkIndex(index, this.size()));
        JsonNodeType nodeType = value.getNodeType();
        if (nodeType == JsonNodeType.ARRAY) {
            return new JsonNodeJsonArray(value);
        }
        throw new ClassCastException(String.valueOf(JsonNodeType.ARRAY) + " expected but got: " + String.valueOf(nodeType));
    }

    public JsonNumber getJsonNumber(int index) {
        JsonNode value = this.jsonNode.get(Objects.checkIndex(index, this.size()));
        JsonNodeType nodeType = value.getNodeType();
        if (nodeType == JsonNodeType.NUMBER) {
            return new JsonNodeJsonNumber(value);
        }
        throw new ClassCastException(String.valueOf(JsonNodeType.NUMBER) + " expected but got: " + String.valueOf(nodeType));
    }

    public JsonString getJsonString(int index) {
        JsonNode value = this.jsonNode.get(Objects.checkIndex(index, this.size()));
        JsonNodeType nodeType = value.getNodeType();
        if (nodeType == JsonNodeType.STRING) {
            return new JsonNodeJsonString(value);
        }
        throw new ClassCastException(String.valueOf(JsonNodeType.STRING) + " expected but got: " + String.valueOf(nodeType));
    }

    public <T extends JsonValue> List<T> getValuesAs(Class<T> clazz) {
        int size = this.jsonNode.size();
        ArrayList<JsonValue> list = new ArrayList<JsonValue>(size);
        for (int i = 0; i < size; ++i) {
            JsonNode value = this.jsonNode.get(i);
            JsonValue jsonValue = JsonNodeAdapter.adapt(value);
            list.add(jsonValue);
        }
        return list;
    }

    public <T, K extends JsonValue> List<T> getValuesAs(Function<K, T> func) {
        int size = this.jsonNode.size();
        ArrayList<T> result = new ArrayList<T>(size);
        for (int i = 0; i < size; ++i) {
            JsonNode value = this.jsonNode.get(i);
            JsonValue jsonValue = JsonNodeAdapter.adapt(value);
            T element = func.apply(jsonValue);
            result.add(element);
        }
        return result;
    }

    public String getString(int index) {
        JsonNode value = this.jsonNode.get(Objects.checkIndex(index, this.size()));
        JsonNodeType nodeType = value.getNodeType();
        if (nodeType == JsonNodeType.STRING) {
            return value.textValue();
        }
        throw new ClassCastException(String.valueOf(JsonNodeType.STRING) + " expected but got: " + String.valueOf(nodeType));
    }

    public String getString(int index, String defaultValue) {
        if (index < 0 || index >= this.size()) {
            return defaultValue;
        }
        JsonNode value = this.jsonNode.get(index);
        JsonNodeType nodeType = value.getNodeType();
        if (nodeType == JsonNodeType.STRING) {
            return value.textValue();
        }
        return defaultValue;
    }

    public int getInt(int index) {
        JsonNode value = this.jsonNode.get(Objects.checkIndex(index, this.size()));
        JsonNodeType nodeType = value.getNodeType();
        if (nodeType == JsonNodeType.NUMBER) {
            return value.intValue();
        }
        throw new ClassCastException(String.valueOf(JsonNodeType.NUMBER) + " expected but got: " + String.valueOf(nodeType));
    }

    public int getInt(int index, int defaultValue) {
        if (index < 0 || index >= this.size()) {
            return defaultValue;
        }
        JsonNode value = this.jsonNode.get(index);
        JsonNodeType nodeType = value.getNodeType();
        if (nodeType == JsonNodeType.NUMBER) {
            return value.intValue();
        }
        return defaultValue;
    }

    public boolean getBoolean(int index) {
        JsonNode value = this.jsonNode.get(Objects.checkIndex(index, this.size()));
        JsonNodeType nodeType = value.getNodeType();
        if (nodeType == JsonNodeType.BOOLEAN) {
            return value.booleanValue();
        }
        throw new ClassCastException(String.valueOf(JsonNodeType.BOOLEAN) + " expected but got: " + String.valueOf(nodeType));
    }

    public boolean getBoolean(int index, boolean defaultValue) {
        if (index < 0 || index >= this.size()) {
            return defaultValue;
        }
        JsonNode value = this.jsonNode.get(index);
        JsonNodeType nodeType = value.getNodeType();
        if (nodeType == JsonNodeType.BOOLEAN) {
            return value.booleanValue();
        }
        return defaultValue;
    }

    public boolean isNull(int index) {
        JsonNode value = this.jsonNode.get(Objects.checkIndex(index, this.size()));
        return value.isNull();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof JsonArray)) {
            return false;
        }
        JsonArray other = (JsonArray)obj;
        return JsonNodeAdapter.arrayEquals(this.jsonNode, other);
    }

    public int hashCode() {
        return JsonNodeAdapter.arrayHashCode(this.jsonNode);
    }

    public String toString() {
        try {
            return JsonNodeAdapter.OBJECT_MAPPER.writeValueAsString((Object)this.jsonNode);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException("could not serialize JsonNode", e);
        }
    }

    final class JsonValueIterator
    implements ListIterator<JsonValue> {
        private int currentIndex;

        JsonValueIterator() {
            this(0);
        }

        JsonValueIterator(int initial) {
            this.currentIndex = initial;
        }

        @Override
        public boolean hasNext() {
            return this.currentIndex != JsonNodeJsonArray.this.jsonNode.size();
        }

        @Override
        public JsonValue next() {
            JsonValue jsonValue;
            try {
                jsonValue = JsonNodeJsonArray.this.get(this.currentIndex);
            }
            catch (IndexOutOfBoundsException e) {
                throw new NoSuchElementException(e);
            }
            ++this.currentIndex;
            return jsonValue;
        }

        @Override
        public boolean hasPrevious() {
            return this.currentIndex != 0;
        }

        @Override
        public JsonValue previous() {
            JsonValue jsonValue = JsonNodeJsonArray.this.get(this.currentIndex - 1);
            --this.currentIndex;
            return jsonValue;
        }

        @Override
        public int nextIndex() {
            return this.currentIndex;
        }

        @Override
        public int previousIndex() {
            return this.currentIndex - 1;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("remove");
        }

        @Override
        public void set(JsonValue e) {
            throw new UnsupportedOperationException("set");
        }

        @Override
        public void add(JsonValue e) {
            throw new UnsupportedOperationException("add");
        }

        @Override
        public void forEachRemaining(Consumer<? super JsonValue> action) {
            for (int i = this.currentIndex; i < JsonNodeJsonArray.this.size(); ++i) {
                action.accept((JsonValue)JsonNodeJsonArray.this.get(i));
            }
            this.currentIndex = JsonNodeJsonArray.this.size();
        }
    }

    final class SubList
    extends AbstractList<JsonValue>
    implements RandomAccess {
        private final int fromIndex;
        private final int toIndex;

        SubList(int fromIndex, int toIndex) {
            this.fromIndex = fromIndex;
            this.toIndex = toIndex;
        }

        @Override
        public int size() {
            return this.toIndex - this.fromIndex;
        }

        @Override
        public JsonValue get(int index) {
            Objects.checkIndex(index + this.fromIndex, JsonNodeJsonArray.this.size());
            return JsonNodeJsonArray.this.get(index + this.fromIndex);
        }
    }
}

