/*
 * Decompiled with CFR 0.152.
 */
package com.github.marschall.jsonnodereader;

import com.fasterxml.jackson.databind.JsonNode;
import jakarta.json.JsonNumber;
import jakarta.json.JsonValue;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Objects;

final class JsonNodeJsonNumber
implements JsonNumber {
    private final JsonNode jsonNode;

    JsonNodeJsonNumber(JsonNode jsonNode) {
        Objects.requireNonNull(jsonNode, "jsonNode");
        this.jsonNode = jsonNode;
    }

    public JsonValue.ValueType getValueType() {
        return JsonValue.ValueType.NUMBER;
    }

    public boolean isIntegral() {
        return this.jsonNode.isIntegralNumber();
    }

    public int intValue() {
        return this.jsonNode.intValue();
    }

    public int intValueExact() {
        if (this.jsonNode.canConvertToInt() && this.jsonNode.canConvertToExactIntegral()) {
            return this.jsonNode.intValue();
        }
        throw new ArithmeticException();
    }

    public long longValue() {
        return this.jsonNode.longValue();
    }

    public long longValueExact() {
        if (this.jsonNode.canConvertToLong() && this.jsonNode.canConvertToExactIntegral()) {
            return this.jsonNode.longValue();
        }
        throw new ArithmeticException();
    }

    public BigInteger bigIntegerValue() {
        return this.jsonNode.bigIntegerValue();
    }

    public BigInteger bigIntegerValueExact() {
        if (this.jsonNode.canConvertToExactIntegral()) {
            return this.jsonNode.bigIntegerValue();
        }
        throw new ArithmeticException();
    }

    public double doubleValue() {
        return this.jsonNode.doubleValue();
    }

    public BigDecimal bigDecimalValue() {
        return this.jsonNode.decimalValue();
    }

    public Number numberValue() {
        return this.jsonNode.numberValue();
    }

    public int hashCode() {
        return this.bigDecimalValue().hashCode();
    }

    public String toString() {
        return this.bigDecimalValue().toString();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof JsonNumber)) {
            return false;
        }
        JsonNumber other = (JsonNumber)obj;
        return this.bigDecimalValue().equals(other.bigDecimalValue());
    }
}

