/*
 * Decompiled with CFR 0.152.
 */
package com.github.marschall.jsonnodereader;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.JsonNodeType;
import com.github.marschall.jsonnodereader.JsonNodeAdapter;
import com.github.marschall.jsonnodereader.JsonNodeJsonArray;
import com.github.marschall.jsonnodereader.JsonNodeJsonNumber;
import com.github.marschall.jsonnodereader.JsonNodeJsonString;
import jakarta.json.JsonArray;
import jakarta.json.JsonNumber;
import jakarta.json.JsonObject;
import jakarta.json.JsonString;
import jakarta.json.JsonValue;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

final class JsonNodeJsonObject
implements JsonObject {
    private final JsonNode jsonNode;

    JsonNodeJsonObject(JsonNode jsonNode) {
        Objects.requireNonNull(jsonNode, "jsonNode");
        this.jsonNode = jsonNode;
    }

    public JsonValue.ValueType getValueType() {
        return JsonValue.ValueType.OBJECT;
    }

    public int size() {
        return this.jsonNode.size();
    }

    public boolean isEmpty() {
        return this.jsonNode.isEmpty();
    }

    public boolean containsKey(Object key) {
        if (!(key instanceof String)) {
            return false;
        }
        String s = (String)key;
        return this.jsonNode.get(s) != null;
    }

    public boolean containsValue(Object value) {
        if (!(value instanceof JsonValue)) {
            return false;
        }
        JsonValue jsonValue = (JsonValue)value;
        Iterator elements = this.jsonNode.elements();
        while (elements.hasNext()) {
            JsonNode child = (JsonNode)elements.next();
            if (!JsonNodeAdapter.valueEquals(child, jsonValue)) continue;
            return true;
        }
        return false;
    }

    public JsonValue get(Object key) {
        if (!(key instanceof String)) {
            return null;
        }
        String s = (String)key;
        JsonNode child = this.jsonNode.get(s);
        if (child != null) {
            return JsonNodeAdapter.adapt(child);
        }
        return null;
    }

    public JsonValue put(String key, JsonValue value) {
        throw new UnsupportedOperationException("put");
    }

    public JsonValue remove(Object key) {
        throw new UnsupportedOperationException("remove");
    }

    public void putAll(Map<? extends String, ? extends JsonValue> m) {
        throw new UnsupportedOperationException("putAll");
    }

    public void clear() {
        throw new UnsupportedOperationException("putAll");
    }

    public Set<String> keySet() {
        return this.jsonNode.properties().stream().map(Map.Entry::getKey).collect(Collectors.toSet());
    }

    public Collection<JsonValue> values() {
        return this.jsonNode.properties().stream().map(Map.Entry::getValue).map(JsonNodeAdapter::adapt).toList();
    }

    public Set<Map.Entry<String, JsonValue>> entrySet() {
        return this.jsonNode.properties().stream().map(entry -> Map.entry((String)entry.getKey(), JsonNodeAdapter.adapt((JsonNode)entry.getValue()))).collect(Collectors.toSet());
    }

    public JsonArray getJsonArray(String name) {
        JsonNode value = this.jsonNode.get(name);
        if (value == null) {
            return null;
        }
        JsonNodeType nodeType = value.getNodeType();
        if (nodeType == JsonNodeType.ARRAY) {
            return new JsonNodeJsonArray(value);
        }
        throw new ClassCastException(String.valueOf(JsonNodeType.ARRAY) + " expected but got: " + String.valueOf(nodeType));
    }

    public JsonObject getJsonObject(String name) {
        JsonNode value = this.jsonNode.get(name);
        if (value == null) {
            return null;
        }
        JsonNodeType nodeType = value.getNodeType();
        if (nodeType == JsonNodeType.OBJECT) {
            return new JsonNodeJsonObject(value);
        }
        throw new ClassCastException(String.valueOf(JsonNodeType.OBJECT) + " expected but got: " + String.valueOf(nodeType));
    }

    public JsonNumber getJsonNumber(String name) {
        JsonNode value = this.jsonNode.get(name);
        if (value == null) {
            return null;
        }
        JsonNodeType nodeType = value.getNodeType();
        if (nodeType == JsonNodeType.NUMBER) {
            return new JsonNodeJsonNumber(value);
        }
        throw new ClassCastException(String.valueOf(JsonNodeType.NUMBER) + " expected but got: " + String.valueOf(nodeType));
    }

    public JsonString getJsonString(String name) {
        JsonNode value = this.jsonNode.get(name);
        if (value == null) {
            return null;
        }
        JsonNodeType nodeType = value.getNodeType();
        if (nodeType == JsonNodeType.STRING) {
            return new JsonNodeJsonString(value);
        }
        throw new ClassCastException(String.valueOf(JsonNodeType.STRING) + " expected but got: " + String.valueOf(nodeType));
    }

    public String getString(String name) {
        JsonNode value = this.jsonNode.get(name);
        if (value == null) {
            throw new NullPointerException();
        }
        JsonNodeType nodeType = value.getNodeType();
        if (nodeType == JsonNodeType.STRING) {
            return value.textValue();
        }
        throw new ClassCastException(String.valueOf(JsonNodeType.STRING) + " expected but got: " + String.valueOf(nodeType));
    }

    public String getString(String name, String defaultValue) {
        JsonNode value = this.jsonNode.get(name);
        if (value == null) {
            return defaultValue;
        }
        JsonNodeType nodeType = value.getNodeType();
        if (nodeType == JsonNodeType.STRING) {
            return value.textValue();
        }
        return defaultValue;
    }

    public int getInt(String name) {
        JsonNode value = this.jsonNode.get(name);
        if (value == null) {
            throw new NullPointerException();
        }
        JsonNodeType nodeType = value.getNodeType();
        if (nodeType == JsonNodeType.NUMBER) {
            return value.intValue();
        }
        throw new ClassCastException(String.valueOf(JsonNodeType.NUMBER) + " expected but got: " + String.valueOf(nodeType));
    }

    public int getInt(String name, int defaultValue) {
        JsonNode value = this.jsonNode.get(name);
        if (value == null) {
            return defaultValue;
        }
        JsonNodeType nodeType = value.getNodeType();
        if (nodeType == JsonNodeType.NUMBER) {
            return value.intValue();
        }
        return defaultValue;
    }

    public boolean getBoolean(String name) {
        JsonNode value = this.jsonNode.get(name);
        if (value == null) {
            throw new NullPointerException();
        }
        JsonNodeType nodeType = value.getNodeType();
        if (nodeType == JsonNodeType.BOOLEAN) {
            return value.booleanValue();
        }
        throw new ClassCastException(String.valueOf(JsonNodeType.NUMBER) + " expected but got: " + String.valueOf(nodeType));
    }

    public boolean getBoolean(String name, boolean defaultValue) {
        JsonNode value = this.jsonNode.get(name);
        if (value == null) {
            return defaultValue;
        }
        JsonNodeType nodeType = value.getNodeType();
        if (nodeType == JsonNodeType.BOOLEAN) {
            return value.booleanValue();
        }
        return defaultValue;
    }

    public boolean isNull(String name) {
        return this.jsonNode.get(name).isNull();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof JsonObject)) {
            return false;
        }
        JsonObject other = (JsonObject)obj;
        return JsonNodeAdapter.objectEquals(this.jsonNode, other);
    }

    public int hashCode() {
        return JsonNodeAdapter.objectHashCode(this.jsonNode);
    }

    public String toString() {
        try {
            return JsonNodeAdapter.OBJECT_MAPPER.writeValueAsString((Object)this.jsonNode);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException("could not serialize JsonNode", e);
        }
    }
}

