/*
 * Decompiled with CFR 0.152.
 */
package com.github.marschall.pathjavafilemanager;

import java.io.IOException;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import javax.tools.FileObject;

abstract class PathFileObject
implements FileObject {
    final Path path;
    final Charset fileEncoding;

    PathFileObject(Path path, Charset fileEncoding) {
        this.path = path;
        this.fileEncoding = fileEncoding;
    }

    @Override
    public URI toUri() {
        return this.path.toUri();
    }

    @Override
    public String getName() {
        return this.path.toString();
    }

    @Override
    public long getLastModified() {
        try {
            return Files.getLastModifiedTime(this.path, new LinkOption[0]).toMillis();
        }
        catch (IOException e) {
            return 0L;
        }
    }

    @Override
    public boolean delete() {
        try {
            Files.delete(this.path);
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    public String toString() {
        return this.getName();
    }
}

