/*
 * Decompiled with CFR 0.152.
 */
package com.github.marschall.pathjavafilemanager;

import com.github.marschall.pathjavafilemanager.ClosedCecker;
import com.github.marschall.pathjavafilemanager.InputPathJavaFileObject;
import com.github.marschall.pathjavafilemanager.OutputPathJavaFileObject;
import com.github.marschall.pathjavafilemanager.PathFileObject;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.Set;
import javax.tools.FileObject;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import javax.tools.StandardJavaFileManager;
import javax.tools.StandardLocation;

public final class PathJavaFileManager
implements JavaFileManager {
    private static final String FILE_ENCODING = "file.encoding";
    private final Path source;
    private final Path classOutput;
    private final Path sourceOutput;
    private final ClassLoader classPath;
    private final ClassLoader annotationProcessorPath;
    private final ClosedCecker checker;
    private volatile Charset fileEncoding;
    private final StandardJavaFileManager delegate;

    public PathJavaFileManager(Path source, Path classOutput, Path sourceOutput, ClassLoader classPath, ClassLoader annotationProcessorPath, StandardJavaFileManager delegate) {
        this.source = source;
        this.classOutput = classOutput;
        this.sourceOutput = sourceOutput;
        this.classPath = classPath;
        this.annotationProcessorPath = annotationProcessorPath;
        this.delegate = delegate;
        this.checker = new ClosedCecker();
        this.fileEncoding = Charset.forName(System.getProperty(FILE_ENCODING));
    }

    @Override
    public ClassLoader getClassLoader(JavaFileManager.Location location) {
        this.checker.check();
        if (location != StandardLocation.CLASS_OUTPUT && location != StandardLocation.SOURCE_OUTPUT) {
            if (location == StandardLocation.CLASS_PATH) {
                return this.classPath;
            }
            if (location == StandardLocation.SOURCE_PATH) {
                return null;
            }
            if (location == StandardLocation.PLATFORM_CLASS_PATH) {
                return this.delegate.getClassLoader(location);
            }
            if (location == StandardLocation.ANNOTATION_PROCESSOR_PATH) {
                return this.annotationProcessorPath;
            }
        }
        return null;
    }

    @Override
    public Iterable<JavaFileObject> list(final JavaFileManager.Location location, String packageName, final Set<JavaFileObject.Kind> kinds, final boolean recurse) throws IOException {
        this.checker.check();
        if (location == StandardLocation.PLATFORM_CLASS_PATH || packageName.startsWith("java")) {
            return this.delegate.list(location, packageName, kinds, recurse);
        }
        Path basePath = this.getPath(location);
        if (basePath == null) {
            return Collections.emptyList();
        }
        final ArrayList<JavaFileObject> files = new ArrayList<JavaFileObject>();
        final Path path = PathJavaFileManager.resolvePackage(basePath, packageName);
        Files.walkFileTree(path, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                if (Files.isSameFile(path, dir)) {
                    return FileVisitResult.CONTINUE;
                }
                return recurse ? FileVisitResult.CONTINUE : FileVisitResult.SKIP_SUBTREE;
            }

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                JavaFileObject.Kind kind = PathJavaFileManager.getKind(file);
                if (kinds.contains((Object)kind)) {
                    PathFileObject fileObject = location.isOutputLocation() ? new OutputPathJavaFileObject(file, PathJavaFileManager.this.fileEncoding, kind) : new InputPathJavaFileObject(file, PathJavaFileManager.this.fileEncoding, kind);
                    files.add(fileObject);
                }
                return FileVisitResult.CONTINUE;
            }
        });
        return files;
    }

    private static JavaFileObject.Kind getKind(String fileName) {
        for (JavaFileObject.Kind kind : JavaFileObject.Kind.values()) {
            String extension = kind.extension;
            if (extension.isEmpty() || !fileName.endsWith(extension)) continue;
            return kind;
        }
        return JavaFileObject.Kind.OTHER;
    }

    private static JavaFileObject.Kind getKind(Path path) {
        String fileName = path.getFileName().toString();
        return PathJavaFileManager.getKind(fileName);
    }

    private Path getPath(JavaFileManager.Location location) {
        if (location == StandardLocation.CLASS_OUTPUT) {
            return this.classOutput;
        }
        if (location == StandardLocation.SOURCE_OUTPUT) {
            return this.sourceOutput;
        }
        if (location != StandardLocation.CLASS_PATH) {
            if (location == StandardLocation.SOURCE_PATH) {
                return this.source;
            }
            if (location == StandardLocation.PLATFORM_CLASS_PATH || location == StandardLocation.ANNOTATION_PROCESSOR_PATH) {
                // empty if block
            }
        }
        return null;
    }

    private Path getPathChecked(JavaFileManager.Location location) {
        Path path = this.getPath(location);
        if (path == null) {
            throw new IllegalArgumentException("unknown location: " + location);
        }
        return path;
    }

    private static Path resolvePackage(Path base, String packageName) {
        Path path = base;
        for (String element : packageName.split("\\.")) {
            path = path.resolve(element);
        }
        return path;
    }

    private static Path resolveClass(Path base, String className, String extension) {
        int dotIndex = className.lastIndexOf(46);
        Path resolvedPackage = PathJavaFileManager.resolvePackage(base, className.substring(0, dotIndex));
        return resolvedPackage.resolve(className.substring(dotIndex + 1) + '.' + extension);
    }

    @Override
    public String inferBinaryName(JavaFileManager.Location location, JavaFileObject file) {
        this.checker.check();
        if (location == StandardLocation.PLATFORM_CLASS_PATH) {
            return this.delegate.inferBinaryName(location, file);
        }
        if (!(file instanceof PathFileObject)) {
            throw new IllegalArgumentException("file: " + file + " of wrong file manager");
        }
        Path basePath = this.getPathChecked(location);
        PathFileObject pathFile = (PathFileObject)((Object)file);
        Path path = basePath.toAbsolutePath().relativize(pathFile.path);
        StringBuilder binaryName = new StringBuilder();
        int nameCount = path.getNameCount();
        for (int i = 0; i < nameCount; ++i) {
            if (i != 0) {
                binaryName.append('.');
            }
            Path element = path.getName(i);
            String fileName = element.toString();
            if (i < nameCount - 1) {
                binaryName.append(fileName);
                continue;
            }
            binaryName.append(fileName, 0, fileName.length() - file.getKind().extension.length());
        }
        return binaryName.toString();
    }

    @Override
    public boolean isSameFile(FileObject a, FileObject b) {
        if (!(a instanceof PathFileObject)) {
            throw new IllegalArgumentException("unsupported file object: " + a + " must have been created with this file manager");
        }
        if (!(b instanceof PathFileObject)) {
            throw new IllegalArgumentException("unsupported file object: " + a + " must have been created with this file manager");
        }
        PathFileObject first = (PathFileObject)a;
        PathFileObject second = (PathFileObject)b;
        try {
            return Files.isSameFile(first.path, second.path);
        }
        catch (IOException e) {
            throw new RuntimeException("could not compare " + a + " with " + b, e);
        }
    }

    @Override
    public boolean handleOption(String current, Iterator<String> remaining) {
        if (current.equals(FILE_ENCODING)) {
            if (remaining.hasNext()) {
                try {
                    this.fileEncoding = Charset.forName(remaining.next());
                }
                catch (IllegalArgumentException e) {
                    throw new IllegalArgumentException("unsuported value for file.encoding supported");
                }
                if (remaining.hasNext()) {
                    throw new IllegalArgumentException("only one value for file.encoding supported");
                }
            } else {
                throw new IllegalArgumentException("option value for file.encoding missing");
            }
            return false;
        }
        return false;
    }

    @Override
    public int isSupportedOption(String option) {
        if (option.equals(FILE_ENCODING)) {
            return 1;
        }
        return -1;
    }

    @Override
    public boolean hasLocation(JavaFileManager.Location location) {
        if (location == StandardLocation.CLASS_OUTPUT) {
            return true;
        }
        if (location == StandardLocation.SOURCE_OUTPUT) {
            return true;
        }
        if (location == StandardLocation.CLASS_PATH) {
            return true;
        }
        if (location == StandardLocation.SOURCE_PATH) {
            return true;
        }
        if (location == StandardLocation.PLATFORM_CLASS_PATH) {
            return true;
        }
        return location == StandardLocation.ANNOTATION_PROCESSOR_PATH;
    }

    @Override
    public JavaFileObject getJavaFileForInput(JavaFileManager.Location location, String className, JavaFileObject.Kind kind) throws IOException {
        this.checker.check();
        if (location == StandardLocation.PLATFORM_CLASS_PATH) {
            return this.delegate.getJavaFileForInput(location, className, kind);
        }
        if (location.isOutputLocation()) {
            throw new IllegalArgumentException(location + " is an output location");
        }
        Path basePath = this.getPathChecked(location);
        Path path = PathJavaFileManager.resolveClass(basePath, className, "java");
        return new InputPathJavaFileObject(path, this.fileEncoding, kind);
    }

    @Override
    public JavaFileObject getJavaFileForOutput(JavaFileManager.Location location, String className, JavaFileObject.Kind kind, FileObject sibling) throws IOException {
        this.checker.check();
        if (!location.isOutputLocation()) {
            throw new IllegalArgumentException(location + " is an not output location");
        }
        Path basePath = this.getPathChecked(location);
        Path path = PathJavaFileManager.resolveClass(basePath, className, "class");
        return new OutputPathJavaFileObject(path, this.fileEncoding, kind);
    }

    @Override
    public FileObject getFileForInput(JavaFileManager.Location location, String packageName, String relativeName) throws IOException {
        this.checker.check();
        if (location == StandardLocation.PLATFORM_CLASS_PATH) {
            return this.delegate.getFileForInput(location, packageName, relativeName);
        }
        if (location.isOutputLocation()) {
            throw new IllegalArgumentException(location + " is an output location");
        }
        Path basePath = this.getPathChecked(location);
        Path path = PathJavaFileManager.resolvePackage(basePath, packageName).resolve(relativeName);
        return new InputPathJavaFileObject(path, this.fileEncoding, PathJavaFileManager.getKind(relativeName));
    }

    @Override
    public FileObject getFileForOutput(JavaFileManager.Location location, String packageName, String relativeName, FileObject sibling) throws IOException {
        this.checker.check();
        if (!location.isOutputLocation()) {
            throw new IllegalArgumentException(location + " is an not output location");
        }
        Path basePath = this.getPathChecked(location);
        Path path = PathJavaFileManager.resolvePackage(basePath, packageName).resolve(relativeName);
        return new OutputPathJavaFileObject(path, this.fileEncoding, PathJavaFileManager.getKind(relativeName));
    }

    @Override
    public void flush() throws IOException {
    }

    @Override
    public void close() throws IOException {
        this.checker.close();
    }
}

