/*
 * Decompiled with CFR 0.152.
 */
package com.google.schemaorg;

import com.google.common.base.Preconditions;
import com.google.common.collect.Multimap;
import com.google.schemaorg.BaseTypeImpl;
import com.google.schemaorg.JsonLdContext;
import com.google.schemaorg.SchemaOrgException;
import com.google.schemaorg.ValueType;
import com.google.schemaorg.core.datatype.Text;
import javax.annotation.Nullable;

final class JsonLdContextImpl
extends BaseTypeImpl
implements JsonLdContext {
    protected JsonLdContextImpl(Multimap<String, ValueType> properties) {
        super(properties);
    }

    @Override
    public boolean isUrl() {
        return this.containsTerm("__context_url__");
    }

    @Override
    public boolean containsBase() {
        return this.containsTerm("@base");
    }

    private boolean containsTerm(String term) {
        return this.containsProperty(term);
    }

    @Override
    public String getUrl() throws SchemaOrgException {
        String url = this.getTerm("__context_url__");
        if (url == null) {
            throw new SchemaOrgException("@context URL is NULL");
        }
        return url;
    }

    @Override
    @Nullable
    public String getBase() throws SchemaOrgException {
        return this.getTerm("@base");
    }

    @Nullable
    private String getTerm(String term) throws SchemaOrgException {
        ValueType value = this.getSingleValueProperty(term);
        if (value == null) {
            return null;
        }
        return ((Text)value).getValue();
    }

    @Override
    public boolean contentEquals(ValueType that) {
        if (that == this) {
            return true;
        }
        if (that instanceof JsonLdContextImpl) {
            return this.getAllProperties().equals(((JsonLdContextImpl)that).getAllProperties());
        }
        return false;
    }

    static final class BuilderImpl
    extends BaseTypeImpl.BuilderImpl<JsonLdContext.Builder>
    implements JsonLdContext.Builder {
        BuilderImpl() {
        }

        @Override
        public JsonLdContext.Builder setBase(@Nullable String value) {
            return this.setTerm("@base", value);
        }

        JsonLdContext.Builder setUrl(String url) {
            Preconditions.checkNotNull((Object)url, (Object)"context url is null");
            return this.setTerm("__context_url__", url);
        }

        private JsonLdContext.Builder setTerm(String term, @Nullable String value) {
            Preconditions.checkNotNull((Object)term, (Object)"term is null");
            if (value == null) {
                return (JsonLdContext.Builder)this.setSingleValueProperty(term, null);
            }
            return (JsonLdContext.Builder)this.setSingleValueProperty(term, Text.of(value));
        }

        @Override
        public JsonLdContext build() {
            return new JsonLdContextImpl((Multimap<String, ValueType>)this.properties);
        }
    }
}

