/*
 * Decompiled with CFR 0.152.
 */
package com.google.schemaorg.core;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import com.google.schemaorg.SchemaOrgTypeImpl;
import com.google.schemaorg.ValueType;
import com.google.schemaorg.core.Action;
import com.google.schemaorg.core.AggregateRating;
import com.google.schemaorg.core.AlignmentObject;
import com.google.schemaorg.core.Answer;
import com.google.schemaorg.core.Article;
import com.google.schemaorg.core.Audience;
import com.google.schemaorg.core.AudioObject;
import com.google.schemaorg.core.Boolean;
import com.google.schemaorg.core.Comment;
import com.google.schemaorg.core.CommentImpl;
import com.google.schemaorg.core.CreativeWork;
import com.google.schemaorg.core.Duration;
import com.google.schemaorg.core.Event;
import com.google.schemaorg.core.ImageObject;
import com.google.schemaorg.core.InteractionCounter;
import com.google.schemaorg.core.Language;
import com.google.schemaorg.core.MediaObject;
import com.google.schemaorg.core.Offer;
import com.google.schemaorg.core.Organization;
import com.google.schemaorg.core.Person;
import com.google.schemaorg.core.Place;
import com.google.schemaorg.core.PublicationEvent;
import com.google.schemaorg.core.Question;
import com.google.schemaorg.core.Review;
import com.google.schemaorg.core.Thing;
import com.google.schemaorg.core.VideoObject;
import com.google.schemaorg.core.datatype.Date;
import com.google.schemaorg.core.datatype.DateTime;
import com.google.schemaorg.core.datatype.Integer;
import com.google.schemaorg.core.datatype.Number;
import com.google.schemaorg.core.datatype.Text;
import com.google.schemaorg.core.datatype.URL;
import com.google.schemaorg.goog.PopularityScoreSpecification;

public class AnswerImpl
extends CommentImpl
implements Answer {
    private static final ImmutableSet<String> PROPERTY_SET = AnswerImpl.initializePropertySet();

    private static ImmutableSet<String> initializePropertySet() {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        builder.add((Object)"http://schema.org/about");
        builder.add((Object)"http://schema.org/accessibilityAPI");
        builder.add((Object)"http://schema.org/accessibilityControl");
        builder.add((Object)"http://schema.org/accessibilityFeature");
        builder.add((Object)"http://schema.org/accessibilityHazard");
        builder.add((Object)"http://schema.org/accountablePerson");
        builder.add((Object)"http://schema.org/additionalType");
        builder.add((Object)"http://schema.org/aggregateRating");
        builder.add((Object)"http://schema.org/alternateName");
        builder.add((Object)"http://schema.org/alternativeHeadline");
        builder.add((Object)"http://schema.org/associatedMedia");
        builder.add((Object)"http://schema.org/audience");
        builder.add((Object)"http://schema.org/audio");
        builder.add((Object)"http://schema.org/author");
        builder.add((Object)"http://schema.org/award");
        builder.add((Object)"http://schema.org/awards");
        builder.add((Object)"http://schema.org/character");
        builder.add((Object)"http://schema.org/citation");
        builder.add((Object)"http://schema.org/comment");
        builder.add((Object)"http://schema.org/commentCount");
        builder.add((Object)"http://schema.org/contentLocation");
        builder.add((Object)"http://schema.org/contentRating");
        builder.add((Object)"http://schema.org/contributor");
        builder.add((Object)"http://schema.org/copyrightHolder");
        builder.add((Object)"http://schema.org/copyrightYear");
        builder.add((Object)"http://schema.org/creator");
        builder.add((Object)"http://schema.org/dateCreated");
        builder.add((Object)"http://schema.org/dateModified");
        builder.add((Object)"http://schema.org/datePublished");
        builder.add((Object)"http://schema.org/description");
        builder.add((Object)"http://schema.org/discussionUrl");
        builder.add((Object)"http://schema.org/downvoteCount");
        builder.add((Object)"http://schema.org/editor");
        builder.add((Object)"http://schema.org/educationalAlignment");
        builder.add((Object)"http://schema.org/educationalUse");
        builder.add((Object)"http://schema.org/encoding");
        builder.add((Object)"http://schema.org/encodings");
        builder.add((Object)"http://schema.org/exampleOfWork");
        builder.add((Object)"http://schema.org/fileFormat");
        builder.add((Object)"http://schema.org/genre");
        builder.add((Object)"http://schema.org/hasPart");
        builder.add((Object)"http://schema.org/headline");
        builder.add((Object)"http://schema.org/image");
        builder.add((Object)"http://schema.org/inLanguage");
        builder.add((Object)"http://schema.org/interactionStatistic");
        builder.add((Object)"http://schema.org/interactivityType");
        builder.add((Object)"http://schema.org/isBasedOnUrl");
        builder.add((Object)"http://schema.org/isFamilyFriendly");
        builder.add((Object)"http://schema.org/isPartOf");
        builder.add((Object)"http://schema.org/keywords");
        builder.add((Object)"http://schema.org/learningResourceType");
        builder.add((Object)"http://schema.org/license");
        builder.add((Object)"http://schema.org/locationCreated");
        builder.add((Object)"http://schema.org/mainEntity");
        builder.add((Object)"http://schema.org/mainEntityOfPage");
        builder.add((Object)"http://schema.org/mentions");
        builder.add((Object)"http://schema.org/name");
        builder.add((Object)"http://schema.org/offers");
        builder.add((Object)"http://schema.org/parentItem");
        builder.add((Object)"http://schema.org/position");
        builder.add((Object)"http://schema.org/potentialAction");
        builder.add((Object)"http://schema.org/producer");
        builder.add((Object)"http://schema.org/provider");
        builder.add((Object)"http://schema.org/publication");
        builder.add((Object)"http://schema.org/publisher");
        builder.add((Object)"http://schema.org/publishingPrinciples");
        builder.add((Object)"http://schema.org/recordedAt");
        builder.add((Object)"http://schema.org/releasedEvent");
        builder.add((Object)"http://schema.org/review");
        builder.add((Object)"http://schema.org/reviews");
        builder.add((Object)"http://schema.org/sameAs");
        builder.add((Object)"http://schema.org/schemaVersion");
        builder.add((Object)"http://schema.org/sourceOrganization");
        builder.add((Object)"http://schema.org/text");
        builder.add((Object)"http://schema.org/thumbnailUrl");
        builder.add((Object)"http://schema.org/timeRequired");
        builder.add((Object)"http://schema.org/translator");
        builder.add((Object)"http://schema.org/typicalAgeRange");
        builder.add((Object)"http://schema.org/upvoteCount");
        builder.add((Object)"http://schema.org/url");
        builder.add((Object)"http://schema.org/version");
        builder.add((Object)"http://schema.org/video");
        builder.add((Object)"http://schema.org/workExample");
        builder.add((Object)"http://schema.googleapis.com/detailedDescription");
        builder.add((Object)"http://schema.googleapis.com/popularityScore");
        return builder.build();
    }

    public AnswerImpl(Multimap<String, ValueType> properties, Multimap<String, Thing> reverseMap) {
        super(properties, reverseMap);
    }

    @Override
    public String getFullTypeName() {
        return "http://schema.org/Answer";
    }

    @Override
    public boolean includesProperty(String property) {
        return PROPERTY_SET.contains((Object)("http://schema.org/" + property)) || PROPERTY_SET.contains((Object)("http://schema.googleapis.com/" + property)) || PROPERTY_SET.contains((Object)property);
    }

    static final class BuilderImpl
    extends SchemaOrgTypeImpl.BuilderImpl<Answer.Builder>
    implements Answer.Builder {
        BuilderImpl() {
        }

        @Override
        public Answer.Builder addAbout(Thing value) {
            return (Answer.Builder)this.addProperty("http://schema.org/about", value);
        }

        @Override
        public Answer.Builder addAbout(Thing.Builder value) {
            return (Answer.Builder)this.addProperty("http://schema.org/about", value.build());
        }

        @Override
        public Answer.Builder addAbout(String value) {
            return (Answer.Builder)this.addProperty("http://schema.org/about", Text.of(value));
        }

        @Override
        public Answer.Builder addAccessibilityAPI(Text value) {
            return (Answer.Builder)this.addProperty("http://schema.org/accessibilityAPI", value);
        }

        @Override
        public Answer.Builder addAccessibilityAPI(String value) {
            return (Answer.Builder)this.addProperty("http://schema.org/accessibilityAPI", Text.of(value));
        }

        @Override
        public Answer.Builder addAccessibilityControl(Text value) {
            return (Answer.Builder)this.addProperty("http://schema.org/accessibilityControl", value);
        }

        @Override
        public Answer.Builder addAccessibilityControl(String value) {
            return (Answer.Builder)this.addProperty("http://schema.org/accessibilityControl", Text.of(value));
        }

        @Override
        public Answer.Builder addAccessibilityFeature(Text value) {
            return (Answer.Builder)this.addProperty("http://schema.org/accessibilityFeature", value);
        }

        @Override
        public Answer.Builder addAccessibilityFeature(String value) {
            return (Answer.Builder)this.addProperty("http://schema.org/accessibilityFeature", Text.of(value));
        }

        @Override
        public Answer.Builder addAccessibilityHazard(Text value) {
            return (Answer.Builder)this.addProperty("http://schema.org/accessibilityHazard", value);
        }

        @Override
        public Answer.Builder addAccessibilityHazard(String value) {
            return (Answer.Builder)this.addProperty("http://schema.org/accessibilityHazard", Text.of(value));
        }

        @Override
        public Answer.Builder addAccountablePerson(Person value) {
            return (Answer.Builder)this.addProperty("http://schema.org/accountablePerson", value);
        }

        @Override
        public Answer.Builder addAccountablePerson(Person.Builder value) {
            return (Answer.Builder)this.addProperty("http://schema.org/accountablePerson", value.build());
        }

        @Override
        public Answer.Builder addAccountablePerson(String value) {
            return (Answer.Builder)this.addProperty("http://schema.org/accountablePerson", Text.of(value));
        }

        @Override
        public Answer.Builder addAdditionalType(URL value) {
            return (Answer.Builder)this.addProperty("http://schema.org/additionalType", value);
        }

        @Override
        public Answer.Builder addAdditionalType(String value) {
            return (Answer.Builder)this.addProperty("http://schema.org/additionalType", Text.of(value));
        }

        @Override
        public Answer.Builder addAggregateRating(AggregateRating value) {
            return (Answer.Builder)this.addProperty("http://schema.org/aggregateRating", value);
        }

        @Override
        public Answer.Builder addAggregateRating(AggregateRating.Builder value) {
            return (Answer.Builder)this.addProperty("http://schema.org/aggregateRating", value.build());
        }

        @Override
        public Answer.Builder addAggregateRating(String value) {
            return (Answer.Builder)this.addProperty("http://schema.org/aggregateRating", Text.of(value));
        }

        @Override
        public Answer.Builder addAlternateName(Text value) {
            return (Answer.Builder)this.addProperty("http://schema.org/alternateName", value);
        }

        @Override
        public Answer.Builder addAlternateName(String value) {
            return (Answer.Builder)this.addProperty("http://schema.org/alternateName", Text.of(value));
        }

        @Override
        public Answer.Builder addAlternativeHeadline(Text value) {
            return (Answer.Builder)this.addProperty("http://schema.org/alternativeHeadline", value);
        }

        @Override
        public Answer.Builder addAlternativeHeadline(String value) {
            return (Answer.Builder)this.addProperty("http://schema.org/alternativeHeadline", Text.of(value));
        }

        @Override
        public Answer.Builder addAssociatedMedia(MediaObject value) {
            return (Answer.Builder)this.addProperty("http://schema.org/associatedMedia", value);
        }

        @Override
        public Answer.Builder addAssociatedMedia(MediaObject.Builder value) {
            return (Answer.Builder)this.addProperty("http://schema.org/associatedMedia", value.build());
        }

        @Override
        public Answer.Builder addAssociatedMedia(String value) {
            return (Answer.Builder)this.addProperty("http://schema.org/associatedMedia", Text.of(value));
        }

        @Override
        public Answer.Builder addAudience(Audience value) {
            return (Answer.Builder)this.addProperty("http://schema.org/audience", value);
        }

        @Override
        public Answer.Builder addAudience(Audience.Builder value) {
            return (Answer.Builder)this.addProperty("http://schema.org/audience", value.build());
        }

        @Override
        public Answer.Builder addAudience(String value) {
            return (Answer.Builder)this.addProperty("http://schema.org/audience", Text.of(value));
        }

        @Override
        public Answer.Builder addAudio(AudioObject value) {
            return (Answer.Builder)this.addProperty("http://schema.org/audio", value);
        }

        @Override
        public Answer.Builder addAudio(AudioObject.Builder value) {
            return (Answer.Builder)this.addProperty("http://schema.org/audio", value.build());
        }

        @Override
        public Answer.Builder addAudio(String value) {
            return (Answer.Builder)this.addProperty("http://schema.org/audio", Text.of(value));
        }

        @Override
        public Answer.Builder addAuthor(Organization value) {
            return (Answer.Builder)this.addProperty("http://schema.org/author", value);
        }

        @Override
        public Answer.Builder addAuthor(Organization.Builder value) {
            return (Answer.Builder)this.addProperty("http://schema.org/author", value.build());
        }

        @Override
        public Answer.Builder addAuthor(Person value) {
            return (Answer.Builder)this.addProperty("http://schema.org/author", value);
        }

        @Override
        public Answer.Builder addAuthor(Person.Builder value) {
            return (Answer.Builder)this.addProperty("http://schema.org/author", value.build());
        }

        @Override
        public Answer.Builder addAuthor(String value) {
            return (Answer.Builder)this.addProperty("http://schema.org/author", Text.of(value));
        }

        @Override
        public Answer.Builder addAward(Text value) {
            return (Answer.Builder)this.addProperty("http://schema.org/award", value);
        }

        @Override
        public Answer.Builder addAward(String value) {
            return (Answer.Builder)this.addProperty("http://schema.org/award", Text.of(value));
        }

        @Override
        public Answer.Builder addAwards(Text value) {
            return (Answer.Builder)this.addProperty("http://schema.org/awards", value);
        }

        @Override
        public Answer.Builder addAwards(String value) {
            return (Answer.Builder)this.addProperty("http://schema.org/awards", Text.of(value));
        }

        @Override
        public Answer.Builder addCharacter(Person value) {
            return (Answer.Builder)this.addProperty("http://schema.org/character", value);
        }

        @Override
        public Answer.Builder addCharacter(Person.Builder value) {
            return (Answer.Builder)this.addProperty("http://schema.org/character", value.build());
        }

        @Override
        public Answer.Builder addCharacter(String value) {
            return (Answer.Builder)this.addProperty("http://schema.org/character", Text.of(value));
        }

        @Override
        public Answer.Builder addCitation(CreativeWork value) {
            return (Answer.Builder)this.addProperty("http://schema.org/citation", value);
        }

        @Override
        public Answer.Builder addCitation(CreativeWork.Builder value) {
            return (Answer.Builder)this.addProperty("http://schema.org/citation", value.build());
        }

        @Override
        public Answer.Builder addCitation(Text value) {
            return (Answer.Builder)this.addProperty("http://schema.org/citation", value);
        }

        @Override
        public Answer.Builder addCitation(String value) {
            return (Answer.Builder)this.addProperty("http://schema.org/citation", Text.of(value));
        }

        @Override
        public Answer.Builder addComment(Comment value) {
            return (Answer.Builder)this.addProperty("http://schema.org/comment", value);
        }

        @Override
        public Answer.Builder addComment(Comment.Builder value) {
            return (Answer.Builder)this.addProperty("http://schema.org/comment", value.build());
        }

        @Override
        public Answer.Builder addComment(String value) {
            return (Answer.Builder)this.addProperty("http://schema.org/comment", Text.of(value));
        }

        @Override
        public Answer.Builder addCommentCount(Integer value) {
            return (Answer.Builder)this.addProperty("http://schema.org/commentCount", value);
        }

        @Override
        public Answer.Builder addCommentCount(String value) {
            return (Answer.Builder)this.addProperty("http://schema.org/commentCount", Text.of(value));
        }

        @Override
        public Answer.Builder addContentLocation(Place value) {
            return (Answer.Builder)this.addProperty("http://schema.org/contentLocation", value);
        }

        @Override
        public Answer.Builder addContentLocation(Place.Builder value) {
            return (Answer.Builder)this.addProperty("http://schema.org/contentLocation", value.build());
        }

        @Override
        public Answer.Builder addContentLocation(String value) {
            return (Answer.Builder)this.addProperty("http://schema.org/contentLocation", Text.of(value));
        }

        @Override
        public Answer.Builder addContentRating(Text value) {
            return (Answer.Builder)this.addProperty("http://schema.org/contentRating", value);
        }

        @Override
        public Answer.Builder addContentRating(String value) {
            return (Answer.Builder)this.addProperty("http://schema.org/contentRating", Text.of(value));
        }

        @Override
        public Answer.Builder addContributor(Organization value) {
            return (Answer.Builder)this.addProperty("http://schema.org/contributor", value);
        }

        @Override
        public Answer.Builder addContributor(Organization.Builder value) {
            return (Answer.Builder)this.addProperty("http://schema.org/contributor", value.build());
        }

        @Override
        public Answer.Builder addContributor(Person value) {
            return (Answer.Builder)this.addProperty("http://schema.org/contributor", value);
        }

        @Override
        public Answer.Builder addContributor(Person.Builder value) {
            return (Answer.Builder)this.addProperty("http://schema.org/contributor", value.build());
        }

        @Override
        public Answer.Builder addContributor(String value) {
            return (Answer.Builder)this.addProperty("http://schema.org/contributor", Text.of(value));
        }

        @Override
        public Answer.Builder addCopyrightHolder(Organization value) {
            return (Answer.Builder)this.addProperty("http://schema.org/copyrightHolder", value);
        }

        @Override
        public Answer.Builder addCopyrightHolder(Organization.Builder value) {
            return (Answer.Builder)this.addProperty("http://schema.org/copyrightHolder", value.build());
        }

        @Override
        public Answer.Builder addCopyrightHolder(Person value) {
            return (Answer.Builder)this.addProperty("http://schema.org/copyrightHolder", value);
        }

        @Override
        public Answer.Builder addCopyrightHolder(Person.Builder value) {
            return (Answer.Builder)this.addProperty("http://schema.org/copyrightHolder", value.build());
        }

        @Override
        public Answer.Builder addCopyrightHolder(String value) {
            return (Answer.Builder)this.addProperty("http://schema.org/copyrightHolder", Text.of(value));
        }

        @Override
        public Answer.Builder addCopyrightYear(Number value) {
            return (Answer.Builder)this.addProperty("http://schema.org/copyrightYear", value);
        }

        @Override
        public Answer.Builder addCopyrightYear(String value) {
            return (Answer.Builder)this.addProperty("http://schema.org/copyrightYear", Text.of(value));
        }

        @Override
        public Answer.Builder addCreator(Organization value) {
            return (Answer.Builder)this.addProperty("http://schema.org/creator", value);
        }

        @Override
        public Answer.Builder addCreator(Organization.Builder value) {
            return (Answer.Builder)this.addProperty("http://schema.org/creator", value.build());
        }

        @Override
        public Answer.Builder addCreator(Person value) {
            return (Answer.Builder)this.addProperty("http://schema.org/creator", value);
        }

        @Override
        public Answer.Builder addCreator(Person.Builder value) {
            return (Answer.Builder)this.addProperty("http://schema.org/creator", value.build());
        }

        @Override
        public Answer.Builder addCreator(String value) {
            return (Answer.Builder)this.addProperty("http://schema.org/creator", Text.of(value));
        }

        @Override
        public Answer.Builder addDateCreated(Date value) {
            return (Answer.Builder)this.addProperty("http://schema.org/dateCreated", value);
        }

        @Override
        public Answer.Builder addDateCreated(DateTime value) {
            return (Answer.Builder)this.addProperty("http://schema.org/dateCreated", value);
        }

        @Override
        public Answer.Builder addDateCreated(String value) {
            return (Answer.Builder)this.addProperty("http://schema.org/dateCreated", Text.of(value));
        }

        @Override
        public Answer.Builder addDateModified(Date value) {
            return (Answer.Builder)this.addProperty("http://schema.org/dateModified", value);
        }

        @Override
        public Answer.Builder addDateModified(DateTime value) {
            return (Answer.Builder)this.addProperty("http://schema.org/dateModified", value);
        }

        @Override
        public Answer.Builder addDateModified(String value) {
            return (Answer.Builder)this.addProperty("http://schema.org/dateModified", Text.of(value));
        }

        @Override
        public Answer.Builder addDatePublished(Date value) {
            return (Answer.Builder)this.addProperty("http://schema.org/datePublished", value);
        }

        @Override
        public Answer.Builder addDatePublished(String value) {
            return (Answer.Builder)this.addProperty("http://schema.org/datePublished", Text.of(value));
        }

        @Override
        public Answer.Builder addDescription(Text value) {
            return (Answer.Builder)this.addProperty("http://schema.org/description", value);
        }

        @Override
        public Answer.Builder addDescription(String value) {
            return (Answer.Builder)this.addProperty("http://schema.org/description", Text.of(value));
        }

        @Override
        public Answer.Builder addDiscussionUrl(URL value) {
            return (Answer.Builder)this.addProperty("http://schema.org/discussionUrl", value);
        }

        @Override
        public Answer.Builder addDiscussionUrl(String value) {
            return (Answer.Builder)this.addProperty("http://schema.org/discussionUrl", Text.of(value));
        }

        @Override
        public Answer.Builder addDownvoteCount(Integer value) {
            return (Answer.Builder)this.addProperty("http://schema.org/downvoteCount", value);
        }

        @Override
        public Answer.Builder addDownvoteCount(String value) {
            return (Answer.Builder)this.addProperty("http://schema.org/downvoteCount", Text.of(value));
        }

        @Override
        public Answer.Builder addEditor(Person value) {
            return (Answer.Builder)this.addProperty("http://schema.org/editor", value);
        }

        @Override
        public Answer.Builder addEditor(Person.Builder value) {
            return (Answer.Builder)this.addProperty("http://schema.org/editor", value.build());
        }

        @Override
        public Answer.Builder addEditor(String value) {
            return (Answer.Builder)this.addProperty("http://schema.org/editor", Text.of(value));
        }

        @Override
        public Answer.Builder addEducationalAlignment(AlignmentObject value) {
            return (Answer.Builder)this.addProperty("http://schema.org/educationalAlignment", value);
        }

        @Override
        public Answer.Builder addEducationalAlignment(AlignmentObject.Builder value) {
            return (Answer.Builder)this.addProperty("http://schema.org/educationalAlignment", value.build());
        }

        @Override
        public Answer.Builder addEducationalAlignment(String value) {
            return (Answer.Builder)this.addProperty("http://schema.org/educationalAlignment", Text.of(value));
        }

        @Override
        public Answer.Builder addEducationalUse(Text value) {
            return (Answer.Builder)this.addProperty("http://schema.org/educationalUse", value);
        }

        @Override
        public Answer.Builder addEducationalUse(String value) {
            return (Answer.Builder)this.addProperty("http://schema.org/educationalUse", Text.of(value));
        }

        @Override
        public Answer.Builder addEncoding(MediaObject value) {
            return (Answer.Builder)this.addProperty("http://schema.org/encoding", value);
        }

        @Override
        public Answer.Builder addEncoding(MediaObject.Builder value) {
            return (Answer.Builder)this.addProperty("http://schema.org/encoding", value.build());
        }

        @Override
        public Answer.Builder addEncoding(String value) {
            return (Answer.Builder)this.addProperty("http://schema.org/encoding", Text.of(value));
        }

        @Override
        public Answer.Builder addEncodings(MediaObject value) {
            return (Answer.Builder)this.addProperty("http://schema.org/encodings", value);
        }

        @Override
        public Answer.Builder addEncodings(MediaObject.Builder value) {
            return (Answer.Builder)this.addProperty("http://schema.org/encodings", value.build());
        }

        @Override
        public Answer.Builder addEncodings(String value) {
            return (Answer.Builder)this.addProperty("http://schema.org/encodings", Text.of(value));
        }

        @Override
        public Answer.Builder addExampleOfWork(CreativeWork value) {
            return (Answer.Builder)this.addProperty("http://schema.org/exampleOfWork", value);
        }

        @Override
        public Answer.Builder addExampleOfWork(CreativeWork.Builder value) {
            return (Answer.Builder)this.addProperty("http://schema.org/exampleOfWork", value.build());
        }

        @Override
        public Answer.Builder addExampleOfWork(String value) {
            return (Answer.Builder)this.addProperty("http://schema.org/exampleOfWork", Text.of(value));
        }

        @Override
        public Answer.Builder addFileFormat(Text value) {
            return (Answer.Builder)this.addProperty("http://schema.org/fileFormat", value);
        }

        @Override
        public Answer.Builder addFileFormat(String value) {
            return (Answer.Builder)this.addProperty("http://schema.org/fileFormat", Text.of(value));
        }

        @Override
        public Answer.Builder addGenre(Text value) {
            return (Answer.Builder)this.addProperty("http://schema.org/genre", value);
        }

        @Override
        public Answer.Builder addGenre(URL value) {
            return (Answer.Builder)this.addProperty("http://schema.org/genre", value);
        }

        @Override
        public Answer.Builder addGenre(String value) {
            return (Answer.Builder)this.addProperty("http://schema.org/genre", Text.of(value));
        }

        @Override
        public Answer.Builder addHasPart(CreativeWork value) {
            return (Answer.Builder)this.addProperty("http://schema.org/hasPart", value);
        }

        @Override
        public Answer.Builder addHasPart(CreativeWork.Builder value) {
            return (Answer.Builder)this.addProperty("http://schema.org/hasPart", value.build());
        }

        @Override
        public Answer.Builder addHasPart(String value) {
            return (Answer.Builder)this.addProperty("http://schema.org/hasPart", Text.of(value));
        }

        @Override
        public Answer.Builder addHeadline(Text value) {
            return (Answer.Builder)this.addProperty("http://schema.org/headline", value);
        }

        @Override
        public Answer.Builder addHeadline(String value) {
            return (Answer.Builder)this.addProperty("http://schema.org/headline", Text.of(value));
        }

        @Override
        public Answer.Builder addImage(ImageObject value) {
            return (Answer.Builder)this.addProperty("http://schema.org/image", value);
        }

        @Override
        public Answer.Builder addImage(ImageObject.Builder value) {
            return (Answer.Builder)this.addProperty("http://schema.org/image", value.build());
        }

        @Override
        public Answer.Builder addImage(URL value) {
            return (Answer.Builder)this.addProperty("http://schema.org/image", value);
        }

        @Override
        public Answer.Builder addImage(String value) {
            return (Answer.Builder)this.addProperty("http://schema.org/image", Text.of(value));
        }

        @Override
        public Answer.Builder addInLanguage(Language value) {
            return (Answer.Builder)this.addProperty("http://schema.org/inLanguage", value);
        }

        @Override
        public Answer.Builder addInLanguage(Language.Builder value) {
            return (Answer.Builder)this.addProperty("http://schema.org/inLanguage", value.build());
        }

        @Override
        public Answer.Builder addInLanguage(Text value) {
            return (Answer.Builder)this.addProperty("http://schema.org/inLanguage", value);
        }

        @Override
        public Answer.Builder addInLanguage(String value) {
            return (Answer.Builder)this.addProperty("http://schema.org/inLanguage", Text.of(value));
        }

        @Override
        public Answer.Builder addInteractionStatistic(InteractionCounter value) {
            return (Answer.Builder)this.addProperty("http://schema.org/interactionStatistic", value);
        }

        @Override
        public Answer.Builder addInteractionStatistic(InteractionCounter.Builder value) {
            return (Answer.Builder)this.addProperty("http://schema.org/interactionStatistic", value.build());
        }

        @Override
        public Answer.Builder addInteractionStatistic(String value) {
            return (Answer.Builder)this.addProperty("http://schema.org/interactionStatistic", Text.of(value));
        }

        @Override
        public Answer.Builder addInteractivityType(Text value) {
            return (Answer.Builder)this.addProperty("http://schema.org/interactivityType", value);
        }

        @Override
        public Answer.Builder addInteractivityType(String value) {
            return (Answer.Builder)this.addProperty("http://schema.org/interactivityType", Text.of(value));
        }

        @Override
        public Answer.Builder addIsBasedOnUrl(URL value) {
            return (Answer.Builder)this.addProperty("http://schema.org/isBasedOnUrl", value);
        }

        @Override
        public Answer.Builder addIsBasedOnUrl(String value) {
            return (Answer.Builder)this.addProperty("http://schema.org/isBasedOnUrl", Text.of(value));
        }

        @Override
        public Answer.Builder addIsFamilyFriendly(Boolean value) {
            return (Answer.Builder)this.addProperty("http://schema.org/isFamilyFriendly", value);
        }

        @Override
        public Answer.Builder addIsFamilyFriendly(String value) {
            return (Answer.Builder)this.addProperty("http://schema.org/isFamilyFriendly", Text.of(value));
        }

        @Override
        public Answer.Builder addIsPartOf(CreativeWork value) {
            return (Answer.Builder)this.addProperty("http://schema.org/isPartOf", value);
        }

        @Override
        public Answer.Builder addIsPartOf(CreativeWork.Builder value) {
            return (Answer.Builder)this.addProperty("http://schema.org/isPartOf", value.build());
        }

        @Override
        public Answer.Builder addIsPartOf(String value) {
            return (Answer.Builder)this.addProperty("http://schema.org/isPartOf", Text.of(value));
        }

        @Override
        public Answer.Builder addKeywords(Text value) {
            return (Answer.Builder)this.addProperty("http://schema.org/keywords", value);
        }

        @Override
        public Answer.Builder addKeywords(String value) {
            return (Answer.Builder)this.addProperty("http://schema.org/keywords", Text.of(value));
        }

        @Override
        public Answer.Builder addLearningResourceType(Text value) {
            return (Answer.Builder)this.addProperty("http://schema.org/learningResourceType", value);
        }

        @Override
        public Answer.Builder addLearningResourceType(String value) {
            return (Answer.Builder)this.addProperty("http://schema.org/learningResourceType", Text.of(value));
        }

        @Override
        public Answer.Builder addLicense(CreativeWork value) {
            return (Answer.Builder)this.addProperty("http://schema.org/license", value);
        }

        @Override
        public Answer.Builder addLicense(CreativeWork.Builder value) {
            return (Answer.Builder)this.addProperty("http://schema.org/license", value.build());
        }

        @Override
        public Answer.Builder addLicense(URL value) {
            return (Answer.Builder)this.addProperty("http://schema.org/license", value);
        }

        @Override
        public Answer.Builder addLicense(String value) {
            return (Answer.Builder)this.addProperty("http://schema.org/license", Text.of(value));
        }

        @Override
        public Answer.Builder addLocationCreated(Place value) {
            return (Answer.Builder)this.addProperty("http://schema.org/locationCreated", value);
        }

        @Override
        public Answer.Builder addLocationCreated(Place.Builder value) {
            return (Answer.Builder)this.addProperty("http://schema.org/locationCreated", value.build());
        }

        @Override
        public Answer.Builder addLocationCreated(String value) {
            return (Answer.Builder)this.addProperty("http://schema.org/locationCreated", Text.of(value));
        }

        @Override
        public Answer.Builder addMainEntity(Thing value) {
            return (Answer.Builder)this.addProperty("http://schema.org/mainEntity", value);
        }

        @Override
        public Answer.Builder addMainEntity(Thing.Builder value) {
            return (Answer.Builder)this.addProperty("http://schema.org/mainEntity", value.build());
        }

        @Override
        public Answer.Builder addMainEntity(String value) {
            return (Answer.Builder)this.addProperty("http://schema.org/mainEntity", Text.of(value));
        }

        @Override
        public Answer.Builder addMainEntityOfPage(CreativeWork value) {
            return (Answer.Builder)this.addProperty("http://schema.org/mainEntityOfPage", value);
        }

        @Override
        public Answer.Builder addMainEntityOfPage(CreativeWork.Builder value) {
            return (Answer.Builder)this.addProperty("http://schema.org/mainEntityOfPage", value.build());
        }

        @Override
        public Answer.Builder addMainEntityOfPage(URL value) {
            return (Answer.Builder)this.addProperty("http://schema.org/mainEntityOfPage", value);
        }

        @Override
        public Answer.Builder addMainEntityOfPage(String value) {
            return (Answer.Builder)this.addProperty("http://schema.org/mainEntityOfPage", Text.of(value));
        }

        @Override
        public Answer.Builder addMentions(Thing value) {
            return (Answer.Builder)this.addProperty("http://schema.org/mentions", value);
        }

        @Override
        public Answer.Builder addMentions(Thing.Builder value) {
            return (Answer.Builder)this.addProperty("http://schema.org/mentions", value.build());
        }

        @Override
        public Answer.Builder addMentions(String value) {
            return (Answer.Builder)this.addProperty("http://schema.org/mentions", Text.of(value));
        }

        @Override
        public Answer.Builder addName(Text value) {
            return (Answer.Builder)this.addProperty("http://schema.org/name", value);
        }

        @Override
        public Answer.Builder addName(String value) {
            return (Answer.Builder)this.addProperty("http://schema.org/name", Text.of(value));
        }

        @Override
        public Answer.Builder addOffers(Offer value) {
            return (Answer.Builder)this.addProperty("http://schema.org/offers", value);
        }

        @Override
        public Answer.Builder addOffers(Offer.Builder value) {
            return (Answer.Builder)this.addProperty("http://schema.org/offers", value.build());
        }

        @Override
        public Answer.Builder addOffers(String value) {
            return (Answer.Builder)this.addProperty("http://schema.org/offers", Text.of(value));
        }

        @Override
        public Answer.Builder addParentItem(Question value) {
            return (Answer.Builder)this.addProperty("http://schema.org/parentItem", value);
        }

        @Override
        public Answer.Builder addParentItem(Question.Builder value) {
            return (Answer.Builder)this.addProperty("http://schema.org/parentItem", value.build());
        }

        @Override
        public Answer.Builder addParentItem(String value) {
            return (Answer.Builder)this.addProperty("http://schema.org/parentItem", Text.of(value));
        }

        @Override
        public Answer.Builder addPosition(Integer value) {
            return (Answer.Builder)this.addProperty("http://schema.org/position", value);
        }

        @Override
        public Answer.Builder addPosition(Text value) {
            return (Answer.Builder)this.addProperty("http://schema.org/position", value);
        }

        @Override
        public Answer.Builder addPosition(String value) {
            return (Answer.Builder)this.addProperty("http://schema.org/position", Text.of(value));
        }

        @Override
        public Answer.Builder addPotentialAction(Action value) {
            return (Answer.Builder)this.addProperty("http://schema.org/potentialAction", value);
        }

        @Override
        public Answer.Builder addPotentialAction(Action.Builder value) {
            return (Answer.Builder)this.addProperty("http://schema.org/potentialAction", value.build());
        }

        @Override
        public Answer.Builder addPotentialAction(String value) {
            return (Answer.Builder)this.addProperty("http://schema.org/potentialAction", Text.of(value));
        }

        @Override
        public Answer.Builder addProducer(Organization value) {
            return (Answer.Builder)this.addProperty("http://schema.org/producer", value);
        }

        @Override
        public Answer.Builder addProducer(Organization.Builder value) {
            return (Answer.Builder)this.addProperty("http://schema.org/producer", value.build());
        }

        @Override
        public Answer.Builder addProducer(Person value) {
            return (Answer.Builder)this.addProperty("http://schema.org/producer", value);
        }

        @Override
        public Answer.Builder addProducer(Person.Builder value) {
            return (Answer.Builder)this.addProperty("http://schema.org/producer", value.build());
        }

        @Override
        public Answer.Builder addProducer(String value) {
            return (Answer.Builder)this.addProperty("http://schema.org/producer", Text.of(value));
        }

        @Override
        public Answer.Builder addProvider(Organization value) {
            return (Answer.Builder)this.addProperty("http://schema.org/provider", value);
        }

        @Override
        public Answer.Builder addProvider(Organization.Builder value) {
            return (Answer.Builder)this.addProperty("http://schema.org/provider", value.build());
        }

        @Override
        public Answer.Builder addProvider(Person value) {
            return (Answer.Builder)this.addProperty("http://schema.org/provider", value);
        }

        @Override
        public Answer.Builder addProvider(Person.Builder value) {
            return (Answer.Builder)this.addProperty("http://schema.org/provider", value.build());
        }

        @Override
        public Answer.Builder addProvider(String value) {
            return (Answer.Builder)this.addProperty("http://schema.org/provider", Text.of(value));
        }

        @Override
        public Answer.Builder addPublication(PublicationEvent value) {
            return (Answer.Builder)this.addProperty("http://schema.org/publication", value);
        }

        @Override
        public Answer.Builder addPublication(PublicationEvent.Builder value) {
            return (Answer.Builder)this.addProperty("http://schema.org/publication", value.build());
        }

        @Override
        public Answer.Builder addPublication(String value) {
            return (Answer.Builder)this.addProperty("http://schema.org/publication", Text.of(value));
        }

        @Override
        public Answer.Builder addPublisher(Organization value) {
            return (Answer.Builder)this.addProperty("http://schema.org/publisher", value);
        }

        @Override
        public Answer.Builder addPublisher(Organization.Builder value) {
            return (Answer.Builder)this.addProperty("http://schema.org/publisher", value.build());
        }

        @Override
        public Answer.Builder addPublisher(Person value) {
            return (Answer.Builder)this.addProperty("http://schema.org/publisher", value);
        }

        @Override
        public Answer.Builder addPublisher(Person.Builder value) {
            return (Answer.Builder)this.addProperty("http://schema.org/publisher", value.build());
        }

        @Override
        public Answer.Builder addPublisher(String value) {
            return (Answer.Builder)this.addProperty("http://schema.org/publisher", Text.of(value));
        }

        @Override
        public Answer.Builder addPublishingPrinciples(URL value) {
            return (Answer.Builder)this.addProperty("http://schema.org/publishingPrinciples", value);
        }

        @Override
        public Answer.Builder addPublishingPrinciples(String value) {
            return (Answer.Builder)this.addProperty("http://schema.org/publishingPrinciples", Text.of(value));
        }

        @Override
        public Answer.Builder addRecordedAt(Event value) {
            return (Answer.Builder)this.addProperty("http://schema.org/recordedAt", value);
        }

        @Override
        public Answer.Builder addRecordedAt(Event.Builder value) {
            return (Answer.Builder)this.addProperty("http://schema.org/recordedAt", value.build());
        }

        @Override
        public Answer.Builder addRecordedAt(String value) {
            return (Answer.Builder)this.addProperty("http://schema.org/recordedAt", Text.of(value));
        }

        @Override
        public Answer.Builder addReleasedEvent(PublicationEvent value) {
            return (Answer.Builder)this.addProperty("http://schema.org/releasedEvent", value);
        }

        @Override
        public Answer.Builder addReleasedEvent(PublicationEvent.Builder value) {
            return (Answer.Builder)this.addProperty("http://schema.org/releasedEvent", value.build());
        }

        @Override
        public Answer.Builder addReleasedEvent(String value) {
            return (Answer.Builder)this.addProperty("http://schema.org/releasedEvent", Text.of(value));
        }

        @Override
        public Answer.Builder addReview(Review value) {
            return (Answer.Builder)this.addProperty("http://schema.org/review", value);
        }

        @Override
        public Answer.Builder addReview(Review.Builder value) {
            return (Answer.Builder)this.addProperty("http://schema.org/review", value.build());
        }

        @Override
        public Answer.Builder addReview(String value) {
            return (Answer.Builder)this.addProperty("http://schema.org/review", Text.of(value));
        }

        @Override
        public Answer.Builder addReviews(Review value) {
            return (Answer.Builder)this.addProperty("http://schema.org/reviews", value);
        }

        @Override
        public Answer.Builder addReviews(Review.Builder value) {
            return (Answer.Builder)this.addProperty("http://schema.org/reviews", value.build());
        }

        @Override
        public Answer.Builder addReviews(String value) {
            return (Answer.Builder)this.addProperty("http://schema.org/reviews", Text.of(value));
        }

        @Override
        public Answer.Builder addSameAs(URL value) {
            return (Answer.Builder)this.addProperty("http://schema.org/sameAs", value);
        }

        @Override
        public Answer.Builder addSameAs(String value) {
            return (Answer.Builder)this.addProperty("http://schema.org/sameAs", Text.of(value));
        }

        @Override
        public Answer.Builder addSchemaVersion(Text value) {
            return (Answer.Builder)this.addProperty("http://schema.org/schemaVersion", value);
        }

        @Override
        public Answer.Builder addSchemaVersion(URL value) {
            return (Answer.Builder)this.addProperty("http://schema.org/schemaVersion", value);
        }

        @Override
        public Answer.Builder addSchemaVersion(String value) {
            return (Answer.Builder)this.addProperty("http://schema.org/schemaVersion", Text.of(value));
        }

        @Override
        public Answer.Builder addSourceOrganization(Organization value) {
            return (Answer.Builder)this.addProperty("http://schema.org/sourceOrganization", value);
        }

        @Override
        public Answer.Builder addSourceOrganization(Organization.Builder value) {
            return (Answer.Builder)this.addProperty("http://schema.org/sourceOrganization", value.build());
        }

        @Override
        public Answer.Builder addSourceOrganization(String value) {
            return (Answer.Builder)this.addProperty("http://schema.org/sourceOrganization", Text.of(value));
        }

        @Override
        public Answer.Builder addText(Text value) {
            return (Answer.Builder)this.addProperty("http://schema.org/text", value);
        }

        @Override
        public Answer.Builder addText(String value) {
            return (Answer.Builder)this.addProperty("http://schema.org/text", Text.of(value));
        }

        @Override
        public Answer.Builder addThumbnailUrl(URL value) {
            return (Answer.Builder)this.addProperty("http://schema.org/thumbnailUrl", value);
        }

        @Override
        public Answer.Builder addThumbnailUrl(String value) {
            return (Answer.Builder)this.addProperty("http://schema.org/thumbnailUrl", Text.of(value));
        }

        @Override
        public Answer.Builder addTimeRequired(Duration value) {
            return (Answer.Builder)this.addProperty("http://schema.org/timeRequired", value);
        }

        @Override
        public Answer.Builder addTimeRequired(Duration.Builder value) {
            return (Answer.Builder)this.addProperty("http://schema.org/timeRequired", value.build());
        }

        @Override
        public Answer.Builder addTimeRequired(String value) {
            return (Answer.Builder)this.addProperty("http://schema.org/timeRequired", Text.of(value));
        }

        @Override
        public Answer.Builder addTranslator(Organization value) {
            return (Answer.Builder)this.addProperty("http://schema.org/translator", value);
        }

        @Override
        public Answer.Builder addTranslator(Organization.Builder value) {
            return (Answer.Builder)this.addProperty("http://schema.org/translator", value.build());
        }

        @Override
        public Answer.Builder addTranslator(Person value) {
            return (Answer.Builder)this.addProperty("http://schema.org/translator", value);
        }

        @Override
        public Answer.Builder addTranslator(Person.Builder value) {
            return (Answer.Builder)this.addProperty("http://schema.org/translator", value.build());
        }

        @Override
        public Answer.Builder addTranslator(String value) {
            return (Answer.Builder)this.addProperty("http://schema.org/translator", Text.of(value));
        }

        @Override
        public Answer.Builder addTypicalAgeRange(Text value) {
            return (Answer.Builder)this.addProperty("http://schema.org/typicalAgeRange", value);
        }

        @Override
        public Answer.Builder addTypicalAgeRange(String value) {
            return (Answer.Builder)this.addProperty("http://schema.org/typicalAgeRange", Text.of(value));
        }

        @Override
        public Answer.Builder addUpvoteCount(Integer value) {
            return (Answer.Builder)this.addProperty("http://schema.org/upvoteCount", value);
        }

        @Override
        public Answer.Builder addUpvoteCount(String value) {
            return (Answer.Builder)this.addProperty("http://schema.org/upvoteCount", Text.of(value));
        }

        @Override
        public Answer.Builder addUrl(URL value) {
            return (Answer.Builder)this.addProperty("http://schema.org/url", value);
        }

        @Override
        public Answer.Builder addUrl(String value) {
            return (Answer.Builder)this.addProperty("http://schema.org/url", Text.of(value));
        }

        @Override
        public Answer.Builder addVersion(Number value) {
            return (Answer.Builder)this.addProperty("http://schema.org/version", value);
        }

        @Override
        public Answer.Builder addVersion(String value) {
            return (Answer.Builder)this.addProperty("http://schema.org/version", Text.of(value));
        }

        @Override
        public Answer.Builder addVideo(VideoObject value) {
            return (Answer.Builder)this.addProperty("http://schema.org/video", value);
        }

        @Override
        public Answer.Builder addVideo(VideoObject.Builder value) {
            return (Answer.Builder)this.addProperty("http://schema.org/video", value.build());
        }

        @Override
        public Answer.Builder addVideo(String value) {
            return (Answer.Builder)this.addProperty("http://schema.org/video", Text.of(value));
        }

        @Override
        public Answer.Builder addWorkExample(CreativeWork value) {
            return (Answer.Builder)this.addProperty("http://schema.org/workExample", value);
        }

        @Override
        public Answer.Builder addWorkExample(CreativeWork.Builder value) {
            return (Answer.Builder)this.addProperty("http://schema.org/workExample", value.build());
        }

        @Override
        public Answer.Builder addWorkExample(String value) {
            return (Answer.Builder)this.addProperty("http://schema.org/workExample", Text.of(value));
        }

        @Override
        public Answer.Builder addDetailedDescription(Article value) {
            return (Answer.Builder)this.addProperty("http://schema.googleapis.com/detailedDescription", value);
        }

        @Override
        public Answer.Builder addDetailedDescription(Article.Builder value) {
            return (Answer.Builder)this.addProperty("http://schema.googleapis.com/detailedDescription", value.build());
        }

        @Override
        public Answer.Builder addDetailedDescription(String value) {
            return (Answer.Builder)this.addProperty("http://schema.googleapis.com/detailedDescription", Text.of(value));
        }

        @Override
        public Answer.Builder addPopularityScore(PopularityScoreSpecification value) {
            return (Answer.Builder)this.addProperty("http://schema.googleapis.com/popularityScore", value);
        }

        @Override
        public Answer.Builder addPopularityScore(PopularityScoreSpecification.Builder value) {
            return (Answer.Builder)this.addProperty("http://schema.googleapis.com/popularityScore", value.build());
        }

        @Override
        public Answer.Builder addPopularityScore(String value) {
            return (Answer.Builder)this.addProperty("http://schema.googleapis.com/popularityScore", Text.of(value));
        }

        @Override
        public Answer build() {
            return new AnswerImpl((Multimap<String, ValueType>)this.properties, (Multimap<String, Thing>)this.reverseMap);
        }
    }
}

