/*
 * Decompiled with CFR 0.152.
 */
package com.google.schemaorg.core;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import com.google.schemaorg.SchemaOrgTypeImpl;
import com.google.schemaorg.ValueType;
import com.google.schemaorg.core.Action;
import com.google.schemaorg.core.Article;
import com.google.schemaorg.core.BloodTest;
import com.google.schemaorg.core.CreativeWork;
import com.google.schemaorg.core.Drug;
import com.google.schemaorg.core.ImageObject;
import com.google.schemaorg.core.MedicalCode;
import com.google.schemaorg.core.MedicalCondition;
import com.google.schemaorg.core.MedicalDevice;
import com.google.schemaorg.core.MedicalGuideline;
import com.google.schemaorg.core.MedicalSign;
import com.google.schemaorg.core.MedicalSpecialty;
import com.google.schemaorg.core.MedicalStudy;
import com.google.schemaorg.core.MedicalTestImpl;
import com.google.schemaorg.core.MedicineSystem;
import com.google.schemaorg.core.Organization;
import com.google.schemaorg.core.Thing;
import com.google.schemaorg.core.datatype.Text;
import com.google.schemaorg.core.datatype.URL;
import com.google.schemaorg.goog.PopularityScoreSpecification;

public class BloodTestImpl
extends MedicalTestImpl
implements BloodTest {
    private static final ImmutableSet<String> PROPERTY_SET = BloodTestImpl.initializePropertySet();

    private static ImmutableSet<String> initializePropertySet() {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        builder.add((Object)"http://schema.org/additionalType");
        builder.add((Object)"http://schema.org/affectedBy");
        builder.add((Object)"http://schema.org/alternateName");
        builder.add((Object)"http://schema.org/code");
        builder.add((Object)"http://schema.org/description");
        builder.add((Object)"http://schema.org/guideline");
        builder.add((Object)"http://schema.org/image");
        builder.add((Object)"http://schema.org/mainEntityOfPage");
        builder.add((Object)"http://schema.org/medicineSystem");
        builder.add((Object)"http://schema.org/name");
        builder.add((Object)"http://schema.org/normalRange");
        builder.add((Object)"http://schema.org/potentialAction");
        builder.add((Object)"http://schema.org/recognizingAuthority");
        builder.add((Object)"http://schema.org/relevantSpecialty");
        builder.add((Object)"http://schema.org/sameAs");
        builder.add((Object)"http://schema.org/signDetected");
        builder.add((Object)"http://schema.org/study");
        builder.add((Object)"http://schema.org/url");
        builder.add((Object)"http://schema.org/usedToDiagnose");
        builder.add((Object)"http://schema.org/usesDevice");
        builder.add((Object)"http://schema.googleapis.com/detailedDescription");
        builder.add((Object)"http://schema.googleapis.com/popularityScore");
        return builder.build();
    }

    public BloodTestImpl(Multimap<String, ValueType> properties, Multimap<String, Thing> reverseMap) {
        super(properties, reverseMap);
    }

    @Override
    public String getFullTypeName() {
        return "http://schema.org/BloodTest";
    }

    @Override
    public boolean includesProperty(String property) {
        return PROPERTY_SET.contains((Object)("http://schema.org/" + property)) || PROPERTY_SET.contains((Object)("http://schema.googleapis.com/" + property)) || PROPERTY_SET.contains((Object)property);
    }

    static final class BuilderImpl
    extends SchemaOrgTypeImpl.BuilderImpl<BloodTest.Builder>
    implements BloodTest.Builder {
        BuilderImpl() {
        }

        @Override
        public BloodTest.Builder addAdditionalType(URL value) {
            return (BloodTest.Builder)this.addProperty("http://schema.org/additionalType", value);
        }

        @Override
        public BloodTest.Builder addAdditionalType(String value) {
            return (BloodTest.Builder)this.addProperty("http://schema.org/additionalType", Text.of(value));
        }

        @Override
        public BloodTest.Builder addAffectedBy(Drug value) {
            return (BloodTest.Builder)this.addProperty("http://schema.org/affectedBy", value);
        }

        @Override
        public BloodTest.Builder addAffectedBy(Drug.Builder value) {
            return (BloodTest.Builder)this.addProperty("http://schema.org/affectedBy", value.build());
        }

        @Override
        public BloodTest.Builder addAffectedBy(String value) {
            return (BloodTest.Builder)this.addProperty("http://schema.org/affectedBy", Text.of(value));
        }

        @Override
        public BloodTest.Builder addAlternateName(Text value) {
            return (BloodTest.Builder)this.addProperty("http://schema.org/alternateName", value);
        }

        @Override
        public BloodTest.Builder addAlternateName(String value) {
            return (BloodTest.Builder)this.addProperty("http://schema.org/alternateName", Text.of(value));
        }

        @Override
        public BloodTest.Builder addCode(MedicalCode value) {
            return (BloodTest.Builder)this.addProperty("http://schema.org/code", value);
        }

        @Override
        public BloodTest.Builder addCode(MedicalCode.Builder value) {
            return (BloodTest.Builder)this.addProperty("http://schema.org/code", value.build());
        }

        @Override
        public BloodTest.Builder addCode(String value) {
            return (BloodTest.Builder)this.addProperty("http://schema.org/code", Text.of(value));
        }

        @Override
        public BloodTest.Builder addDescription(Text value) {
            return (BloodTest.Builder)this.addProperty("http://schema.org/description", value);
        }

        @Override
        public BloodTest.Builder addDescription(String value) {
            return (BloodTest.Builder)this.addProperty("http://schema.org/description", Text.of(value));
        }

        @Override
        public BloodTest.Builder addGuideline(MedicalGuideline value) {
            return (BloodTest.Builder)this.addProperty("http://schema.org/guideline", value);
        }

        @Override
        public BloodTest.Builder addGuideline(MedicalGuideline.Builder value) {
            return (BloodTest.Builder)this.addProperty("http://schema.org/guideline", value.build());
        }

        @Override
        public BloodTest.Builder addGuideline(String value) {
            return (BloodTest.Builder)this.addProperty("http://schema.org/guideline", Text.of(value));
        }

        @Override
        public BloodTest.Builder addImage(ImageObject value) {
            return (BloodTest.Builder)this.addProperty("http://schema.org/image", value);
        }

        @Override
        public BloodTest.Builder addImage(ImageObject.Builder value) {
            return (BloodTest.Builder)this.addProperty("http://schema.org/image", value.build());
        }

        @Override
        public BloodTest.Builder addImage(URL value) {
            return (BloodTest.Builder)this.addProperty("http://schema.org/image", value);
        }

        @Override
        public BloodTest.Builder addImage(String value) {
            return (BloodTest.Builder)this.addProperty("http://schema.org/image", Text.of(value));
        }

        @Override
        public BloodTest.Builder addMainEntityOfPage(CreativeWork value) {
            return (BloodTest.Builder)this.addProperty("http://schema.org/mainEntityOfPage", value);
        }

        @Override
        public BloodTest.Builder addMainEntityOfPage(CreativeWork.Builder value) {
            return (BloodTest.Builder)this.addProperty("http://schema.org/mainEntityOfPage", value.build());
        }

        @Override
        public BloodTest.Builder addMainEntityOfPage(URL value) {
            return (BloodTest.Builder)this.addProperty("http://schema.org/mainEntityOfPage", value);
        }

        @Override
        public BloodTest.Builder addMainEntityOfPage(String value) {
            return (BloodTest.Builder)this.addProperty("http://schema.org/mainEntityOfPage", Text.of(value));
        }

        @Override
        public BloodTest.Builder addMedicineSystem(MedicineSystem value) {
            return (BloodTest.Builder)this.addProperty("http://schema.org/medicineSystem", value);
        }

        @Override
        public BloodTest.Builder addMedicineSystem(String value) {
            return (BloodTest.Builder)this.addProperty("http://schema.org/medicineSystem", Text.of(value));
        }

        @Override
        public BloodTest.Builder addName(Text value) {
            return (BloodTest.Builder)this.addProperty("http://schema.org/name", value);
        }

        @Override
        public BloodTest.Builder addName(String value) {
            return (BloodTest.Builder)this.addProperty("http://schema.org/name", Text.of(value));
        }

        @Override
        public BloodTest.Builder addNormalRange(Text value) {
            return (BloodTest.Builder)this.addProperty("http://schema.org/normalRange", value);
        }

        @Override
        public BloodTest.Builder addNormalRange(String value) {
            return (BloodTest.Builder)this.addProperty("http://schema.org/normalRange", Text.of(value));
        }

        @Override
        public BloodTest.Builder addPotentialAction(Action value) {
            return (BloodTest.Builder)this.addProperty("http://schema.org/potentialAction", value);
        }

        @Override
        public BloodTest.Builder addPotentialAction(Action.Builder value) {
            return (BloodTest.Builder)this.addProperty("http://schema.org/potentialAction", value.build());
        }

        @Override
        public BloodTest.Builder addPotentialAction(String value) {
            return (BloodTest.Builder)this.addProperty("http://schema.org/potentialAction", Text.of(value));
        }

        @Override
        public BloodTest.Builder addRecognizingAuthority(Organization value) {
            return (BloodTest.Builder)this.addProperty("http://schema.org/recognizingAuthority", value);
        }

        @Override
        public BloodTest.Builder addRecognizingAuthority(Organization.Builder value) {
            return (BloodTest.Builder)this.addProperty("http://schema.org/recognizingAuthority", value.build());
        }

        @Override
        public BloodTest.Builder addRecognizingAuthority(String value) {
            return (BloodTest.Builder)this.addProperty("http://schema.org/recognizingAuthority", Text.of(value));
        }

        @Override
        public BloodTest.Builder addRelevantSpecialty(MedicalSpecialty value) {
            return (BloodTest.Builder)this.addProperty("http://schema.org/relevantSpecialty", value);
        }

        @Override
        public BloodTest.Builder addRelevantSpecialty(String value) {
            return (BloodTest.Builder)this.addProperty("http://schema.org/relevantSpecialty", Text.of(value));
        }

        @Override
        public BloodTest.Builder addSameAs(URL value) {
            return (BloodTest.Builder)this.addProperty("http://schema.org/sameAs", value);
        }

        @Override
        public BloodTest.Builder addSameAs(String value) {
            return (BloodTest.Builder)this.addProperty("http://schema.org/sameAs", Text.of(value));
        }

        @Override
        public BloodTest.Builder addSignDetected(MedicalSign value) {
            return (BloodTest.Builder)this.addProperty("http://schema.org/signDetected", value);
        }

        @Override
        public BloodTest.Builder addSignDetected(MedicalSign.Builder value) {
            return (BloodTest.Builder)this.addProperty("http://schema.org/signDetected", value.build());
        }

        @Override
        public BloodTest.Builder addSignDetected(String value) {
            return (BloodTest.Builder)this.addProperty("http://schema.org/signDetected", Text.of(value));
        }

        @Override
        public BloodTest.Builder addStudy(MedicalStudy value) {
            return (BloodTest.Builder)this.addProperty("http://schema.org/study", value);
        }

        @Override
        public BloodTest.Builder addStudy(MedicalStudy.Builder value) {
            return (BloodTest.Builder)this.addProperty("http://schema.org/study", value.build());
        }

        @Override
        public BloodTest.Builder addStudy(String value) {
            return (BloodTest.Builder)this.addProperty("http://schema.org/study", Text.of(value));
        }

        @Override
        public BloodTest.Builder addUrl(URL value) {
            return (BloodTest.Builder)this.addProperty("http://schema.org/url", value);
        }

        @Override
        public BloodTest.Builder addUrl(String value) {
            return (BloodTest.Builder)this.addProperty("http://schema.org/url", Text.of(value));
        }

        @Override
        public BloodTest.Builder addUsedToDiagnose(MedicalCondition value) {
            return (BloodTest.Builder)this.addProperty("http://schema.org/usedToDiagnose", value);
        }

        @Override
        public BloodTest.Builder addUsedToDiagnose(MedicalCondition.Builder value) {
            return (BloodTest.Builder)this.addProperty("http://schema.org/usedToDiagnose", value.build());
        }

        @Override
        public BloodTest.Builder addUsedToDiagnose(String value) {
            return (BloodTest.Builder)this.addProperty("http://schema.org/usedToDiagnose", Text.of(value));
        }

        @Override
        public BloodTest.Builder addUsesDevice(MedicalDevice value) {
            return (BloodTest.Builder)this.addProperty("http://schema.org/usesDevice", value);
        }

        @Override
        public BloodTest.Builder addUsesDevice(MedicalDevice.Builder value) {
            return (BloodTest.Builder)this.addProperty("http://schema.org/usesDevice", value.build());
        }

        @Override
        public BloodTest.Builder addUsesDevice(String value) {
            return (BloodTest.Builder)this.addProperty("http://schema.org/usesDevice", Text.of(value));
        }

        @Override
        public BloodTest.Builder addDetailedDescription(Article value) {
            return (BloodTest.Builder)this.addProperty("http://schema.googleapis.com/detailedDescription", value);
        }

        @Override
        public BloodTest.Builder addDetailedDescription(Article.Builder value) {
            return (BloodTest.Builder)this.addProperty("http://schema.googleapis.com/detailedDescription", value.build());
        }

        @Override
        public BloodTest.Builder addDetailedDescription(String value) {
            return (BloodTest.Builder)this.addProperty("http://schema.googleapis.com/detailedDescription", Text.of(value));
        }

        @Override
        public BloodTest.Builder addPopularityScore(PopularityScoreSpecification value) {
            return (BloodTest.Builder)this.addProperty("http://schema.googleapis.com/popularityScore", value);
        }

        @Override
        public BloodTest.Builder addPopularityScore(PopularityScoreSpecification.Builder value) {
            return (BloodTest.Builder)this.addProperty("http://schema.googleapis.com/popularityScore", value.build());
        }

        @Override
        public BloodTest.Builder addPopularityScore(String value) {
            return (BloodTest.Builder)this.addProperty("http://schema.googleapis.com/popularityScore", Text.of(value));
        }

        @Override
        public BloodTest build() {
            return new BloodTestImpl((Multimap<String, ValueType>)this.properties, (Multimap<String, Thing>)this.reverseMap);
        }
    }
}

