/*
 * Decompiled with CFR 0.152.
 */
package com.google.schemaorg.core;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import com.google.schemaorg.SchemaOrgTypeImpl;
import com.google.schemaorg.ValueType;
import com.google.schemaorg.core.Action;
import com.google.schemaorg.core.AggregateRating;
import com.google.schemaorg.core.AlignmentObject;
import com.google.schemaorg.core.Article;
import com.google.schemaorg.core.Audience;
import com.google.schemaorg.core.AudioObject;
import com.google.schemaorg.core.BookSeries;
import com.google.schemaorg.core.Boolean;
import com.google.schemaorg.core.Comment;
import com.google.schemaorg.core.CreativeWork;
import com.google.schemaorg.core.CreativeWorkSeriesImpl;
import com.google.schemaorg.core.Duration;
import com.google.schemaorg.core.Event;
import com.google.schemaorg.core.ImageObject;
import com.google.schemaorg.core.InteractionCounter;
import com.google.schemaorg.core.Language;
import com.google.schemaorg.core.MediaObject;
import com.google.schemaorg.core.Offer;
import com.google.schemaorg.core.Organization;
import com.google.schemaorg.core.Person;
import com.google.schemaorg.core.Place;
import com.google.schemaorg.core.PublicationEvent;
import com.google.schemaorg.core.Review;
import com.google.schemaorg.core.Thing;
import com.google.schemaorg.core.VideoObject;
import com.google.schemaorg.core.datatype.Date;
import com.google.schemaorg.core.datatype.DateTime;
import com.google.schemaorg.core.datatype.Integer;
import com.google.schemaorg.core.datatype.Number;
import com.google.schemaorg.core.datatype.Text;
import com.google.schemaorg.core.datatype.URL;
import com.google.schemaorg.goog.PopularityScoreSpecification;

public class BookSeriesImpl
extends CreativeWorkSeriesImpl
implements BookSeries {
    private static final ImmutableSet<String> PROPERTY_SET = BookSeriesImpl.initializePropertySet();

    private static ImmutableSet<String> initializePropertySet() {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        builder.add((Object)"http://schema.org/about");
        builder.add((Object)"http://schema.org/accessibilityAPI");
        builder.add((Object)"http://schema.org/accessibilityControl");
        builder.add((Object)"http://schema.org/accessibilityFeature");
        builder.add((Object)"http://schema.org/accessibilityHazard");
        builder.add((Object)"http://schema.org/accountablePerson");
        builder.add((Object)"http://schema.org/additionalType");
        builder.add((Object)"http://schema.org/aggregateRating");
        builder.add((Object)"http://schema.org/alternateName");
        builder.add((Object)"http://schema.org/alternativeHeadline");
        builder.add((Object)"http://schema.org/associatedMedia");
        builder.add((Object)"http://schema.org/audience");
        builder.add((Object)"http://schema.org/audio");
        builder.add((Object)"http://schema.org/author");
        builder.add((Object)"http://schema.org/award");
        builder.add((Object)"http://schema.org/awards");
        builder.add((Object)"http://schema.org/character");
        builder.add((Object)"http://schema.org/citation");
        builder.add((Object)"http://schema.org/comment");
        builder.add((Object)"http://schema.org/commentCount");
        builder.add((Object)"http://schema.org/contentLocation");
        builder.add((Object)"http://schema.org/contentRating");
        builder.add((Object)"http://schema.org/contributor");
        builder.add((Object)"http://schema.org/copyrightHolder");
        builder.add((Object)"http://schema.org/copyrightYear");
        builder.add((Object)"http://schema.org/creator");
        builder.add((Object)"http://schema.org/dateCreated");
        builder.add((Object)"http://schema.org/dateModified");
        builder.add((Object)"http://schema.org/datePublished");
        builder.add((Object)"http://schema.org/description");
        builder.add((Object)"http://schema.org/discussionUrl");
        builder.add((Object)"http://schema.org/editor");
        builder.add((Object)"http://schema.org/educationalAlignment");
        builder.add((Object)"http://schema.org/educationalUse");
        builder.add((Object)"http://schema.org/encoding");
        builder.add((Object)"http://schema.org/encodings");
        builder.add((Object)"http://schema.org/endDate");
        builder.add((Object)"http://schema.org/exampleOfWork");
        builder.add((Object)"http://schema.org/fileFormat");
        builder.add((Object)"http://schema.org/genre");
        builder.add((Object)"http://schema.org/hasPart");
        builder.add((Object)"http://schema.org/headline");
        builder.add((Object)"http://schema.org/image");
        builder.add((Object)"http://schema.org/inLanguage");
        builder.add((Object)"http://schema.org/interactionStatistic");
        builder.add((Object)"http://schema.org/interactivityType");
        builder.add((Object)"http://schema.org/isBasedOnUrl");
        builder.add((Object)"http://schema.org/isFamilyFriendly");
        builder.add((Object)"http://schema.org/isPartOf");
        builder.add((Object)"http://schema.org/keywords");
        builder.add((Object)"http://schema.org/learningResourceType");
        builder.add((Object)"http://schema.org/license");
        builder.add((Object)"http://schema.org/locationCreated");
        builder.add((Object)"http://schema.org/mainEntity");
        builder.add((Object)"http://schema.org/mainEntityOfPage");
        builder.add((Object)"http://schema.org/mentions");
        builder.add((Object)"http://schema.org/name");
        builder.add((Object)"http://schema.org/offers");
        builder.add((Object)"http://schema.org/position");
        builder.add((Object)"http://schema.org/potentialAction");
        builder.add((Object)"http://schema.org/producer");
        builder.add((Object)"http://schema.org/provider");
        builder.add((Object)"http://schema.org/publication");
        builder.add((Object)"http://schema.org/publisher");
        builder.add((Object)"http://schema.org/publishingPrinciples");
        builder.add((Object)"http://schema.org/recordedAt");
        builder.add((Object)"http://schema.org/releasedEvent");
        builder.add((Object)"http://schema.org/review");
        builder.add((Object)"http://schema.org/reviews");
        builder.add((Object)"http://schema.org/sameAs");
        builder.add((Object)"http://schema.org/schemaVersion");
        builder.add((Object)"http://schema.org/sourceOrganization");
        builder.add((Object)"http://schema.org/startDate");
        builder.add((Object)"http://schema.org/text");
        builder.add((Object)"http://schema.org/thumbnailUrl");
        builder.add((Object)"http://schema.org/timeRequired");
        builder.add((Object)"http://schema.org/translator");
        builder.add((Object)"http://schema.org/typicalAgeRange");
        builder.add((Object)"http://schema.org/url");
        builder.add((Object)"http://schema.org/version");
        builder.add((Object)"http://schema.org/video");
        builder.add((Object)"http://schema.org/workExample");
        builder.add((Object)"http://schema.googleapis.com/detailedDescription");
        builder.add((Object)"http://schema.googleapis.com/popularityScore");
        return builder.build();
    }

    public BookSeriesImpl(Multimap<String, ValueType> properties, Multimap<String, Thing> reverseMap) {
        super(properties, reverseMap);
    }

    @Override
    public String getFullTypeName() {
        return "http://schema.org/BookSeries";
    }

    @Override
    public boolean includesProperty(String property) {
        return PROPERTY_SET.contains((Object)("http://schema.org/" + property)) || PROPERTY_SET.contains((Object)("http://schema.googleapis.com/" + property)) || PROPERTY_SET.contains((Object)property);
    }

    static final class BuilderImpl
    extends SchemaOrgTypeImpl.BuilderImpl<BookSeries.Builder>
    implements BookSeries.Builder {
        BuilderImpl() {
        }

        @Override
        public BookSeries.Builder addAbout(Thing value) {
            return (BookSeries.Builder)this.addProperty("http://schema.org/about", value);
        }

        @Override
        public BookSeries.Builder addAbout(Thing.Builder value) {
            return (BookSeries.Builder)this.addProperty("http://schema.org/about", value.build());
        }

        @Override
        public BookSeries.Builder addAbout(String value) {
            return (BookSeries.Builder)this.addProperty("http://schema.org/about", Text.of(value));
        }

        @Override
        public BookSeries.Builder addAccessibilityAPI(Text value) {
            return (BookSeries.Builder)this.addProperty("http://schema.org/accessibilityAPI", value);
        }

        @Override
        public BookSeries.Builder addAccessibilityAPI(String value) {
            return (BookSeries.Builder)this.addProperty("http://schema.org/accessibilityAPI", Text.of(value));
        }

        @Override
        public BookSeries.Builder addAccessibilityControl(Text value) {
            return (BookSeries.Builder)this.addProperty("http://schema.org/accessibilityControl", value);
        }

        @Override
        public BookSeries.Builder addAccessibilityControl(String value) {
            return (BookSeries.Builder)this.addProperty("http://schema.org/accessibilityControl", Text.of(value));
        }

        @Override
        public BookSeries.Builder addAccessibilityFeature(Text value) {
            return (BookSeries.Builder)this.addProperty("http://schema.org/accessibilityFeature", value);
        }

        @Override
        public BookSeries.Builder addAccessibilityFeature(String value) {
            return (BookSeries.Builder)this.addProperty("http://schema.org/accessibilityFeature", Text.of(value));
        }

        @Override
        public BookSeries.Builder addAccessibilityHazard(Text value) {
            return (BookSeries.Builder)this.addProperty("http://schema.org/accessibilityHazard", value);
        }

        @Override
        public BookSeries.Builder addAccessibilityHazard(String value) {
            return (BookSeries.Builder)this.addProperty("http://schema.org/accessibilityHazard", Text.of(value));
        }

        @Override
        public BookSeries.Builder addAccountablePerson(Person value) {
            return (BookSeries.Builder)this.addProperty("http://schema.org/accountablePerson", value);
        }

        @Override
        public BookSeries.Builder addAccountablePerson(Person.Builder value) {
            return (BookSeries.Builder)this.addProperty("http://schema.org/accountablePerson", value.build());
        }

        @Override
        public BookSeries.Builder addAccountablePerson(String value) {
            return (BookSeries.Builder)this.addProperty("http://schema.org/accountablePerson", Text.of(value));
        }

        @Override
        public BookSeries.Builder addAdditionalType(URL value) {
            return (BookSeries.Builder)this.addProperty("http://schema.org/additionalType", value);
        }

        @Override
        public BookSeries.Builder addAdditionalType(String value) {
            return (BookSeries.Builder)this.addProperty("http://schema.org/additionalType", Text.of(value));
        }

        @Override
        public BookSeries.Builder addAggregateRating(AggregateRating value) {
            return (BookSeries.Builder)this.addProperty("http://schema.org/aggregateRating", value);
        }

        @Override
        public BookSeries.Builder addAggregateRating(AggregateRating.Builder value) {
            return (BookSeries.Builder)this.addProperty("http://schema.org/aggregateRating", value.build());
        }

        @Override
        public BookSeries.Builder addAggregateRating(String value) {
            return (BookSeries.Builder)this.addProperty("http://schema.org/aggregateRating", Text.of(value));
        }

        @Override
        public BookSeries.Builder addAlternateName(Text value) {
            return (BookSeries.Builder)this.addProperty("http://schema.org/alternateName", value);
        }

        @Override
        public BookSeries.Builder addAlternateName(String value) {
            return (BookSeries.Builder)this.addProperty("http://schema.org/alternateName", Text.of(value));
        }

        @Override
        public BookSeries.Builder addAlternativeHeadline(Text value) {
            return (BookSeries.Builder)this.addProperty("http://schema.org/alternativeHeadline", value);
        }

        @Override
        public BookSeries.Builder addAlternativeHeadline(String value) {
            return (BookSeries.Builder)this.addProperty("http://schema.org/alternativeHeadline", Text.of(value));
        }

        @Override
        public BookSeries.Builder addAssociatedMedia(MediaObject value) {
            return (BookSeries.Builder)this.addProperty("http://schema.org/associatedMedia", value);
        }

        @Override
        public BookSeries.Builder addAssociatedMedia(MediaObject.Builder value) {
            return (BookSeries.Builder)this.addProperty("http://schema.org/associatedMedia", value.build());
        }

        @Override
        public BookSeries.Builder addAssociatedMedia(String value) {
            return (BookSeries.Builder)this.addProperty("http://schema.org/associatedMedia", Text.of(value));
        }

        @Override
        public BookSeries.Builder addAudience(Audience value) {
            return (BookSeries.Builder)this.addProperty("http://schema.org/audience", value);
        }

        @Override
        public BookSeries.Builder addAudience(Audience.Builder value) {
            return (BookSeries.Builder)this.addProperty("http://schema.org/audience", value.build());
        }

        @Override
        public BookSeries.Builder addAudience(String value) {
            return (BookSeries.Builder)this.addProperty("http://schema.org/audience", Text.of(value));
        }

        @Override
        public BookSeries.Builder addAudio(AudioObject value) {
            return (BookSeries.Builder)this.addProperty("http://schema.org/audio", value);
        }

        @Override
        public BookSeries.Builder addAudio(AudioObject.Builder value) {
            return (BookSeries.Builder)this.addProperty("http://schema.org/audio", value.build());
        }

        @Override
        public BookSeries.Builder addAudio(String value) {
            return (BookSeries.Builder)this.addProperty("http://schema.org/audio", Text.of(value));
        }

        @Override
        public BookSeries.Builder addAuthor(Organization value) {
            return (BookSeries.Builder)this.addProperty("http://schema.org/author", value);
        }

        @Override
        public BookSeries.Builder addAuthor(Organization.Builder value) {
            return (BookSeries.Builder)this.addProperty("http://schema.org/author", value.build());
        }

        @Override
        public BookSeries.Builder addAuthor(Person value) {
            return (BookSeries.Builder)this.addProperty("http://schema.org/author", value);
        }

        @Override
        public BookSeries.Builder addAuthor(Person.Builder value) {
            return (BookSeries.Builder)this.addProperty("http://schema.org/author", value.build());
        }

        @Override
        public BookSeries.Builder addAuthor(String value) {
            return (BookSeries.Builder)this.addProperty("http://schema.org/author", Text.of(value));
        }

        @Override
        public BookSeries.Builder addAward(Text value) {
            return (BookSeries.Builder)this.addProperty("http://schema.org/award", value);
        }

        @Override
        public BookSeries.Builder addAward(String value) {
            return (BookSeries.Builder)this.addProperty("http://schema.org/award", Text.of(value));
        }

        @Override
        public BookSeries.Builder addAwards(Text value) {
            return (BookSeries.Builder)this.addProperty("http://schema.org/awards", value);
        }

        @Override
        public BookSeries.Builder addAwards(String value) {
            return (BookSeries.Builder)this.addProperty("http://schema.org/awards", Text.of(value));
        }

        @Override
        public BookSeries.Builder addCharacter(Person value) {
            return (BookSeries.Builder)this.addProperty("http://schema.org/character", value);
        }

        @Override
        public BookSeries.Builder addCharacter(Person.Builder value) {
            return (BookSeries.Builder)this.addProperty("http://schema.org/character", value.build());
        }

        @Override
        public BookSeries.Builder addCharacter(String value) {
            return (BookSeries.Builder)this.addProperty("http://schema.org/character", Text.of(value));
        }

        @Override
        public BookSeries.Builder addCitation(CreativeWork value) {
            return (BookSeries.Builder)this.addProperty("http://schema.org/citation", value);
        }

        @Override
        public BookSeries.Builder addCitation(CreativeWork.Builder value) {
            return (BookSeries.Builder)this.addProperty("http://schema.org/citation", value.build());
        }

        @Override
        public BookSeries.Builder addCitation(Text value) {
            return (BookSeries.Builder)this.addProperty("http://schema.org/citation", value);
        }

        @Override
        public BookSeries.Builder addCitation(String value) {
            return (BookSeries.Builder)this.addProperty("http://schema.org/citation", Text.of(value));
        }

        @Override
        public BookSeries.Builder addComment(Comment value) {
            return (BookSeries.Builder)this.addProperty("http://schema.org/comment", value);
        }

        @Override
        public BookSeries.Builder addComment(Comment.Builder value) {
            return (BookSeries.Builder)this.addProperty("http://schema.org/comment", value.build());
        }

        @Override
        public BookSeries.Builder addComment(String value) {
            return (BookSeries.Builder)this.addProperty("http://schema.org/comment", Text.of(value));
        }

        @Override
        public BookSeries.Builder addCommentCount(Integer value) {
            return (BookSeries.Builder)this.addProperty("http://schema.org/commentCount", value);
        }

        @Override
        public BookSeries.Builder addCommentCount(String value) {
            return (BookSeries.Builder)this.addProperty("http://schema.org/commentCount", Text.of(value));
        }

        @Override
        public BookSeries.Builder addContentLocation(Place value) {
            return (BookSeries.Builder)this.addProperty("http://schema.org/contentLocation", value);
        }

        @Override
        public BookSeries.Builder addContentLocation(Place.Builder value) {
            return (BookSeries.Builder)this.addProperty("http://schema.org/contentLocation", value.build());
        }

        @Override
        public BookSeries.Builder addContentLocation(String value) {
            return (BookSeries.Builder)this.addProperty("http://schema.org/contentLocation", Text.of(value));
        }

        @Override
        public BookSeries.Builder addContentRating(Text value) {
            return (BookSeries.Builder)this.addProperty("http://schema.org/contentRating", value);
        }

        @Override
        public BookSeries.Builder addContentRating(String value) {
            return (BookSeries.Builder)this.addProperty("http://schema.org/contentRating", Text.of(value));
        }

        @Override
        public BookSeries.Builder addContributor(Organization value) {
            return (BookSeries.Builder)this.addProperty("http://schema.org/contributor", value);
        }

        @Override
        public BookSeries.Builder addContributor(Organization.Builder value) {
            return (BookSeries.Builder)this.addProperty("http://schema.org/contributor", value.build());
        }

        @Override
        public BookSeries.Builder addContributor(Person value) {
            return (BookSeries.Builder)this.addProperty("http://schema.org/contributor", value);
        }

        @Override
        public BookSeries.Builder addContributor(Person.Builder value) {
            return (BookSeries.Builder)this.addProperty("http://schema.org/contributor", value.build());
        }

        @Override
        public BookSeries.Builder addContributor(String value) {
            return (BookSeries.Builder)this.addProperty("http://schema.org/contributor", Text.of(value));
        }

        @Override
        public BookSeries.Builder addCopyrightHolder(Organization value) {
            return (BookSeries.Builder)this.addProperty("http://schema.org/copyrightHolder", value);
        }

        @Override
        public BookSeries.Builder addCopyrightHolder(Organization.Builder value) {
            return (BookSeries.Builder)this.addProperty("http://schema.org/copyrightHolder", value.build());
        }

        @Override
        public BookSeries.Builder addCopyrightHolder(Person value) {
            return (BookSeries.Builder)this.addProperty("http://schema.org/copyrightHolder", value);
        }

        @Override
        public BookSeries.Builder addCopyrightHolder(Person.Builder value) {
            return (BookSeries.Builder)this.addProperty("http://schema.org/copyrightHolder", value.build());
        }

        @Override
        public BookSeries.Builder addCopyrightHolder(String value) {
            return (BookSeries.Builder)this.addProperty("http://schema.org/copyrightHolder", Text.of(value));
        }

        @Override
        public BookSeries.Builder addCopyrightYear(Number value) {
            return (BookSeries.Builder)this.addProperty("http://schema.org/copyrightYear", value);
        }

        @Override
        public BookSeries.Builder addCopyrightYear(String value) {
            return (BookSeries.Builder)this.addProperty("http://schema.org/copyrightYear", Text.of(value));
        }

        @Override
        public BookSeries.Builder addCreator(Organization value) {
            return (BookSeries.Builder)this.addProperty("http://schema.org/creator", value);
        }

        @Override
        public BookSeries.Builder addCreator(Organization.Builder value) {
            return (BookSeries.Builder)this.addProperty("http://schema.org/creator", value.build());
        }

        @Override
        public BookSeries.Builder addCreator(Person value) {
            return (BookSeries.Builder)this.addProperty("http://schema.org/creator", value);
        }

        @Override
        public BookSeries.Builder addCreator(Person.Builder value) {
            return (BookSeries.Builder)this.addProperty("http://schema.org/creator", value.build());
        }

        @Override
        public BookSeries.Builder addCreator(String value) {
            return (BookSeries.Builder)this.addProperty("http://schema.org/creator", Text.of(value));
        }

        @Override
        public BookSeries.Builder addDateCreated(Date value) {
            return (BookSeries.Builder)this.addProperty("http://schema.org/dateCreated", value);
        }

        @Override
        public BookSeries.Builder addDateCreated(DateTime value) {
            return (BookSeries.Builder)this.addProperty("http://schema.org/dateCreated", value);
        }

        @Override
        public BookSeries.Builder addDateCreated(String value) {
            return (BookSeries.Builder)this.addProperty("http://schema.org/dateCreated", Text.of(value));
        }

        @Override
        public BookSeries.Builder addDateModified(Date value) {
            return (BookSeries.Builder)this.addProperty("http://schema.org/dateModified", value);
        }

        @Override
        public BookSeries.Builder addDateModified(DateTime value) {
            return (BookSeries.Builder)this.addProperty("http://schema.org/dateModified", value);
        }

        @Override
        public BookSeries.Builder addDateModified(String value) {
            return (BookSeries.Builder)this.addProperty("http://schema.org/dateModified", Text.of(value));
        }

        @Override
        public BookSeries.Builder addDatePublished(Date value) {
            return (BookSeries.Builder)this.addProperty("http://schema.org/datePublished", value);
        }

        @Override
        public BookSeries.Builder addDatePublished(String value) {
            return (BookSeries.Builder)this.addProperty("http://schema.org/datePublished", Text.of(value));
        }

        @Override
        public BookSeries.Builder addDescription(Text value) {
            return (BookSeries.Builder)this.addProperty("http://schema.org/description", value);
        }

        @Override
        public BookSeries.Builder addDescription(String value) {
            return (BookSeries.Builder)this.addProperty("http://schema.org/description", Text.of(value));
        }

        @Override
        public BookSeries.Builder addDiscussionUrl(URL value) {
            return (BookSeries.Builder)this.addProperty("http://schema.org/discussionUrl", value);
        }

        @Override
        public BookSeries.Builder addDiscussionUrl(String value) {
            return (BookSeries.Builder)this.addProperty("http://schema.org/discussionUrl", Text.of(value));
        }

        @Override
        public BookSeries.Builder addEditor(Person value) {
            return (BookSeries.Builder)this.addProperty("http://schema.org/editor", value);
        }

        @Override
        public BookSeries.Builder addEditor(Person.Builder value) {
            return (BookSeries.Builder)this.addProperty("http://schema.org/editor", value.build());
        }

        @Override
        public BookSeries.Builder addEditor(String value) {
            return (BookSeries.Builder)this.addProperty("http://schema.org/editor", Text.of(value));
        }

        @Override
        public BookSeries.Builder addEducationalAlignment(AlignmentObject value) {
            return (BookSeries.Builder)this.addProperty("http://schema.org/educationalAlignment", value);
        }

        @Override
        public BookSeries.Builder addEducationalAlignment(AlignmentObject.Builder value) {
            return (BookSeries.Builder)this.addProperty("http://schema.org/educationalAlignment", value.build());
        }

        @Override
        public BookSeries.Builder addEducationalAlignment(String value) {
            return (BookSeries.Builder)this.addProperty("http://schema.org/educationalAlignment", Text.of(value));
        }

        @Override
        public BookSeries.Builder addEducationalUse(Text value) {
            return (BookSeries.Builder)this.addProperty("http://schema.org/educationalUse", value);
        }

        @Override
        public BookSeries.Builder addEducationalUse(String value) {
            return (BookSeries.Builder)this.addProperty("http://schema.org/educationalUse", Text.of(value));
        }

        @Override
        public BookSeries.Builder addEncoding(MediaObject value) {
            return (BookSeries.Builder)this.addProperty("http://schema.org/encoding", value);
        }

        @Override
        public BookSeries.Builder addEncoding(MediaObject.Builder value) {
            return (BookSeries.Builder)this.addProperty("http://schema.org/encoding", value.build());
        }

        @Override
        public BookSeries.Builder addEncoding(String value) {
            return (BookSeries.Builder)this.addProperty("http://schema.org/encoding", Text.of(value));
        }

        @Override
        public BookSeries.Builder addEncodings(MediaObject value) {
            return (BookSeries.Builder)this.addProperty("http://schema.org/encodings", value);
        }

        @Override
        public BookSeries.Builder addEncodings(MediaObject.Builder value) {
            return (BookSeries.Builder)this.addProperty("http://schema.org/encodings", value.build());
        }

        @Override
        public BookSeries.Builder addEncodings(String value) {
            return (BookSeries.Builder)this.addProperty("http://schema.org/encodings", Text.of(value));
        }

        @Override
        public BookSeries.Builder addEndDate(Date value) {
            return (BookSeries.Builder)this.addProperty("http://schema.org/endDate", value);
        }

        @Override
        public BookSeries.Builder addEndDate(String value) {
            return (BookSeries.Builder)this.addProperty("http://schema.org/endDate", Text.of(value));
        }

        @Override
        public BookSeries.Builder addExampleOfWork(CreativeWork value) {
            return (BookSeries.Builder)this.addProperty("http://schema.org/exampleOfWork", value);
        }

        @Override
        public BookSeries.Builder addExampleOfWork(CreativeWork.Builder value) {
            return (BookSeries.Builder)this.addProperty("http://schema.org/exampleOfWork", value.build());
        }

        @Override
        public BookSeries.Builder addExampleOfWork(String value) {
            return (BookSeries.Builder)this.addProperty("http://schema.org/exampleOfWork", Text.of(value));
        }

        @Override
        public BookSeries.Builder addFileFormat(Text value) {
            return (BookSeries.Builder)this.addProperty("http://schema.org/fileFormat", value);
        }

        @Override
        public BookSeries.Builder addFileFormat(String value) {
            return (BookSeries.Builder)this.addProperty("http://schema.org/fileFormat", Text.of(value));
        }

        @Override
        public BookSeries.Builder addGenre(Text value) {
            return (BookSeries.Builder)this.addProperty("http://schema.org/genre", value);
        }

        @Override
        public BookSeries.Builder addGenre(URL value) {
            return (BookSeries.Builder)this.addProperty("http://schema.org/genre", value);
        }

        @Override
        public BookSeries.Builder addGenre(String value) {
            return (BookSeries.Builder)this.addProperty("http://schema.org/genre", Text.of(value));
        }

        @Override
        public BookSeries.Builder addHasPart(CreativeWork value) {
            return (BookSeries.Builder)this.addProperty("http://schema.org/hasPart", value);
        }

        @Override
        public BookSeries.Builder addHasPart(CreativeWork.Builder value) {
            return (BookSeries.Builder)this.addProperty("http://schema.org/hasPart", value.build());
        }

        @Override
        public BookSeries.Builder addHasPart(String value) {
            return (BookSeries.Builder)this.addProperty("http://schema.org/hasPart", Text.of(value));
        }

        @Override
        public BookSeries.Builder addHeadline(Text value) {
            return (BookSeries.Builder)this.addProperty("http://schema.org/headline", value);
        }

        @Override
        public BookSeries.Builder addHeadline(String value) {
            return (BookSeries.Builder)this.addProperty("http://schema.org/headline", Text.of(value));
        }

        @Override
        public BookSeries.Builder addImage(ImageObject value) {
            return (BookSeries.Builder)this.addProperty("http://schema.org/image", value);
        }

        @Override
        public BookSeries.Builder addImage(ImageObject.Builder value) {
            return (BookSeries.Builder)this.addProperty("http://schema.org/image", value.build());
        }

        @Override
        public BookSeries.Builder addImage(URL value) {
            return (BookSeries.Builder)this.addProperty("http://schema.org/image", value);
        }

        @Override
        public BookSeries.Builder addImage(String value) {
            return (BookSeries.Builder)this.addProperty("http://schema.org/image", Text.of(value));
        }

        @Override
        public BookSeries.Builder addInLanguage(Language value) {
            return (BookSeries.Builder)this.addProperty("http://schema.org/inLanguage", value);
        }

        @Override
        public BookSeries.Builder addInLanguage(Language.Builder value) {
            return (BookSeries.Builder)this.addProperty("http://schema.org/inLanguage", value.build());
        }

        @Override
        public BookSeries.Builder addInLanguage(Text value) {
            return (BookSeries.Builder)this.addProperty("http://schema.org/inLanguage", value);
        }

        @Override
        public BookSeries.Builder addInLanguage(String value) {
            return (BookSeries.Builder)this.addProperty("http://schema.org/inLanguage", Text.of(value));
        }

        @Override
        public BookSeries.Builder addInteractionStatistic(InteractionCounter value) {
            return (BookSeries.Builder)this.addProperty("http://schema.org/interactionStatistic", value);
        }

        @Override
        public BookSeries.Builder addInteractionStatistic(InteractionCounter.Builder value) {
            return (BookSeries.Builder)this.addProperty("http://schema.org/interactionStatistic", value.build());
        }

        @Override
        public BookSeries.Builder addInteractionStatistic(String value) {
            return (BookSeries.Builder)this.addProperty("http://schema.org/interactionStatistic", Text.of(value));
        }

        @Override
        public BookSeries.Builder addInteractivityType(Text value) {
            return (BookSeries.Builder)this.addProperty("http://schema.org/interactivityType", value);
        }

        @Override
        public BookSeries.Builder addInteractivityType(String value) {
            return (BookSeries.Builder)this.addProperty("http://schema.org/interactivityType", Text.of(value));
        }

        @Override
        public BookSeries.Builder addIsBasedOnUrl(URL value) {
            return (BookSeries.Builder)this.addProperty("http://schema.org/isBasedOnUrl", value);
        }

        @Override
        public BookSeries.Builder addIsBasedOnUrl(String value) {
            return (BookSeries.Builder)this.addProperty("http://schema.org/isBasedOnUrl", Text.of(value));
        }

        @Override
        public BookSeries.Builder addIsFamilyFriendly(Boolean value) {
            return (BookSeries.Builder)this.addProperty("http://schema.org/isFamilyFriendly", value);
        }

        @Override
        public BookSeries.Builder addIsFamilyFriendly(String value) {
            return (BookSeries.Builder)this.addProperty("http://schema.org/isFamilyFriendly", Text.of(value));
        }

        @Override
        public BookSeries.Builder addIsPartOf(CreativeWork value) {
            return (BookSeries.Builder)this.addProperty("http://schema.org/isPartOf", value);
        }

        @Override
        public BookSeries.Builder addIsPartOf(CreativeWork.Builder value) {
            return (BookSeries.Builder)this.addProperty("http://schema.org/isPartOf", value.build());
        }

        @Override
        public BookSeries.Builder addIsPartOf(String value) {
            return (BookSeries.Builder)this.addProperty("http://schema.org/isPartOf", Text.of(value));
        }

        @Override
        public BookSeries.Builder addKeywords(Text value) {
            return (BookSeries.Builder)this.addProperty("http://schema.org/keywords", value);
        }

        @Override
        public BookSeries.Builder addKeywords(String value) {
            return (BookSeries.Builder)this.addProperty("http://schema.org/keywords", Text.of(value));
        }

        @Override
        public BookSeries.Builder addLearningResourceType(Text value) {
            return (BookSeries.Builder)this.addProperty("http://schema.org/learningResourceType", value);
        }

        @Override
        public BookSeries.Builder addLearningResourceType(String value) {
            return (BookSeries.Builder)this.addProperty("http://schema.org/learningResourceType", Text.of(value));
        }

        @Override
        public BookSeries.Builder addLicense(CreativeWork value) {
            return (BookSeries.Builder)this.addProperty("http://schema.org/license", value);
        }

        @Override
        public BookSeries.Builder addLicense(CreativeWork.Builder value) {
            return (BookSeries.Builder)this.addProperty("http://schema.org/license", value.build());
        }

        @Override
        public BookSeries.Builder addLicense(URL value) {
            return (BookSeries.Builder)this.addProperty("http://schema.org/license", value);
        }

        @Override
        public BookSeries.Builder addLicense(String value) {
            return (BookSeries.Builder)this.addProperty("http://schema.org/license", Text.of(value));
        }

        @Override
        public BookSeries.Builder addLocationCreated(Place value) {
            return (BookSeries.Builder)this.addProperty("http://schema.org/locationCreated", value);
        }

        @Override
        public BookSeries.Builder addLocationCreated(Place.Builder value) {
            return (BookSeries.Builder)this.addProperty("http://schema.org/locationCreated", value.build());
        }

        @Override
        public BookSeries.Builder addLocationCreated(String value) {
            return (BookSeries.Builder)this.addProperty("http://schema.org/locationCreated", Text.of(value));
        }

        @Override
        public BookSeries.Builder addMainEntity(Thing value) {
            return (BookSeries.Builder)this.addProperty("http://schema.org/mainEntity", value);
        }

        @Override
        public BookSeries.Builder addMainEntity(Thing.Builder value) {
            return (BookSeries.Builder)this.addProperty("http://schema.org/mainEntity", value.build());
        }

        @Override
        public BookSeries.Builder addMainEntity(String value) {
            return (BookSeries.Builder)this.addProperty("http://schema.org/mainEntity", Text.of(value));
        }

        @Override
        public BookSeries.Builder addMainEntityOfPage(CreativeWork value) {
            return (BookSeries.Builder)this.addProperty("http://schema.org/mainEntityOfPage", value);
        }

        @Override
        public BookSeries.Builder addMainEntityOfPage(CreativeWork.Builder value) {
            return (BookSeries.Builder)this.addProperty("http://schema.org/mainEntityOfPage", value.build());
        }

        @Override
        public BookSeries.Builder addMainEntityOfPage(URL value) {
            return (BookSeries.Builder)this.addProperty("http://schema.org/mainEntityOfPage", value);
        }

        @Override
        public BookSeries.Builder addMainEntityOfPage(String value) {
            return (BookSeries.Builder)this.addProperty("http://schema.org/mainEntityOfPage", Text.of(value));
        }

        @Override
        public BookSeries.Builder addMentions(Thing value) {
            return (BookSeries.Builder)this.addProperty("http://schema.org/mentions", value);
        }

        @Override
        public BookSeries.Builder addMentions(Thing.Builder value) {
            return (BookSeries.Builder)this.addProperty("http://schema.org/mentions", value.build());
        }

        @Override
        public BookSeries.Builder addMentions(String value) {
            return (BookSeries.Builder)this.addProperty("http://schema.org/mentions", Text.of(value));
        }

        @Override
        public BookSeries.Builder addName(Text value) {
            return (BookSeries.Builder)this.addProperty("http://schema.org/name", value);
        }

        @Override
        public BookSeries.Builder addName(String value) {
            return (BookSeries.Builder)this.addProperty("http://schema.org/name", Text.of(value));
        }

        @Override
        public BookSeries.Builder addOffers(Offer value) {
            return (BookSeries.Builder)this.addProperty("http://schema.org/offers", value);
        }

        @Override
        public BookSeries.Builder addOffers(Offer.Builder value) {
            return (BookSeries.Builder)this.addProperty("http://schema.org/offers", value.build());
        }

        @Override
        public BookSeries.Builder addOffers(String value) {
            return (BookSeries.Builder)this.addProperty("http://schema.org/offers", Text.of(value));
        }

        @Override
        public BookSeries.Builder addPosition(Integer value) {
            return (BookSeries.Builder)this.addProperty("http://schema.org/position", value);
        }

        @Override
        public BookSeries.Builder addPosition(Text value) {
            return (BookSeries.Builder)this.addProperty("http://schema.org/position", value);
        }

        @Override
        public BookSeries.Builder addPosition(String value) {
            return (BookSeries.Builder)this.addProperty("http://schema.org/position", Text.of(value));
        }

        @Override
        public BookSeries.Builder addPotentialAction(Action value) {
            return (BookSeries.Builder)this.addProperty("http://schema.org/potentialAction", value);
        }

        @Override
        public BookSeries.Builder addPotentialAction(Action.Builder value) {
            return (BookSeries.Builder)this.addProperty("http://schema.org/potentialAction", value.build());
        }

        @Override
        public BookSeries.Builder addPotentialAction(String value) {
            return (BookSeries.Builder)this.addProperty("http://schema.org/potentialAction", Text.of(value));
        }

        @Override
        public BookSeries.Builder addProducer(Organization value) {
            return (BookSeries.Builder)this.addProperty("http://schema.org/producer", value);
        }

        @Override
        public BookSeries.Builder addProducer(Organization.Builder value) {
            return (BookSeries.Builder)this.addProperty("http://schema.org/producer", value.build());
        }

        @Override
        public BookSeries.Builder addProducer(Person value) {
            return (BookSeries.Builder)this.addProperty("http://schema.org/producer", value);
        }

        @Override
        public BookSeries.Builder addProducer(Person.Builder value) {
            return (BookSeries.Builder)this.addProperty("http://schema.org/producer", value.build());
        }

        @Override
        public BookSeries.Builder addProducer(String value) {
            return (BookSeries.Builder)this.addProperty("http://schema.org/producer", Text.of(value));
        }

        @Override
        public BookSeries.Builder addProvider(Organization value) {
            return (BookSeries.Builder)this.addProperty("http://schema.org/provider", value);
        }

        @Override
        public BookSeries.Builder addProvider(Organization.Builder value) {
            return (BookSeries.Builder)this.addProperty("http://schema.org/provider", value.build());
        }

        @Override
        public BookSeries.Builder addProvider(Person value) {
            return (BookSeries.Builder)this.addProperty("http://schema.org/provider", value);
        }

        @Override
        public BookSeries.Builder addProvider(Person.Builder value) {
            return (BookSeries.Builder)this.addProperty("http://schema.org/provider", value.build());
        }

        @Override
        public BookSeries.Builder addProvider(String value) {
            return (BookSeries.Builder)this.addProperty("http://schema.org/provider", Text.of(value));
        }

        @Override
        public BookSeries.Builder addPublication(PublicationEvent value) {
            return (BookSeries.Builder)this.addProperty("http://schema.org/publication", value);
        }

        @Override
        public BookSeries.Builder addPublication(PublicationEvent.Builder value) {
            return (BookSeries.Builder)this.addProperty("http://schema.org/publication", value.build());
        }

        @Override
        public BookSeries.Builder addPublication(String value) {
            return (BookSeries.Builder)this.addProperty("http://schema.org/publication", Text.of(value));
        }

        @Override
        public BookSeries.Builder addPublisher(Organization value) {
            return (BookSeries.Builder)this.addProperty("http://schema.org/publisher", value);
        }

        @Override
        public BookSeries.Builder addPublisher(Organization.Builder value) {
            return (BookSeries.Builder)this.addProperty("http://schema.org/publisher", value.build());
        }

        @Override
        public BookSeries.Builder addPublisher(Person value) {
            return (BookSeries.Builder)this.addProperty("http://schema.org/publisher", value);
        }

        @Override
        public BookSeries.Builder addPublisher(Person.Builder value) {
            return (BookSeries.Builder)this.addProperty("http://schema.org/publisher", value.build());
        }

        @Override
        public BookSeries.Builder addPublisher(String value) {
            return (BookSeries.Builder)this.addProperty("http://schema.org/publisher", Text.of(value));
        }

        @Override
        public BookSeries.Builder addPublishingPrinciples(URL value) {
            return (BookSeries.Builder)this.addProperty("http://schema.org/publishingPrinciples", value);
        }

        @Override
        public BookSeries.Builder addPublishingPrinciples(String value) {
            return (BookSeries.Builder)this.addProperty("http://schema.org/publishingPrinciples", Text.of(value));
        }

        @Override
        public BookSeries.Builder addRecordedAt(Event value) {
            return (BookSeries.Builder)this.addProperty("http://schema.org/recordedAt", value);
        }

        @Override
        public BookSeries.Builder addRecordedAt(Event.Builder value) {
            return (BookSeries.Builder)this.addProperty("http://schema.org/recordedAt", value.build());
        }

        @Override
        public BookSeries.Builder addRecordedAt(String value) {
            return (BookSeries.Builder)this.addProperty("http://schema.org/recordedAt", Text.of(value));
        }

        @Override
        public BookSeries.Builder addReleasedEvent(PublicationEvent value) {
            return (BookSeries.Builder)this.addProperty("http://schema.org/releasedEvent", value);
        }

        @Override
        public BookSeries.Builder addReleasedEvent(PublicationEvent.Builder value) {
            return (BookSeries.Builder)this.addProperty("http://schema.org/releasedEvent", value.build());
        }

        @Override
        public BookSeries.Builder addReleasedEvent(String value) {
            return (BookSeries.Builder)this.addProperty("http://schema.org/releasedEvent", Text.of(value));
        }

        @Override
        public BookSeries.Builder addReview(Review value) {
            return (BookSeries.Builder)this.addProperty("http://schema.org/review", value);
        }

        @Override
        public BookSeries.Builder addReview(Review.Builder value) {
            return (BookSeries.Builder)this.addProperty("http://schema.org/review", value.build());
        }

        @Override
        public BookSeries.Builder addReview(String value) {
            return (BookSeries.Builder)this.addProperty("http://schema.org/review", Text.of(value));
        }

        @Override
        public BookSeries.Builder addReviews(Review value) {
            return (BookSeries.Builder)this.addProperty("http://schema.org/reviews", value);
        }

        @Override
        public BookSeries.Builder addReviews(Review.Builder value) {
            return (BookSeries.Builder)this.addProperty("http://schema.org/reviews", value.build());
        }

        @Override
        public BookSeries.Builder addReviews(String value) {
            return (BookSeries.Builder)this.addProperty("http://schema.org/reviews", Text.of(value));
        }

        @Override
        public BookSeries.Builder addSameAs(URL value) {
            return (BookSeries.Builder)this.addProperty("http://schema.org/sameAs", value);
        }

        @Override
        public BookSeries.Builder addSameAs(String value) {
            return (BookSeries.Builder)this.addProperty("http://schema.org/sameAs", Text.of(value));
        }

        @Override
        public BookSeries.Builder addSchemaVersion(Text value) {
            return (BookSeries.Builder)this.addProperty("http://schema.org/schemaVersion", value);
        }

        @Override
        public BookSeries.Builder addSchemaVersion(URL value) {
            return (BookSeries.Builder)this.addProperty("http://schema.org/schemaVersion", value);
        }

        @Override
        public BookSeries.Builder addSchemaVersion(String value) {
            return (BookSeries.Builder)this.addProperty("http://schema.org/schemaVersion", Text.of(value));
        }

        @Override
        public BookSeries.Builder addSourceOrganization(Organization value) {
            return (BookSeries.Builder)this.addProperty("http://schema.org/sourceOrganization", value);
        }

        @Override
        public BookSeries.Builder addSourceOrganization(Organization.Builder value) {
            return (BookSeries.Builder)this.addProperty("http://schema.org/sourceOrganization", value.build());
        }

        @Override
        public BookSeries.Builder addSourceOrganization(String value) {
            return (BookSeries.Builder)this.addProperty("http://schema.org/sourceOrganization", Text.of(value));
        }

        @Override
        public BookSeries.Builder addStartDate(Date value) {
            return (BookSeries.Builder)this.addProperty("http://schema.org/startDate", value);
        }

        @Override
        public BookSeries.Builder addStartDate(String value) {
            return (BookSeries.Builder)this.addProperty("http://schema.org/startDate", Text.of(value));
        }

        @Override
        public BookSeries.Builder addText(Text value) {
            return (BookSeries.Builder)this.addProperty("http://schema.org/text", value);
        }

        @Override
        public BookSeries.Builder addText(String value) {
            return (BookSeries.Builder)this.addProperty("http://schema.org/text", Text.of(value));
        }

        @Override
        public BookSeries.Builder addThumbnailUrl(URL value) {
            return (BookSeries.Builder)this.addProperty("http://schema.org/thumbnailUrl", value);
        }

        @Override
        public BookSeries.Builder addThumbnailUrl(String value) {
            return (BookSeries.Builder)this.addProperty("http://schema.org/thumbnailUrl", Text.of(value));
        }

        @Override
        public BookSeries.Builder addTimeRequired(Duration value) {
            return (BookSeries.Builder)this.addProperty("http://schema.org/timeRequired", value);
        }

        @Override
        public BookSeries.Builder addTimeRequired(Duration.Builder value) {
            return (BookSeries.Builder)this.addProperty("http://schema.org/timeRequired", value.build());
        }

        @Override
        public BookSeries.Builder addTimeRequired(String value) {
            return (BookSeries.Builder)this.addProperty("http://schema.org/timeRequired", Text.of(value));
        }

        @Override
        public BookSeries.Builder addTranslator(Organization value) {
            return (BookSeries.Builder)this.addProperty("http://schema.org/translator", value);
        }

        @Override
        public BookSeries.Builder addTranslator(Organization.Builder value) {
            return (BookSeries.Builder)this.addProperty("http://schema.org/translator", value.build());
        }

        @Override
        public BookSeries.Builder addTranslator(Person value) {
            return (BookSeries.Builder)this.addProperty("http://schema.org/translator", value);
        }

        @Override
        public BookSeries.Builder addTranslator(Person.Builder value) {
            return (BookSeries.Builder)this.addProperty("http://schema.org/translator", value.build());
        }

        @Override
        public BookSeries.Builder addTranslator(String value) {
            return (BookSeries.Builder)this.addProperty("http://schema.org/translator", Text.of(value));
        }

        @Override
        public BookSeries.Builder addTypicalAgeRange(Text value) {
            return (BookSeries.Builder)this.addProperty("http://schema.org/typicalAgeRange", value);
        }

        @Override
        public BookSeries.Builder addTypicalAgeRange(String value) {
            return (BookSeries.Builder)this.addProperty("http://schema.org/typicalAgeRange", Text.of(value));
        }

        @Override
        public BookSeries.Builder addUrl(URL value) {
            return (BookSeries.Builder)this.addProperty("http://schema.org/url", value);
        }

        @Override
        public BookSeries.Builder addUrl(String value) {
            return (BookSeries.Builder)this.addProperty("http://schema.org/url", Text.of(value));
        }

        @Override
        public BookSeries.Builder addVersion(Number value) {
            return (BookSeries.Builder)this.addProperty("http://schema.org/version", value);
        }

        @Override
        public BookSeries.Builder addVersion(String value) {
            return (BookSeries.Builder)this.addProperty("http://schema.org/version", Text.of(value));
        }

        @Override
        public BookSeries.Builder addVideo(VideoObject value) {
            return (BookSeries.Builder)this.addProperty("http://schema.org/video", value);
        }

        @Override
        public BookSeries.Builder addVideo(VideoObject.Builder value) {
            return (BookSeries.Builder)this.addProperty("http://schema.org/video", value.build());
        }

        @Override
        public BookSeries.Builder addVideo(String value) {
            return (BookSeries.Builder)this.addProperty("http://schema.org/video", Text.of(value));
        }

        @Override
        public BookSeries.Builder addWorkExample(CreativeWork value) {
            return (BookSeries.Builder)this.addProperty("http://schema.org/workExample", value);
        }

        @Override
        public BookSeries.Builder addWorkExample(CreativeWork.Builder value) {
            return (BookSeries.Builder)this.addProperty("http://schema.org/workExample", value.build());
        }

        @Override
        public BookSeries.Builder addWorkExample(String value) {
            return (BookSeries.Builder)this.addProperty("http://schema.org/workExample", Text.of(value));
        }

        @Override
        public BookSeries.Builder addDetailedDescription(Article value) {
            return (BookSeries.Builder)this.addProperty("http://schema.googleapis.com/detailedDescription", value);
        }

        @Override
        public BookSeries.Builder addDetailedDescription(Article.Builder value) {
            return (BookSeries.Builder)this.addProperty("http://schema.googleapis.com/detailedDescription", value.build());
        }

        @Override
        public BookSeries.Builder addDetailedDescription(String value) {
            return (BookSeries.Builder)this.addProperty("http://schema.googleapis.com/detailedDescription", Text.of(value));
        }

        @Override
        public BookSeries.Builder addPopularityScore(PopularityScoreSpecification value) {
            return (BookSeries.Builder)this.addProperty("http://schema.googleapis.com/popularityScore", value);
        }

        @Override
        public BookSeries.Builder addPopularityScore(PopularityScoreSpecification.Builder value) {
            return (BookSeries.Builder)this.addProperty("http://schema.googleapis.com/popularityScore", value.build());
        }

        @Override
        public BookSeries.Builder addPopularityScore(String value) {
            return (BookSeries.Builder)this.addProperty("http://schema.googleapis.com/popularityScore", Text.of(value));
        }

        @Override
        public BookSeries build() {
            return new BookSeriesImpl((Multimap<String, ValueType>)this.properties, (Multimap<String, Thing>)this.reverseMap);
        }
    }
}

