/*
 * Decompiled with CFR 0.152.
 */
package com.google.schemaorg.core;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import com.google.schemaorg.SchemaOrgType;
import com.google.schemaorg.SchemaOrgTypeImpl;
import com.google.schemaorg.ValueType;
import com.google.schemaorg.core.Action;
import com.google.schemaorg.core.AggregateRating;
import com.google.schemaorg.core.AlignmentObject;
import com.google.schemaorg.core.Article;
import com.google.schemaorg.core.Audience;
import com.google.schemaorg.core.AudioObject;
import com.google.schemaorg.core.Boolean;
import com.google.schemaorg.core.Comment;
import com.google.schemaorg.core.CreativeWork;
import com.google.schemaorg.core.CreativeWorkImpl;
import com.google.schemaorg.core.DataCatalog;
import com.google.schemaorg.core.Dataset;
import com.google.schemaorg.core.Duration;
import com.google.schemaorg.core.Event;
import com.google.schemaorg.core.ImageObject;
import com.google.schemaorg.core.InteractionCounter;
import com.google.schemaorg.core.Language;
import com.google.schemaorg.core.MediaObject;
import com.google.schemaorg.core.Offer;
import com.google.schemaorg.core.Organization;
import com.google.schemaorg.core.Person;
import com.google.schemaorg.core.Place;
import com.google.schemaorg.core.PublicationEvent;
import com.google.schemaorg.core.Review;
import com.google.schemaorg.core.Thing;
import com.google.schemaorg.core.VideoObject;
import com.google.schemaorg.core.datatype.Date;
import com.google.schemaorg.core.datatype.DateTime;
import com.google.schemaorg.core.datatype.Integer;
import com.google.schemaorg.core.datatype.Number;
import com.google.schemaorg.core.datatype.Text;
import com.google.schemaorg.core.datatype.URL;
import com.google.schemaorg.goog.PopularityScoreSpecification;

public class DataCatalogImpl
extends CreativeWorkImpl
implements DataCatalog {
    private static final ImmutableSet<String> PROPERTY_SET = DataCatalogImpl.initializePropertySet();

    private static ImmutableSet<String> initializePropertySet() {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        builder.add((Object)"http://schema.org/about");
        builder.add((Object)"http://schema.org/accessibilityAPI");
        builder.add((Object)"http://schema.org/accessibilityControl");
        builder.add((Object)"http://schema.org/accessibilityFeature");
        builder.add((Object)"http://schema.org/accessibilityHazard");
        builder.add((Object)"http://schema.org/accountablePerson");
        builder.add((Object)"http://schema.org/additionalType");
        builder.add((Object)"http://schema.org/aggregateRating");
        builder.add((Object)"http://schema.org/alternateName");
        builder.add((Object)"http://schema.org/alternativeHeadline");
        builder.add((Object)"http://schema.org/associatedMedia");
        builder.add((Object)"http://schema.org/audience");
        builder.add((Object)"http://schema.org/audio");
        builder.add((Object)"http://schema.org/author");
        builder.add((Object)"http://schema.org/award");
        builder.add((Object)"http://schema.org/awards");
        builder.add((Object)"http://schema.org/character");
        builder.add((Object)"http://schema.org/citation");
        builder.add((Object)"http://schema.org/comment");
        builder.add((Object)"http://schema.org/commentCount");
        builder.add((Object)"http://schema.org/contentLocation");
        builder.add((Object)"http://schema.org/contentRating");
        builder.add((Object)"http://schema.org/contributor");
        builder.add((Object)"http://schema.org/copyrightHolder");
        builder.add((Object)"http://schema.org/copyrightYear");
        builder.add((Object)"http://schema.org/creator");
        builder.add((Object)"http://schema.org/dataset");
        builder.add((Object)"http://schema.org/dateCreated");
        builder.add((Object)"http://schema.org/dateModified");
        builder.add((Object)"http://schema.org/datePublished");
        builder.add((Object)"http://schema.org/description");
        builder.add((Object)"http://schema.org/discussionUrl");
        builder.add((Object)"http://schema.org/editor");
        builder.add((Object)"http://schema.org/educationalAlignment");
        builder.add((Object)"http://schema.org/educationalUse");
        builder.add((Object)"http://schema.org/encoding");
        builder.add((Object)"http://schema.org/encodings");
        builder.add((Object)"http://schema.org/exampleOfWork");
        builder.add((Object)"http://schema.org/fileFormat");
        builder.add((Object)"http://schema.org/genre");
        builder.add((Object)"http://schema.org/hasPart");
        builder.add((Object)"http://schema.org/headline");
        builder.add((Object)"http://schema.org/image");
        builder.add((Object)"http://schema.org/inLanguage");
        builder.add((Object)"http://schema.org/interactionStatistic");
        builder.add((Object)"http://schema.org/interactivityType");
        builder.add((Object)"http://schema.org/isBasedOnUrl");
        builder.add((Object)"http://schema.org/isFamilyFriendly");
        builder.add((Object)"http://schema.org/isPartOf");
        builder.add((Object)"http://schema.org/keywords");
        builder.add((Object)"http://schema.org/learningResourceType");
        builder.add((Object)"http://schema.org/license");
        builder.add((Object)"http://schema.org/locationCreated");
        builder.add((Object)"http://schema.org/mainEntity");
        builder.add((Object)"http://schema.org/mainEntityOfPage");
        builder.add((Object)"http://schema.org/mentions");
        builder.add((Object)"http://schema.org/name");
        builder.add((Object)"http://schema.org/offers");
        builder.add((Object)"http://schema.org/position");
        builder.add((Object)"http://schema.org/potentialAction");
        builder.add((Object)"http://schema.org/producer");
        builder.add((Object)"http://schema.org/provider");
        builder.add((Object)"http://schema.org/publication");
        builder.add((Object)"http://schema.org/publisher");
        builder.add((Object)"http://schema.org/publishingPrinciples");
        builder.add((Object)"http://schema.org/recordedAt");
        builder.add((Object)"http://schema.org/releasedEvent");
        builder.add((Object)"http://schema.org/review");
        builder.add((Object)"http://schema.org/reviews");
        builder.add((Object)"http://schema.org/sameAs");
        builder.add((Object)"http://schema.org/schemaVersion");
        builder.add((Object)"http://schema.org/sourceOrganization");
        builder.add((Object)"http://schema.org/text");
        builder.add((Object)"http://schema.org/thumbnailUrl");
        builder.add((Object)"http://schema.org/timeRequired");
        builder.add((Object)"http://schema.org/translator");
        builder.add((Object)"http://schema.org/typicalAgeRange");
        builder.add((Object)"http://schema.org/url");
        builder.add((Object)"http://schema.org/version");
        builder.add((Object)"http://schema.org/video");
        builder.add((Object)"http://schema.org/workExample");
        builder.add((Object)"http://schema.googleapis.com/detailedDescription");
        builder.add((Object)"http://schema.googleapis.com/popularityScore");
        return builder.build();
    }

    public DataCatalogImpl(Multimap<String, ValueType> properties, Multimap<String, Thing> reverseMap) {
        super(properties, reverseMap);
    }

    @Override
    public String getFullTypeName() {
        return "http://schema.org/DataCatalog";
    }

    @Override
    public boolean includesProperty(String property) {
        return PROPERTY_SET.contains((Object)("http://schema.org/" + property)) || PROPERTY_SET.contains((Object)("http://schema.googleapis.com/" + property)) || PROPERTY_SET.contains((Object)property);
    }

    @Override
    public ImmutableList<SchemaOrgType> getDatasetList() {
        return this.getProperty("http://schema.org/dataset");
    }

    static final class BuilderImpl
    extends SchemaOrgTypeImpl.BuilderImpl<DataCatalog.Builder>
    implements DataCatalog.Builder {
        BuilderImpl() {
        }

        @Override
        public DataCatalog.Builder addAbout(Thing value) {
            return (DataCatalog.Builder)this.addProperty("http://schema.org/about", value);
        }

        @Override
        public DataCatalog.Builder addAbout(Thing.Builder value) {
            return (DataCatalog.Builder)this.addProperty("http://schema.org/about", value.build());
        }

        @Override
        public DataCatalog.Builder addAbout(String value) {
            return (DataCatalog.Builder)this.addProperty("http://schema.org/about", Text.of(value));
        }

        @Override
        public DataCatalog.Builder addAccessibilityAPI(Text value) {
            return (DataCatalog.Builder)this.addProperty("http://schema.org/accessibilityAPI", value);
        }

        @Override
        public DataCatalog.Builder addAccessibilityAPI(String value) {
            return (DataCatalog.Builder)this.addProperty("http://schema.org/accessibilityAPI", Text.of(value));
        }

        @Override
        public DataCatalog.Builder addAccessibilityControl(Text value) {
            return (DataCatalog.Builder)this.addProperty("http://schema.org/accessibilityControl", value);
        }

        @Override
        public DataCatalog.Builder addAccessibilityControl(String value) {
            return (DataCatalog.Builder)this.addProperty("http://schema.org/accessibilityControl", Text.of(value));
        }

        @Override
        public DataCatalog.Builder addAccessibilityFeature(Text value) {
            return (DataCatalog.Builder)this.addProperty("http://schema.org/accessibilityFeature", value);
        }

        @Override
        public DataCatalog.Builder addAccessibilityFeature(String value) {
            return (DataCatalog.Builder)this.addProperty("http://schema.org/accessibilityFeature", Text.of(value));
        }

        @Override
        public DataCatalog.Builder addAccessibilityHazard(Text value) {
            return (DataCatalog.Builder)this.addProperty("http://schema.org/accessibilityHazard", value);
        }

        @Override
        public DataCatalog.Builder addAccessibilityHazard(String value) {
            return (DataCatalog.Builder)this.addProperty("http://schema.org/accessibilityHazard", Text.of(value));
        }

        @Override
        public DataCatalog.Builder addAccountablePerson(Person value) {
            return (DataCatalog.Builder)this.addProperty("http://schema.org/accountablePerson", value);
        }

        @Override
        public DataCatalog.Builder addAccountablePerson(Person.Builder value) {
            return (DataCatalog.Builder)this.addProperty("http://schema.org/accountablePerson", value.build());
        }

        @Override
        public DataCatalog.Builder addAccountablePerson(String value) {
            return (DataCatalog.Builder)this.addProperty("http://schema.org/accountablePerson", Text.of(value));
        }

        @Override
        public DataCatalog.Builder addAdditionalType(URL value) {
            return (DataCatalog.Builder)this.addProperty("http://schema.org/additionalType", value);
        }

        @Override
        public DataCatalog.Builder addAdditionalType(String value) {
            return (DataCatalog.Builder)this.addProperty("http://schema.org/additionalType", Text.of(value));
        }

        @Override
        public DataCatalog.Builder addAggregateRating(AggregateRating value) {
            return (DataCatalog.Builder)this.addProperty("http://schema.org/aggregateRating", value);
        }

        @Override
        public DataCatalog.Builder addAggregateRating(AggregateRating.Builder value) {
            return (DataCatalog.Builder)this.addProperty("http://schema.org/aggregateRating", value.build());
        }

        @Override
        public DataCatalog.Builder addAggregateRating(String value) {
            return (DataCatalog.Builder)this.addProperty("http://schema.org/aggregateRating", Text.of(value));
        }

        @Override
        public DataCatalog.Builder addAlternateName(Text value) {
            return (DataCatalog.Builder)this.addProperty("http://schema.org/alternateName", value);
        }

        @Override
        public DataCatalog.Builder addAlternateName(String value) {
            return (DataCatalog.Builder)this.addProperty("http://schema.org/alternateName", Text.of(value));
        }

        @Override
        public DataCatalog.Builder addAlternativeHeadline(Text value) {
            return (DataCatalog.Builder)this.addProperty("http://schema.org/alternativeHeadline", value);
        }

        @Override
        public DataCatalog.Builder addAlternativeHeadline(String value) {
            return (DataCatalog.Builder)this.addProperty("http://schema.org/alternativeHeadline", Text.of(value));
        }

        @Override
        public DataCatalog.Builder addAssociatedMedia(MediaObject value) {
            return (DataCatalog.Builder)this.addProperty("http://schema.org/associatedMedia", value);
        }

        @Override
        public DataCatalog.Builder addAssociatedMedia(MediaObject.Builder value) {
            return (DataCatalog.Builder)this.addProperty("http://schema.org/associatedMedia", value.build());
        }

        @Override
        public DataCatalog.Builder addAssociatedMedia(String value) {
            return (DataCatalog.Builder)this.addProperty("http://schema.org/associatedMedia", Text.of(value));
        }

        @Override
        public DataCatalog.Builder addAudience(Audience value) {
            return (DataCatalog.Builder)this.addProperty("http://schema.org/audience", value);
        }

        @Override
        public DataCatalog.Builder addAudience(Audience.Builder value) {
            return (DataCatalog.Builder)this.addProperty("http://schema.org/audience", value.build());
        }

        @Override
        public DataCatalog.Builder addAudience(String value) {
            return (DataCatalog.Builder)this.addProperty("http://schema.org/audience", Text.of(value));
        }

        @Override
        public DataCatalog.Builder addAudio(AudioObject value) {
            return (DataCatalog.Builder)this.addProperty("http://schema.org/audio", value);
        }

        @Override
        public DataCatalog.Builder addAudio(AudioObject.Builder value) {
            return (DataCatalog.Builder)this.addProperty("http://schema.org/audio", value.build());
        }

        @Override
        public DataCatalog.Builder addAudio(String value) {
            return (DataCatalog.Builder)this.addProperty("http://schema.org/audio", Text.of(value));
        }

        @Override
        public DataCatalog.Builder addAuthor(Organization value) {
            return (DataCatalog.Builder)this.addProperty("http://schema.org/author", value);
        }

        @Override
        public DataCatalog.Builder addAuthor(Organization.Builder value) {
            return (DataCatalog.Builder)this.addProperty("http://schema.org/author", value.build());
        }

        @Override
        public DataCatalog.Builder addAuthor(Person value) {
            return (DataCatalog.Builder)this.addProperty("http://schema.org/author", value);
        }

        @Override
        public DataCatalog.Builder addAuthor(Person.Builder value) {
            return (DataCatalog.Builder)this.addProperty("http://schema.org/author", value.build());
        }

        @Override
        public DataCatalog.Builder addAuthor(String value) {
            return (DataCatalog.Builder)this.addProperty("http://schema.org/author", Text.of(value));
        }

        @Override
        public DataCatalog.Builder addAward(Text value) {
            return (DataCatalog.Builder)this.addProperty("http://schema.org/award", value);
        }

        @Override
        public DataCatalog.Builder addAward(String value) {
            return (DataCatalog.Builder)this.addProperty("http://schema.org/award", Text.of(value));
        }

        @Override
        public DataCatalog.Builder addAwards(Text value) {
            return (DataCatalog.Builder)this.addProperty("http://schema.org/awards", value);
        }

        @Override
        public DataCatalog.Builder addAwards(String value) {
            return (DataCatalog.Builder)this.addProperty("http://schema.org/awards", Text.of(value));
        }

        @Override
        public DataCatalog.Builder addCharacter(Person value) {
            return (DataCatalog.Builder)this.addProperty("http://schema.org/character", value);
        }

        @Override
        public DataCatalog.Builder addCharacter(Person.Builder value) {
            return (DataCatalog.Builder)this.addProperty("http://schema.org/character", value.build());
        }

        @Override
        public DataCatalog.Builder addCharacter(String value) {
            return (DataCatalog.Builder)this.addProperty("http://schema.org/character", Text.of(value));
        }

        @Override
        public DataCatalog.Builder addCitation(CreativeWork value) {
            return (DataCatalog.Builder)this.addProperty("http://schema.org/citation", value);
        }

        @Override
        public DataCatalog.Builder addCitation(CreativeWork.Builder value) {
            return (DataCatalog.Builder)this.addProperty("http://schema.org/citation", value.build());
        }

        @Override
        public DataCatalog.Builder addCitation(Text value) {
            return (DataCatalog.Builder)this.addProperty("http://schema.org/citation", value);
        }

        @Override
        public DataCatalog.Builder addCitation(String value) {
            return (DataCatalog.Builder)this.addProperty("http://schema.org/citation", Text.of(value));
        }

        @Override
        public DataCatalog.Builder addComment(Comment value) {
            return (DataCatalog.Builder)this.addProperty("http://schema.org/comment", value);
        }

        @Override
        public DataCatalog.Builder addComment(Comment.Builder value) {
            return (DataCatalog.Builder)this.addProperty("http://schema.org/comment", value.build());
        }

        @Override
        public DataCatalog.Builder addComment(String value) {
            return (DataCatalog.Builder)this.addProperty("http://schema.org/comment", Text.of(value));
        }

        @Override
        public DataCatalog.Builder addCommentCount(Integer value) {
            return (DataCatalog.Builder)this.addProperty("http://schema.org/commentCount", value);
        }

        @Override
        public DataCatalog.Builder addCommentCount(String value) {
            return (DataCatalog.Builder)this.addProperty("http://schema.org/commentCount", Text.of(value));
        }

        @Override
        public DataCatalog.Builder addContentLocation(Place value) {
            return (DataCatalog.Builder)this.addProperty("http://schema.org/contentLocation", value);
        }

        @Override
        public DataCatalog.Builder addContentLocation(Place.Builder value) {
            return (DataCatalog.Builder)this.addProperty("http://schema.org/contentLocation", value.build());
        }

        @Override
        public DataCatalog.Builder addContentLocation(String value) {
            return (DataCatalog.Builder)this.addProperty("http://schema.org/contentLocation", Text.of(value));
        }

        @Override
        public DataCatalog.Builder addContentRating(Text value) {
            return (DataCatalog.Builder)this.addProperty("http://schema.org/contentRating", value);
        }

        @Override
        public DataCatalog.Builder addContentRating(String value) {
            return (DataCatalog.Builder)this.addProperty("http://schema.org/contentRating", Text.of(value));
        }

        @Override
        public DataCatalog.Builder addContributor(Organization value) {
            return (DataCatalog.Builder)this.addProperty("http://schema.org/contributor", value);
        }

        @Override
        public DataCatalog.Builder addContributor(Organization.Builder value) {
            return (DataCatalog.Builder)this.addProperty("http://schema.org/contributor", value.build());
        }

        @Override
        public DataCatalog.Builder addContributor(Person value) {
            return (DataCatalog.Builder)this.addProperty("http://schema.org/contributor", value);
        }

        @Override
        public DataCatalog.Builder addContributor(Person.Builder value) {
            return (DataCatalog.Builder)this.addProperty("http://schema.org/contributor", value.build());
        }

        @Override
        public DataCatalog.Builder addContributor(String value) {
            return (DataCatalog.Builder)this.addProperty("http://schema.org/contributor", Text.of(value));
        }

        @Override
        public DataCatalog.Builder addCopyrightHolder(Organization value) {
            return (DataCatalog.Builder)this.addProperty("http://schema.org/copyrightHolder", value);
        }

        @Override
        public DataCatalog.Builder addCopyrightHolder(Organization.Builder value) {
            return (DataCatalog.Builder)this.addProperty("http://schema.org/copyrightHolder", value.build());
        }

        @Override
        public DataCatalog.Builder addCopyrightHolder(Person value) {
            return (DataCatalog.Builder)this.addProperty("http://schema.org/copyrightHolder", value);
        }

        @Override
        public DataCatalog.Builder addCopyrightHolder(Person.Builder value) {
            return (DataCatalog.Builder)this.addProperty("http://schema.org/copyrightHolder", value.build());
        }

        @Override
        public DataCatalog.Builder addCopyrightHolder(String value) {
            return (DataCatalog.Builder)this.addProperty("http://schema.org/copyrightHolder", Text.of(value));
        }

        @Override
        public DataCatalog.Builder addCopyrightYear(Number value) {
            return (DataCatalog.Builder)this.addProperty("http://schema.org/copyrightYear", value);
        }

        @Override
        public DataCatalog.Builder addCopyrightYear(String value) {
            return (DataCatalog.Builder)this.addProperty("http://schema.org/copyrightYear", Text.of(value));
        }

        @Override
        public DataCatalog.Builder addCreator(Organization value) {
            return (DataCatalog.Builder)this.addProperty("http://schema.org/creator", value);
        }

        @Override
        public DataCatalog.Builder addCreator(Organization.Builder value) {
            return (DataCatalog.Builder)this.addProperty("http://schema.org/creator", value.build());
        }

        @Override
        public DataCatalog.Builder addCreator(Person value) {
            return (DataCatalog.Builder)this.addProperty("http://schema.org/creator", value);
        }

        @Override
        public DataCatalog.Builder addCreator(Person.Builder value) {
            return (DataCatalog.Builder)this.addProperty("http://schema.org/creator", value.build());
        }

        @Override
        public DataCatalog.Builder addCreator(String value) {
            return (DataCatalog.Builder)this.addProperty("http://schema.org/creator", Text.of(value));
        }

        @Override
        public DataCatalog.Builder addDataset(Dataset value) {
            return (DataCatalog.Builder)this.addProperty("http://schema.org/dataset", value);
        }

        @Override
        public DataCatalog.Builder addDataset(Dataset.Builder value) {
            return (DataCatalog.Builder)this.addProperty("http://schema.org/dataset", value.build());
        }

        @Override
        public DataCatalog.Builder addDataset(String value) {
            return (DataCatalog.Builder)this.addProperty("http://schema.org/dataset", Text.of(value));
        }

        @Override
        public DataCatalog.Builder addDateCreated(Date value) {
            return (DataCatalog.Builder)this.addProperty("http://schema.org/dateCreated", value);
        }

        @Override
        public DataCatalog.Builder addDateCreated(DateTime value) {
            return (DataCatalog.Builder)this.addProperty("http://schema.org/dateCreated", value);
        }

        @Override
        public DataCatalog.Builder addDateCreated(String value) {
            return (DataCatalog.Builder)this.addProperty("http://schema.org/dateCreated", Text.of(value));
        }

        @Override
        public DataCatalog.Builder addDateModified(Date value) {
            return (DataCatalog.Builder)this.addProperty("http://schema.org/dateModified", value);
        }

        @Override
        public DataCatalog.Builder addDateModified(DateTime value) {
            return (DataCatalog.Builder)this.addProperty("http://schema.org/dateModified", value);
        }

        @Override
        public DataCatalog.Builder addDateModified(String value) {
            return (DataCatalog.Builder)this.addProperty("http://schema.org/dateModified", Text.of(value));
        }

        @Override
        public DataCatalog.Builder addDatePublished(Date value) {
            return (DataCatalog.Builder)this.addProperty("http://schema.org/datePublished", value);
        }

        @Override
        public DataCatalog.Builder addDatePublished(String value) {
            return (DataCatalog.Builder)this.addProperty("http://schema.org/datePublished", Text.of(value));
        }

        @Override
        public DataCatalog.Builder addDescription(Text value) {
            return (DataCatalog.Builder)this.addProperty("http://schema.org/description", value);
        }

        @Override
        public DataCatalog.Builder addDescription(String value) {
            return (DataCatalog.Builder)this.addProperty("http://schema.org/description", Text.of(value));
        }

        @Override
        public DataCatalog.Builder addDiscussionUrl(URL value) {
            return (DataCatalog.Builder)this.addProperty("http://schema.org/discussionUrl", value);
        }

        @Override
        public DataCatalog.Builder addDiscussionUrl(String value) {
            return (DataCatalog.Builder)this.addProperty("http://schema.org/discussionUrl", Text.of(value));
        }

        @Override
        public DataCatalog.Builder addEditor(Person value) {
            return (DataCatalog.Builder)this.addProperty("http://schema.org/editor", value);
        }

        @Override
        public DataCatalog.Builder addEditor(Person.Builder value) {
            return (DataCatalog.Builder)this.addProperty("http://schema.org/editor", value.build());
        }

        @Override
        public DataCatalog.Builder addEditor(String value) {
            return (DataCatalog.Builder)this.addProperty("http://schema.org/editor", Text.of(value));
        }

        @Override
        public DataCatalog.Builder addEducationalAlignment(AlignmentObject value) {
            return (DataCatalog.Builder)this.addProperty("http://schema.org/educationalAlignment", value);
        }

        @Override
        public DataCatalog.Builder addEducationalAlignment(AlignmentObject.Builder value) {
            return (DataCatalog.Builder)this.addProperty("http://schema.org/educationalAlignment", value.build());
        }

        @Override
        public DataCatalog.Builder addEducationalAlignment(String value) {
            return (DataCatalog.Builder)this.addProperty("http://schema.org/educationalAlignment", Text.of(value));
        }

        @Override
        public DataCatalog.Builder addEducationalUse(Text value) {
            return (DataCatalog.Builder)this.addProperty("http://schema.org/educationalUse", value);
        }

        @Override
        public DataCatalog.Builder addEducationalUse(String value) {
            return (DataCatalog.Builder)this.addProperty("http://schema.org/educationalUse", Text.of(value));
        }

        @Override
        public DataCatalog.Builder addEncoding(MediaObject value) {
            return (DataCatalog.Builder)this.addProperty("http://schema.org/encoding", value);
        }

        @Override
        public DataCatalog.Builder addEncoding(MediaObject.Builder value) {
            return (DataCatalog.Builder)this.addProperty("http://schema.org/encoding", value.build());
        }

        @Override
        public DataCatalog.Builder addEncoding(String value) {
            return (DataCatalog.Builder)this.addProperty("http://schema.org/encoding", Text.of(value));
        }

        @Override
        public DataCatalog.Builder addEncodings(MediaObject value) {
            return (DataCatalog.Builder)this.addProperty("http://schema.org/encodings", value);
        }

        @Override
        public DataCatalog.Builder addEncodings(MediaObject.Builder value) {
            return (DataCatalog.Builder)this.addProperty("http://schema.org/encodings", value.build());
        }

        @Override
        public DataCatalog.Builder addEncodings(String value) {
            return (DataCatalog.Builder)this.addProperty("http://schema.org/encodings", Text.of(value));
        }

        @Override
        public DataCatalog.Builder addExampleOfWork(CreativeWork value) {
            return (DataCatalog.Builder)this.addProperty("http://schema.org/exampleOfWork", value);
        }

        @Override
        public DataCatalog.Builder addExampleOfWork(CreativeWork.Builder value) {
            return (DataCatalog.Builder)this.addProperty("http://schema.org/exampleOfWork", value.build());
        }

        @Override
        public DataCatalog.Builder addExampleOfWork(String value) {
            return (DataCatalog.Builder)this.addProperty("http://schema.org/exampleOfWork", Text.of(value));
        }

        @Override
        public DataCatalog.Builder addFileFormat(Text value) {
            return (DataCatalog.Builder)this.addProperty("http://schema.org/fileFormat", value);
        }

        @Override
        public DataCatalog.Builder addFileFormat(String value) {
            return (DataCatalog.Builder)this.addProperty("http://schema.org/fileFormat", Text.of(value));
        }

        @Override
        public DataCatalog.Builder addGenre(Text value) {
            return (DataCatalog.Builder)this.addProperty("http://schema.org/genre", value);
        }

        @Override
        public DataCatalog.Builder addGenre(URL value) {
            return (DataCatalog.Builder)this.addProperty("http://schema.org/genre", value);
        }

        @Override
        public DataCatalog.Builder addGenre(String value) {
            return (DataCatalog.Builder)this.addProperty("http://schema.org/genre", Text.of(value));
        }

        @Override
        public DataCatalog.Builder addHasPart(CreativeWork value) {
            return (DataCatalog.Builder)this.addProperty("http://schema.org/hasPart", value);
        }

        @Override
        public DataCatalog.Builder addHasPart(CreativeWork.Builder value) {
            return (DataCatalog.Builder)this.addProperty("http://schema.org/hasPart", value.build());
        }

        @Override
        public DataCatalog.Builder addHasPart(String value) {
            return (DataCatalog.Builder)this.addProperty("http://schema.org/hasPart", Text.of(value));
        }

        @Override
        public DataCatalog.Builder addHeadline(Text value) {
            return (DataCatalog.Builder)this.addProperty("http://schema.org/headline", value);
        }

        @Override
        public DataCatalog.Builder addHeadline(String value) {
            return (DataCatalog.Builder)this.addProperty("http://schema.org/headline", Text.of(value));
        }

        @Override
        public DataCatalog.Builder addImage(ImageObject value) {
            return (DataCatalog.Builder)this.addProperty("http://schema.org/image", value);
        }

        @Override
        public DataCatalog.Builder addImage(ImageObject.Builder value) {
            return (DataCatalog.Builder)this.addProperty("http://schema.org/image", value.build());
        }

        @Override
        public DataCatalog.Builder addImage(URL value) {
            return (DataCatalog.Builder)this.addProperty("http://schema.org/image", value);
        }

        @Override
        public DataCatalog.Builder addImage(String value) {
            return (DataCatalog.Builder)this.addProperty("http://schema.org/image", Text.of(value));
        }

        @Override
        public DataCatalog.Builder addInLanguage(Language value) {
            return (DataCatalog.Builder)this.addProperty("http://schema.org/inLanguage", value);
        }

        @Override
        public DataCatalog.Builder addInLanguage(Language.Builder value) {
            return (DataCatalog.Builder)this.addProperty("http://schema.org/inLanguage", value.build());
        }

        @Override
        public DataCatalog.Builder addInLanguage(Text value) {
            return (DataCatalog.Builder)this.addProperty("http://schema.org/inLanguage", value);
        }

        @Override
        public DataCatalog.Builder addInLanguage(String value) {
            return (DataCatalog.Builder)this.addProperty("http://schema.org/inLanguage", Text.of(value));
        }

        @Override
        public DataCatalog.Builder addInteractionStatistic(InteractionCounter value) {
            return (DataCatalog.Builder)this.addProperty("http://schema.org/interactionStatistic", value);
        }

        @Override
        public DataCatalog.Builder addInteractionStatistic(InteractionCounter.Builder value) {
            return (DataCatalog.Builder)this.addProperty("http://schema.org/interactionStatistic", value.build());
        }

        @Override
        public DataCatalog.Builder addInteractionStatistic(String value) {
            return (DataCatalog.Builder)this.addProperty("http://schema.org/interactionStatistic", Text.of(value));
        }

        @Override
        public DataCatalog.Builder addInteractivityType(Text value) {
            return (DataCatalog.Builder)this.addProperty("http://schema.org/interactivityType", value);
        }

        @Override
        public DataCatalog.Builder addInteractivityType(String value) {
            return (DataCatalog.Builder)this.addProperty("http://schema.org/interactivityType", Text.of(value));
        }

        @Override
        public DataCatalog.Builder addIsBasedOnUrl(URL value) {
            return (DataCatalog.Builder)this.addProperty("http://schema.org/isBasedOnUrl", value);
        }

        @Override
        public DataCatalog.Builder addIsBasedOnUrl(String value) {
            return (DataCatalog.Builder)this.addProperty("http://schema.org/isBasedOnUrl", Text.of(value));
        }

        @Override
        public DataCatalog.Builder addIsFamilyFriendly(Boolean value) {
            return (DataCatalog.Builder)this.addProperty("http://schema.org/isFamilyFriendly", value);
        }

        @Override
        public DataCatalog.Builder addIsFamilyFriendly(String value) {
            return (DataCatalog.Builder)this.addProperty("http://schema.org/isFamilyFriendly", Text.of(value));
        }

        @Override
        public DataCatalog.Builder addIsPartOf(CreativeWork value) {
            return (DataCatalog.Builder)this.addProperty("http://schema.org/isPartOf", value);
        }

        @Override
        public DataCatalog.Builder addIsPartOf(CreativeWork.Builder value) {
            return (DataCatalog.Builder)this.addProperty("http://schema.org/isPartOf", value.build());
        }

        @Override
        public DataCatalog.Builder addIsPartOf(String value) {
            return (DataCatalog.Builder)this.addProperty("http://schema.org/isPartOf", Text.of(value));
        }

        @Override
        public DataCatalog.Builder addKeywords(Text value) {
            return (DataCatalog.Builder)this.addProperty("http://schema.org/keywords", value);
        }

        @Override
        public DataCatalog.Builder addKeywords(String value) {
            return (DataCatalog.Builder)this.addProperty("http://schema.org/keywords", Text.of(value));
        }

        @Override
        public DataCatalog.Builder addLearningResourceType(Text value) {
            return (DataCatalog.Builder)this.addProperty("http://schema.org/learningResourceType", value);
        }

        @Override
        public DataCatalog.Builder addLearningResourceType(String value) {
            return (DataCatalog.Builder)this.addProperty("http://schema.org/learningResourceType", Text.of(value));
        }

        @Override
        public DataCatalog.Builder addLicense(CreativeWork value) {
            return (DataCatalog.Builder)this.addProperty("http://schema.org/license", value);
        }

        @Override
        public DataCatalog.Builder addLicense(CreativeWork.Builder value) {
            return (DataCatalog.Builder)this.addProperty("http://schema.org/license", value.build());
        }

        @Override
        public DataCatalog.Builder addLicense(URL value) {
            return (DataCatalog.Builder)this.addProperty("http://schema.org/license", value);
        }

        @Override
        public DataCatalog.Builder addLicense(String value) {
            return (DataCatalog.Builder)this.addProperty("http://schema.org/license", Text.of(value));
        }

        @Override
        public DataCatalog.Builder addLocationCreated(Place value) {
            return (DataCatalog.Builder)this.addProperty("http://schema.org/locationCreated", value);
        }

        @Override
        public DataCatalog.Builder addLocationCreated(Place.Builder value) {
            return (DataCatalog.Builder)this.addProperty("http://schema.org/locationCreated", value.build());
        }

        @Override
        public DataCatalog.Builder addLocationCreated(String value) {
            return (DataCatalog.Builder)this.addProperty("http://schema.org/locationCreated", Text.of(value));
        }

        @Override
        public DataCatalog.Builder addMainEntity(Thing value) {
            return (DataCatalog.Builder)this.addProperty("http://schema.org/mainEntity", value);
        }

        @Override
        public DataCatalog.Builder addMainEntity(Thing.Builder value) {
            return (DataCatalog.Builder)this.addProperty("http://schema.org/mainEntity", value.build());
        }

        @Override
        public DataCatalog.Builder addMainEntity(String value) {
            return (DataCatalog.Builder)this.addProperty("http://schema.org/mainEntity", Text.of(value));
        }

        @Override
        public DataCatalog.Builder addMainEntityOfPage(CreativeWork value) {
            return (DataCatalog.Builder)this.addProperty("http://schema.org/mainEntityOfPage", value);
        }

        @Override
        public DataCatalog.Builder addMainEntityOfPage(CreativeWork.Builder value) {
            return (DataCatalog.Builder)this.addProperty("http://schema.org/mainEntityOfPage", value.build());
        }

        @Override
        public DataCatalog.Builder addMainEntityOfPage(URL value) {
            return (DataCatalog.Builder)this.addProperty("http://schema.org/mainEntityOfPage", value);
        }

        @Override
        public DataCatalog.Builder addMainEntityOfPage(String value) {
            return (DataCatalog.Builder)this.addProperty("http://schema.org/mainEntityOfPage", Text.of(value));
        }

        @Override
        public DataCatalog.Builder addMentions(Thing value) {
            return (DataCatalog.Builder)this.addProperty("http://schema.org/mentions", value);
        }

        @Override
        public DataCatalog.Builder addMentions(Thing.Builder value) {
            return (DataCatalog.Builder)this.addProperty("http://schema.org/mentions", value.build());
        }

        @Override
        public DataCatalog.Builder addMentions(String value) {
            return (DataCatalog.Builder)this.addProperty("http://schema.org/mentions", Text.of(value));
        }

        @Override
        public DataCatalog.Builder addName(Text value) {
            return (DataCatalog.Builder)this.addProperty("http://schema.org/name", value);
        }

        @Override
        public DataCatalog.Builder addName(String value) {
            return (DataCatalog.Builder)this.addProperty("http://schema.org/name", Text.of(value));
        }

        @Override
        public DataCatalog.Builder addOffers(Offer value) {
            return (DataCatalog.Builder)this.addProperty("http://schema.org/offers", value);
        }

        @Override
        public DataCatalog.Builder addOffers(Offer.Builder value) {
            return (DataCatalog.Builder)this.addProperty("http://schema.org/offers", value.build());
        }

        @Override
        public DataCatalog.Builder addOffers(String value) {
            return (DataCatalog.Builder)this.addProperty("http://schema.org/offers", Text.of(value));
        }

        @Override
        public DataCatalog.Builder addPosition(Integer value) {
            return (DataCatalog.Builder)this.addProperty("http://schema.org/position", value);
        }

        @Override
        public DataCatalog.Builder addPosition(Text value) {
            return (DataCatalog.Builder)this.addProperty("http://schema.org/position", value);
        }

        @Override
        public DataCatalog.Builder addPosition(String value) {
            return (DataCatalog.Builder)this.addProperty("http://schema.org/position", Text.of(value));
        }

        @Override
        public DataCatalog.Builder addPotentialAction(Action value) {
            return (DataCatalog.Builder)this.addProperty("http://schema.org/potentialAction", value);
        }

        @Override
        public DataCatalog.Builder addPotentialAction(Action.Builder value) {
            return (DataCatalog.Builder)this.addProperty("http://schema.org/potentialAction", value.build());
        }

        @Override
        public DataCatalog.Builder addPotentialAction(String value) {
            return (DataCatalog.Builder)this.addProperty("http://schema.org/potentialAction", Text.of(value));
        }

        @Override
        public DataCatalog.Builder addProducer(Organization value) {
            return (DataCatalog.Builder)this.addProperty("http://schema.org/producer", value);
        }

        @Override
        public DataCatalog.Builder addProducer(Organization.Builder value) {
            return (DataCatalog.Builder)this.addProperty("http://schema.org/producer", value.build());
        }

        @Override
        public DataCatalog.Builder addProducer(Person value) {
            return (DataCatalog.Builder)this.addProperty("http://schema.org/producer", value);
        }

        @Override
        public DataCatalog.Builder addProducer(Person.Builder value) {
            return (DataCatalog.Builder)this.addProperty("http://schema.org/producer", value.build());
        }

        @Override
        public DataCatalog.Builder addProducer(String value) {
            return (DataCatalog.Builder)this.addProperty("http://schema.org/producer", Text.of(value));
        }

        @Override
        public DataCatalog.Builder addProvider(Organization value) {
            return (DataCatalog.Builder)this.addProperty("http://schema.org/provider", value);
        }

        @Override
        public DataCatalog.Builder addProvider(Organization.Builder value) {
            return (DataCatalog.Builder)this.addProperty("http://schema.org/provider", value.build());
        }

        @Override
        public DataCatalog.Builder addProvider(Person value) {
            return (DataCatalog.Builder)this.addProperty("http://schema.org/provider", value);
        }

        @Override
        public DataCatalog.Builder addProvider(Person.Builder value) {
            return (DataCatalog.Builder)this.addProperty("http://schema.org/provider", value.build());
        }

        @Override
        public DataCatalog.Builder addProvider(String value) {
            return (DataCatalog.Builder)this.addProperty("http://schema.org/provider", Text.of(value));
        }

        @Override
        public DataCatalog.Builder addPublication(PublicationEvent value) {
            return (DataCatalog.Builder)this.addProperty("http://schema.org/publication", value);
        }

        @Override
        public DataCatalog.Builder addPublication(PublicationEvent.Builder value) {
            return (DataCatalog.Builder)this.addProperty("http://schema.org/publication", value.build());
        }

        @Override
        public DataCatalog.Builder addPublication(String value) {
            return (DataCatalog.Builder)this.addProperty("http://schema.org/publication", Text.of(value));
        }

        @Override
        public DataCatalog.Builder addPublisher(Organization value) {
            return (DataCatalog.Builder)this.addProperty("http://schema.org/publisher", value);
        }

        @Override
        public DataCatalog.Builder addPublisher(Organization.Builder value) {
            return (DataCatalog.Builder)this.addProperty("http://schema.org/publisher", value.build());
        }

        @Override
        public DataCatalog.Builder addPublisher(Person value) {
            return (DataCatalog.Builder)this.addProperty("http://schema.org/publisher", value);
        }

        @Override
        public DataCatalog.Builder addPublisher(Person.Builder value) {
            return (DataCatalog.Builder)this.addProperty("http://schema.org/publisher", value.build());
        }

        @Override
        public DataCatalog.Builder addPublisher(String value) {
            return (DataCatalog.Builder)this.addProperty("http://schema.org/publisher", Text.of(value));
        }

        @Override
        public DataCatalog.Builder addPublishingPrinciples(URL value) {
            return (DataCatalog.Builder)this.addProperty("http://schema.org/publishingPrinciples", value);
        }

        @Override
        public DataCatalog.Builder addPublishingPrinciples(String value) {
            return (DataCatalog.Builder)this.addProperty("http://schema.org/publishingPrinciples", Text.of(value));
        }

        @Override
        public DataCatalog.Builder addRecordedAt(Event value) {
            return (DataCatalog.Builder)this.addProperty("http://schema.org/recordedAt", value);
        }

        @Override
        public DataCatalog.Builder addRecordedAt(Event.Builder value) {
            return (DataCatalog.Builder)this.addProperty("http://schema.org/recordedAt", value.build());
        }

        @Override
        public DataCatalog.Builder addRecordedAt(String value) {
            return (DataCatalog.Builder)this.addProperty("http://schema.org/recordedAt", Text.of(value));
        }

        @Override
        public DataCatalog.Builder addReleasedEvent(PublicationEvent value) {
            return (DataCatalog.Builder)this.addProperty("http://schema.org/releasedEvent", value);
        }

        @Override
        public DataCatalog.Builder addReleasedEvent(PublicationEvent.Builder value) {
            return (DataCatalog.Builder)this.addProperty("http://schema.org/releasedEvent", value.build());
        }

        @Override
        public DataCatalog.Builder addReleasedEvent(String value) {
            return (DataCatalog.Builder)this.addProperty("http://schema.org/releasedEvent", Text.of(value));
        }

        @Override
        public DataCatalog.Builder addReview(Review value) {
            return (DataCatalog.Builder)this.addProperty("http://schema.org/review", value);
        }

        @Override
        public DataCatalog.Builder addReview(Review.Builder value) {
            return (DataCatalog.Builder)this.addProperty("http://schema.org/review", value.build());
        }

        @Override
        public DataCatalog.Builder addReview(String value) {
            return (DataCatalog.Builder)this.addProperty("http://schema.org/review", Text.of(value));
        }

        @Override
        public DataCatalog.Builder addReviews(Review value) {
            return (DataCatalog.Builder)this.addProperty("http://schema.org/reviews", value);
        }

        @Override
        public DataCatalog.Builder addReviews(Review.Builder value) {
            return (DataCatalog.Builder)this.addProperty("http://schema.org/reviews", value.build());
        }

        @Override
        public DataCatalog.Builder addReviews(String value) {
            return (DataCatalog.Builder)this.addProperty("http://schema.org/reviews", Text.of(value));
        }

        @Override
        public DataCatalog.Builder addSameAs(URL value) {
            return (DataCatalog.Builder)this.addProperty("http://schema.org/sameAs", value);
        }

        @Override
        public DataCatalog.Builder addSameAs(String value) {
            return (DataCatalog.Builder)this.addProperty("http://schema.org/sameAs", Text.of(value));
        }

        @Override
        public DataCatalog.Builder addSchemaVersion(Text value) {
            return (DataCatalog.Builder)this.addProperty("http://schema.org/schemaVersion", value);
        }

        @Override
        public DataCatalog.Builder addSchemaVersion(URL value) {
            return (DataCatalog.Builder)this.addProperty("http://schema.org/schemaVersion", value);
        }

        @Override
        public DataCatalog.Builder addSchemaVersion(String value) {
            return (DataCatalog.Builder)this.addProperty("http://schema.org/schemaVersion", Text.of(value));
        }

        @Override
        public DataCatalog.Builder addSourceOrganization(Organization value) {
            return (DataCatalog.Builder)this.addProperty("http://schema.org/sourceOrganization", value);
        }

        @Override
        public DataCatalog.Builder addSourceOrganization(Organization.Builder value) {
            return (DataCatalog.Builder)this.addProperty("http://schema.org/sourceOrganization", value.build());
        }

        @Override
        public DataCatalog.Builder addSourceOrganization(String value) {
            return (DataCatalog.Builder)this.addProperty("http://schema.org/sourceOrganization", Text.of(value));
        }

        @Override
        public DataCatalog.Builder addText(Text value) {
            return (DataCatalog.Builder)this.addProperty("http://schema.org/text", value);
        }

        @Override
        public DataCatalog.Builder addText(String value) {
            return (DataCatalog.Builder)this.addProperty("http://schema.org/text", Text.of(value));
        }

        @Override
        public DataCatalog.Builder addThumbnailUrl(URL value) {
            return (DataCatalog.Builder)this.addProperty("http://schema.org/thumbnailUrl", value);
        }

        @Override
        public DataCatalog.Builder addThumbnailUrl(String value) {
            return (DataCatalog.Builder)this.addProperty("http://schema.org/thumbnailUrl", Text.of(value));
        }

        @Override
        public DataCatalog.Builder addTimeRequired(Duration value) {
            return (DataCatalog.Builder)this.addProperty("http://schema.org/timeRequired", value);
        }

        @Override
        public DataCatalog.Builder addTimeRequired(Duration.Builder value) {
            return (DataCatalog.Builder)this.addProperty("http://schema.org/timeRequired", value.build());
        }

        @Override
        public DataCatalog.Builder addTimeRequired(String value) {
            return (DataCatalog.Builder)this.addProperty("http://schema.org/timeRequired", Text.of(value));
        }

        @Override
        public DataCatalog.Builder addTranslator(Organization value) {
            return (DataCatalog.Builder)this.addProperty("http://schema.org/translator", value);
        }

        @Override
        public DataCatalog.Builder addTranslator(Organization.Builder value) {
            return (DataCatalog.Builder)this.addProperty("http://schema.org/translator", value.build());
        }

        @Override
        public DataCatalog.Builder addTranslator(Person value) {
            return (DataCatalog.Builder)this.addProperty("http://schema.org/translator", value);
        }

        @Override
        public DataCatalog.Builder addTranslator(Person.Builder value) {
            return (DataCatalog.Builder)this.addProperty("http://schema.org/translator", value.build());
        }

        @Override
        public DataCatalog.Builder addTranslator(String value) {
            return (DataCatalog.Builder)this.addProperty("http://schema.org/translator", Text.of(value));
        }

        @Override
        public DataCatalog.Builder addTypicalAgeRange(Text value) {
            return (DataCatalog.Builder)this.addProperty("http://schema.org/typicalAgeRange", value);
        }

        @Override
        public DataCatalog.Builder addTypicalAgeRange(String value) {
            return (DataCatalog.Builder)this.addProperty("http://schema.org/typicalAgeRange", Text.of(value));
        }

        @Override
        public DataCatalog.Builder addUrl(URL value) {
            return (DataCatalog.Builder)this.addProperty("http://schema.org/url", value);
        }

        @Override
        public DataCatalog.Builder addUrl(String value) {
            return (DataCatalog.Builder)this.addProperty("http://schema.org/url", Text.of(value));
        }

        @Override
        public DataCatalog.Builder addVersion(Number value) {
            return (DataCatalog.Builder)this.addProperty("http://schema.org/version", value);
        }

        @Override
        public DataCatalog.Builder addVersion(String value) {
            return (DataCatalog.Builder)this.addProperty("http://schema.org/version", Text.of(value));
        }

        @Override
        public DataCatalog.Builder addVideo(VideoObject value) {
            return (DataCatalog.Builder)this.addProperty("http://schema.org/video", value);
        }

        @Override
        public DataCatalog.Builder addVideo(VideoObject.Builder value) {
            return (DataCatalog.Builder)this.addProperty("http://schema.org/video", value.build());
        }

        @Override
        public DataCatalog.Builder addVideo(String value) {
            return (DataCatalog.Builder)this.addProperty("http://schema.org/video", Text.of(value));
        }

        @Override
        public DataCatalog.Builder addWorkExample(CreativeWork value) {
            return (DataCatalog.Builder)this.addProperty("http://schema.org/workExample", value);
        }

        @Override
        public DataCatalog.Builder addWorkExample(CreativeWork.Builder value) {
            return (DataCatalog.Builder)this.addProperty("http://schema.org/workExample", value.build());
        }

        @Override
        public DataCatalog.Builder addWorkExample(String value) {
            return (DataCatalog.Builder)this.addProperty("http://schema.org/workExample", Text.of(value));
        }

        @Override
        public DataCatalog.Builder addDetailedDescription(Article value) {
            return (DataCatalog.Builder)this.addProperty("http://schema.googleapis.com/detailedDescription", value);
        }

        @Override
        public DataCatalog.Builder addDetailedDescription(Article.Builder value) {
            return (DataCatalog.Builder)this.addProperty("http://schema.googleapis.com/detailedDescription", value.build());
        }

        @Override
        public DataCatalog.Builder addDetailedDescription(String value) {
            return (DataCatalog.Builder)this.addProperty("http://schema.googleapis.com/detailedDescription", Text.of(value));
        }

        @Override
        public DataCatalog.Builder addPopularityScore(PopularityScoreSpecification value) {
            return (DataCatalog.Builder)this.addProperty("http://schema.googleapis.com/popularityScore", value);
        }

        @Override
        public DataCatalog.Builder addPopularityScore(PopularityScoreSpecification.Builder value) {
            return (DataCatalog.Builder)this.addProperty("http://schema.googleapis.com/popularityScore", value.build());
        }

        @Override
        public DataCatalog.Builder addPopularityScore(String value) {
            return (DataCatalog.Builder)this.addProperty("http://schema.googleapis.com/popularityScore", Text.of(value));
        }

        @Override
        public DataCatalog build() {
            return new DataCatalogImpl((Multimap<String, ValueType>)this.properties, (Multimap<String, Thing>)this.reverseMap);
        }
    }
}

